/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseIntentionPairedWithInspection
extends JavaScriptIntention {
    private final String myInspectionId;
    private final Key<Boolean> mySupplementaryKey;

    public JSBaseIntentionPairedWithInspection(@NotNull String inspectionId, @Nullable Key<Boolean> supplementaryKey) {
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/lang/javascript/intentions/JSBaseIntentionPairedWithInspection", "<init>"));
        }
        this.myInspectionId = inspectionId;
        this.mySupplementaryKey = supplementaryKey;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        boolean notAvailable;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/intentions/JSBaseIntentionPairedWithInspection", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/JSBaseIntentionPairedWithInspection", "isAvailable"));
        }
        InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
        boolean toolEnabled = profile.isToolEnabled(HighlightDisplayKey.findById((String)this.myInspectionId), element);
        boolean bl = notAvailable = toolEnabled && (this.mySupplementaryKey == null || !Boolean.TRUE.equals(element.getUserData(this.mySupplementaryKey)));
        if (notAvailable) {
            return false;
        }
        return super.isAvailable(project, editor, element);
    }
}

