/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterConfiguration<T extends JSLinterState>
implements PersistentStateComponent<Element> {
    private final Project myProject;
    private volatile ExtendedLinterState<T> myExtendedState;
    private boolean myStateElementLoaded;

    public JSLinterConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterConfiguration", "<init>"));
        }
        this.myStateElementLoaded = false;
        this.myProject = project;
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterConfiguration", "getProject"));
        }
        return project;
    }

    public final void setExtendedState(@NotNull ExtendedLinterState<T> extendedState) {
        if (extendedState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendedState", "com/intellij/lang/javascript/linter/JSLinterConfiguration", "setExtendedState"));
        }
        ExtendedLinterState<T> oldExtendedState = this.getExtendedState();
        if (extendedState.isEnabled() != oldExtendedState.isEnabled()) {
            this.setInspectionEnabled(extendedState.isEnabled());
        }
        this.savePrivateSettings(extendedState.getState());
        this.myExtendedState = extendedState;
        if (!extendedState.equals(oldExtendedState)) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    public final void setExtendedState(boolean enabled, @NotNull T state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/JSLinterConfiguration", "setExtendedState"));
        }
        this.setExtendedState(ExtendedLinterState.create(enabled, state));
    }

    protected abstract void savePrivateSettings(@NotNull T var1);

    @NotNull
    public final ExtendedLinterState<T> getExtendedState() {
        ExtendedLinterState<T> extendedLinterState = this.getExtendedState(false);
        if (extendedLinterState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterConfiguration", "getExtendedState"));
        }
        return extendedLinterState;
    }

    @NotNull
    public final ExtendedLinterState<T> getExtendedState(boolean clearCaches) {
        ExtendedLinterState<T> extendedState = this.myExtendedState;
        if (extendedState == null || clearCaches) {
            boolean enabled = this.isInspectionEnabled();
            T state = extendedState != null ? extendedState.getState() : this.getDefaultState();
            state = this.loadPrivateSettings(state);
            extendedState = ExtendedLinterState.create(enabled, state);
            this.myExtendedState = extendedState;
        }
        ExtendedLinterState<T> extendedLinterState = extendedState;
        if (extendedLinterState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterConfiguration", "getExtendedState"));
        }
        return extendedLinterState;
    }

    @NotNull
    protected abstract T loadPrivateSettings(@NotNull T var1);

    public final Element getState() {
        ExtendedLinterState<T> extendedState = this.myExtendedState;
        if (extendedState == null) {
            return null;
        }
        T state = extendedState.getState();
        if (!this.myStateElementLoaded && state.equals(this.getDefaultState())) {
            return null;
        }
        Element element = this.toXml(state);
        if (element == null && this.myStateElementLoaded) {
            element = new Element("any");
        }
        return element;
    }

    public final void loadState(Element element) {
        if (element != null) {
            this.myStateElementLoaded = true;
            T state = this.fromXml(element);
            state = this.loadPrivateSettings(state);
            this.myExtendedState = ExtendedLinterState.create(this.isInspectionEnabled(), state);
        }
    }

    private boolean isInspectionEnabled() {
        return JSLinterInspection.isToolEnabled(this.myProject, this.getInspectionClass());
    }

    private void setInspectionEnabled(boolean enabled) {
        JSLinterInspection.setToolEnabled(this.myProject, this.getInspectionClass(), enabled);
    }

    @NotNull
    protected abstract Class<? extends JSLinterInspection> getInspectionClass();

    @Nullable
    protected abstract Element toXml(@NotNull T var1);

    @NotNull
    protected abstract T fromXml(@NotNull Element var1);

    @NotNull
    protected abstract T getDefaultState();

    @NotNull
    public static <T extends JSLinterConfiguration> T getInstance(@NotNull Project project, @NotNull Class<T> configurationClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterConfiguration", "getInstance"));
        }
        if (configurationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationClass", "com/intellij/lang/javascript/linter/JSLinterConfiguration", "getInstance"));
        }
        JSLinterConfiguration jSLinterConfiguration = (JSLinterConfiguration)ServiceManager.getService((Project)project, configurationClass);
        if (jSLinterConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterConfiguration", "getInstance"));
        }
        return (T)jSLinterConfiguration;
    }
}

