/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EslintUnsavedConfigManager {
    private static final long SAVE_POSTPONE_TIMEOUT_MILLIS = 3000L;
    private static final Logger LOG = Logger.getInstance(EslintUnsavedConfigManager.class);
    private final Project myProject;
    private final FileDocumentManager myDocumentManager;
    private final Map<VirtualFile, WatchedItem> myWatchedItemByFileMap;
    private Alarm myAlarm;

    @NotNull
    public static EslintUnsavedConfigManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUnsavedConfigManager", "getInstance"));
        }
        EslintUnsavedConfigManager eslintUnsavedConfigManager = (EslintUnsavedConfigManager)ServiceManager.getService((Project)project, EslintUnsavedConfigManager.class);
        if (eslintUnsavedConfigManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUnsavedConfigManager", "getInstance"));
        }
        return eslintUnsavedConfigManager;
    }

    public EslintUnsavedConfigManager(@NotNull Project project, @NotNull FileDocumentManager documentManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUnsavedConfigManager", "<init>"));
        }
        if (documentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentManager", "com/intellij/lang/javascript/linter/eslint/EslintUnsavedConfigManager", "<init>"));
        }
        this.myWatchedItemByFileMap = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myDocumentManager = documentManager;
    }

    public boolean requestRun(@NotNull List<VirtualFile> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/eslint/EslintUnsavedConfigManager", "requestRun"));
        }
        boolean modifiedFilesFound = false;
        for (VirtualFile file : configs) {
            if (!file.isValid() || file.isDirectory() || !this.myDocumentManager.isFileModified(file)) continue;
            modifiedFilesFound = true;
            break;
        }
        if (!modifiedFilesFound) {
            return true;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (configs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/eslint/EslintUnsavedConfigManager", "lambda$requestRun$0"));
            }
            this.addFiles(configs);
        }, ModalityState.any());
        return false;
    }

    private void addFiles(@NotNull List<VirtualFile> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/eslint/EslintUnsavedConfigManager", "addFiles"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VirtualFile config : configs) {
            Document document;
            if (!config.isValid() || config.isDirectory() || !this.myDocumentManager.isFileModified(config) || this.myWatchedItemByFileMap.containsKey(config) || (document = this.myDocumentManager.getDocument(config)) == null) continue;
            this.myWatchedItemByFileMap.put(config, new WatchedItem(config, document));
        }
        this.rescheduleSave();
    }

    private void rescheduleSave() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAlarm != null) {
            this.myAlarm.cancelAllRequests();
        }
        if (this.myAlarm == null) {
            this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        }
        this.myAlarm.addRequest(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.isOkToSaveAll()) {
                this.saveAll();
            } else {
                this.rescheduleSave();
            }
        }, 3100L);
    }

    private boolean isOkToSaveAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        long currentTimeMillis = System.currentTimeMillis();
        for (WatchedItem item : this.myWatchedItemByFileMap.values()) {
            if (currentTimeMillis - item.myLastModifiedMillis >= 3000L) continue;
            return false;
        }
        return true;
    }

    private void saveAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAlarm != null) {
            Disposer.dispose((Disposable)this.myAlarm);
            this.myAlarm = null;
        }
        for (WatchedItem item : this.myWatchedItemByFileMap.values()) {
            if (item.myFile.isValid()) {
                LOG.info("Saving " + item.myFile.getPath());
                this.myDocumentManager.saveDocument(item.myDocument);
            }
            item.stop();
        }
        this.myWatchedItemByFileMap.clear();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private static class WatchedItem
    extends DocumentAdapter {
        private final VirtualFile myFile;
        private final Document myDocument;
        private long myLastModifiedMillis;

        public WatchedItem(@NotNull VirtualFile file, @NotNull Document document) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintUnsavedConfigManager$WatchedItem", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/eslint/EslintUnsavedConfigManager$WatchedItem", "<init>"));
            }
            this.myFile = file;
            this.myDocument = document;
            this.myDocument.addDocumentListener((DocumentListener)this);
            this.myLastModifiedMillis = System.currentTimeMillis();
        }

        public void documentChanged(DocumentEvent e) {
            this.myLastModifiedMillis = System.currentTimeMillis();
        }

        public void stop() {
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }
    }
}

