/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintView
extends JSLinterBaseView<EslintState> {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final TextFieldWithHistoryWithBrowseButton myEslintPackageField;
    private final JSLinterConfigFileView myConfigFileView;
    private final TextFieldWithBrowseButton myAdditionalRulesDirField;
    private final RawCommandLineEditor myExtraOptions;
    private final JPanel myCenterPanel;

    public EslintView(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintView", "<init>"));
        }
        super(fullModeDialog);
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myEslintPackageField = EslintView.createEslintPackageField(project);
        this.myConfigFileView = new JSLinterConfigFileView(project, new JSLinterConfigFileTexts(JSBundle.message((String)"eslint.configurable.config.autoSearch.title", (Object[])new Object[0]), JSBundle.message((String)"eslint.configurable.config.autoSearch.description.bodyInnerHtml", (Object[])new Object[0]), JSBundle.message((String)"eslint.configurable.config.select.config.text", (Object[])new Object[0]), "In each case, the settings in the configuration file override default settings."), null);
        this.myConfigFileView.setAdditionalConfigFilesProducer((NotNullProducer<List<VirtualFile>>)((NotNullProducer)() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintView", "lambda$new$0"));
            }
            return EslintUtil.findAllConfigsInScope(project, ProjectScope.getContentScope((Project)project));
        }));
        this.myAdditionalRulesDirField = EslintView.createAdditionalRulesDirField(project);
        this.myExtraOptions = new RawCommandLineEditor();
        this.myExtraOptions.setDialogCaption("Extra ESLint Options");
        JPanel panel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).setVerticalGap(4).setFormLeftIndent(10).addLabeledComponent("&Node interpreter:", (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent(JSBundle.message((String)"eslint.configurable.eslintPackage.label", (Object[])new Object[0]), (JComponent)this.myEslintPackageField).addComponent((JComponent)this.myConfigFileView.getComponent()).addSeparator(4).addVerticalGap(4).addComponent(EslintView.createBottomComponent(this.myAdditionalRulesDirField, this.myExtraOptions)).getPanel();
        this.myCenterPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel);
        this.myCenterPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    @NotNull
    private static JComponent createBottomComponent(@NotNull TextFieldWithBrowseButton field, @NotNull RawCommandLineEditor extraOptions) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/lang/javascript/linter/eslint/EslintView", "createBottomComponent"));
        }
        if (extraOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraOptions", "com/intellij/lang/javascript/linter/eslint/EslintView", "createBottomComponent"));
        }
        JPanel jPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).addLabeledComponent(JSBundle.message((String)"eslint.configurable.additionalRulesDir.label", (Object[])new Object[0]), (JComponent)field).addLabeledComponent(JSBundle.message((String)"eslint.configurable.extraOptions.label", (Object[])new Object[0]), (JComponent)extraOptions).getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "createBottomComponent"));
        }
        return jPanel;
    }

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createEslintPackageField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintView", "createEslintPackageField"));
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"eslint.configurable.eslintPackage.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintView", "lambda$createEslintPackageField$1"));
            }
            List<String> dirs = EslintView.detectAllEslintPackageDirs(project);
            Collections.sort(dirs);
            return dirs;
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "createEslintPackageField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private static List<String> detectAllEslintPackageDirs(Project project) {
        ArrayList modules = ContainerUtil.newArrayList();
        NodeJsLocalInterpreter interpreter = EslintConfiguration.getInstance(project).getLocalInterpreter();
        NodeModuleSearchUtil.findModulesByNameInContentRoots(modules, "eslint", project, true, NodeSettings.create(interpreter), true);
        ArrayList dirs = ContainerUtil.newArrayList();
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            dirs.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "detectAllEslintPackageDirs"));
        }
        return arrayList;
    }

    @NotNull
    private static TextFieldWithBrowseButton createAdditionalRulesDirField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintView", "createAdditionalRulesDirField"));
        }
        TextFieldWithBrowseButton field = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)field, (String)JSBundle.message((String)"eslint.configurable.additionalRulesDir.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton = field;
        if (textFieldWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "createAdditionalRulesDirField"));
        }
        return textFieldWithBrowseButton;
    }

    @Override
    @Nullable
    protected Component createTopRightComponent() {
        return null;
    }

    @Override
    @NotNull
    protected Component createCenterComponent() {
        JPanel jPanel = this.myCenterPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "createCenterComponent"));
        }
        return jPanel;
    }

    @Override
    protected void handleEnableStatusChanged(boolean enabled) {
        this.myConfigFileView.onEnabledStateChanged(enabled);
    }

    @Override
    @NotNull
    protected EslintState getState() {
        EslintState.Builder builder = new EslintState.Builder();
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setEslintPackagePath(this.myEslintPackageField.getText());
        builder.setCustomConfigFilePath(this.myConfigFileView.getCustomConfigFilePath());
        builder.setCustomConfigFileUsed(this.myConfigFileView.isCustomConfigFileUsed());
        builder.setAdditionalRulesDirPath(this.myAdditionalRulesDirField.getText());
        builder.setExtraOptions(this.myExtraOptions.getText());
        EslintState eslintState = builder.build();
        if (eslintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintView", "getState"));
        }
        return eslintState;
    }

    @Override
    protected void setState(@NotNull EslintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/eslint/EslintView", "setState"));
        }
        this.myNodeInterpreterField.setInterpreterRef(state.getInterpreterRef());
        this.myEslintPackageField.setTextAndAddToHistory(state.getEslintPackagePath());
        this.myConfigFileView.setCustomConfigFileUsed(state.isCustomConfigFileUsed());
        this.myConfigFileView.setCustomConfigFilePath(state.getCustomConfigFilePath());
        this.myAdditionalRulesDirField.setText(state.getAdditionalRulesDirPath());
        this.myExtraOptions.setText(state.getExtraOptions());
        if (this.isFullModeDialog()) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myEslintPackageField);
            this.myConfigFileView.setPreferredWidthToComponents();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithBrowseButton)this.myAdditionalRulesDirField);
        }
    }
}

