/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jscs.config;

import com.google.common.base.Charsets;
import com.intellij.lang.javascript.linter.jscs.config.JscsOption;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JscsDocumentationReader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.jscs.Jscs");
    private final Map<JscsOption, String> myDocMap;
    private final Map<String, String> myInnerOptionsData;
    private static final JscsDocumentationReader DEFAULT = new JscsDocumentationReader(Collections.emptyMap(), Collections.emptyMap());

    private JscsDocumentationReader(@NotNull Map<JscsOption, String> map, Map<String, String> data) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/lang/javascript/linter/jscs/config/JscsDocumentationReader", "<init>"));
        }
        this.myDocMap = map;
        this.myInnerOptionsData = data;
    }

    public static JscsDocumentationReader getInstance() {
        return Holder.INSTANCE;
    }

    @Nullable
    public String getDescription(@NotNull JscsOption option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/lang/javascript/linter/jscs/config/JscsDocumentationReader", "getDescription"));
        }
        return this.myDocMap.get((Object)option);
    }

    @Nullable
    public String getInnerDescription(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/linter/jscs/config/JscsDocumentationReader", "getInnerDescription"));
        }
        return this.myInnerOptionsData.get(name);
    }

    @NotNull
    private static JscsDocumentationReader parseFromXml() {
        JscsDocumentationReader jscsDocumentationReader;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            String content = JscsDocumentationReader.loadXmlContent();
            InputSource source = new InputSource(new StringReader(content));
            Document document = db.parse(source);
            jscsDocumentationReader = JscsDocumentationReader.fromDocument(document);
        }
        catch (Exception e) {
            LOG.error("Can't parse jscs documentation :(", (Throwable)e);
            JscsDocumentationReader jscsDocumentationReader2 = DEFAULT;
            if (jscsDocumentationReader2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/config/JscsDocumentationReader", "parseFromXml"));
            }
            return jscsDocumentationReader2;
        }
        if (jscsDocumentationReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/config/JscsDocumentationReader", "parseFromXml"));
        }
        return jscsDocumentationReader;
    }

    private static JscsDocumentationReader fromDocument(Document document) {
        NodeList options = document.getChildNodes();
        if (options.getLength() != 1 || !"options".equals(options.item(0).getNodeName())) {
            return DEFAULT;
        }
        Node optionsElement = options.item(0);
        NodeList optionsList = optionsElement.getChildNodes();
        HashMap<JscsOption, String> map = new HashMap<JscsOption, String>();
        HashMap<String, String> inner = new HashMap<String, String>();
        for (int i = 0; i < optionsList.getLength(); ++i) {
            Node child;
            Element descElement;
            String key;
            Node item = optionsList.item(i);
            Element childElement = (Element)ObjectUtils.tryCast((Object)item, Element.class);
            if (childElement == null || !"option".equals(childElement.getTagName()) || (key = childElement.getAttribute("key")) == null) continue;
            JscsOption option = JscsOption.safeValueOf(key);
            NodeList dList = childElement.getElementsByTagName("description");
            if (dList.getLength() != 1 || (descElement = (Element)ObjectUtils.tryCast((Object)(child = dList.item(0)), Element.class)) == null) continue;
            if (option != null) {
                map.put(option, descElement.getTextContent());
                continue;
            }
            inner.put(key, descElement.getTextContent());
        }
        return map.isEmpty() ? DEFAULT : new JscsDocumentationReader(map, inner);
    }

    @NotNull
    private static String loadXmlContent() throws IOException {
        InputStream in = JscsDocumentationReader.class.getResourceAsStream("jscs-documentation.xml");
        InputStreamReader reader = new InputStreamReader(in, Charsets.UTF_8);
        String string = FileUtil.loadTextAndClose((Reader)reader);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jscs/config/JscsDocumentationReader", "loadXmlContent"));
        }
        return string;
    }

    static /* synthetic */ JscsDocumentationReader access$100() {
        return JscsDocumentationReader.parseFromXml();
    }

    private static class Holder {
        private static final JscsDocumentationReader INSTANCE = JscsDocumentationReader.access$100();

        private Holder() {
        }
    }
}

