/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.google.common.base.Supplier;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterEditConfigFileAction;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterError;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.jshint.JSHintConfigurable;
import com.intellij.lang.javascript.linter.jshint.JSHintConfiguration;
import com.intellij.lang.javascript.linter.jshint.JSHintInspection;
import com.intellij.lang.javascript.linter.jshint.JSHintOption;
import com.intellij.lang.javascript.linter.jshint.JSHintOptionsState;
import com.intellij.lang.javascript.linter.jshint.JSHintState;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigLookupResult;
import com.intellij.lang.javascript.linter.jshint.version.JSHintVersionUtil;
import com.intellij.lang.javascript.linter.rhino.FunctionWithScope;
import com.intellij.lang.javascript.linter.rhino.RhinoFunctionManager;
import com.intellij.lang.javascript.linter.rhino.RhinoUtil;
import com.intellij.lang.javascript.linter.rhino.WrappedRhinoException;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.JavaScriptLanguageIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSHintExternalAnnotator
extends JSLinterExternalAnnotator<JSHintState> {
    private static final Logger LOG = Logger.getInstance(JSHintExternalAnnotator.class);
    private static final JSHintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new JSHintExternalAnnotator(false);
    private final Object myLock = new Object();
    private volatile Pair<String, RhinoFunctionManager> myVersionAndFunctionManager;

    @NotNull
    public static JSHintExternalAnnotator getInstanceForBatchInspection() {
        JSHintExternalAnnotator jSHintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (jSHintExternalAnnotator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "getInstanceForBatchInspection"));
        }
        return jSHintExternalAnnotator;
    }

    public JSHintExternalAnnotator() {
        this(true);
    }

    public JSHintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected JSLinterConfigurable<JSHintState> createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "createSettingsConfigurable"));
        }
        JSHintConfigurable jSHintConfigurable = new JSHintConfigurable(project, true);
        if (jSHintConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "createSettingsConfigurable"));
        }
        return jSHintConfigurable;
    }

    @Override
    protected Class<? extends JSLinterConfiguration<JSHintState>> getConfigurationClass() {
        return JSHintConfiguration.class;
    }

    @Override
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        return JSHintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "acceptPsiFile"));
        }
        return file instanceof JSFile && JSUtils.isJavaScriptFile(file);
    }

    @Override
    public JSLinterAnnotationResult<JSHintState> annotate(@NotNull JSLinterInput<JSHintState> collectedInfo) {
        if (collectedInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectedInfo", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "annotate"));
        }
        Project project = collectedInfo.getProject();
        if (project.isDisposed()) {
            return null;
        }
        Context cx = Context.enter();
        try {
            VirtualFile configFile;
            JSHintOptionsState optionsState;
            JSHintState state = collectedInfo.getState();
            RhinoFunctionManager manager = this.getFunctionManager(project, state.getVersion());
            if (manager == null) {
                JSLinterAnnotationResult<JSHintState> jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterFailResult(collectedInfo, "JSHint " + state.getVersion() + " not loaded");
                return jSLinterAnnotationResult;
            }
            VirtualFile file = collectedInfo.getPsiFile().getVirtualFile();
            if (file == null) {
                JSLinterAnnotationResult<JSHintState> jSLinterAnnotationResult = null;
                return jSLinterAnnotationResult;
            }
            boolean ignored = JSHintConfigFileUtil.isIgnored(project, file);
            if (ignored) {
                JSLinterAnnotationResult<JSHintState> jSLinterAnnotationResult = null;
                return jSLinterAnnotationResult;
            }
            if (!state.isConfigFileUsed()) {
                optionsState = state.getOptionsState();
                configFile = null;
            } else {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (!project.isDisposed()) {
                        JSHintConfigFileChangeTracker.getInstance(project).startIfNeeded();
                    }
                });
                JSHintConfigLookupResult configLookupResult = state.isCustomConfigFileUsed() ? JSHintConfigFileUtil.loadConfigByPath(state.getCustomConfigFilePath()) : JSHintConfigFileUtil.lookupConfig(project, file);
                if (configLookupResult == null) {
                    JSLinterAnnotationResult<JSHintState> jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterFailResult(collectedInfo, "JSHint config not found");
                    return jSLinterAnnotationResult;
                }
                configFile = configLookupResult.getConfigFile();
                optionsState = configLookupResult.getOptionsState();
                if (optionsState == null) {
                    String message = StringUtil.notNullize((String)configLookupResult.getErrorMessage(), (String)"Malformed JSHint config");
                    JSLinterAnnotationResult<JSHintState> jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterFailResult(collectedInfo, message, configFile);
                    return jSLinterAnnotationResult;
                }
            }
            List<JSLinterError> errors = JSHintExternalAnnotator.doLint(cx, manager, optionsState, collectedInfo.getFileContent());
            if (errors != null) {
                JSLinterAnnotationResult<JSHintState> jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterResult(collectedInfo, errors, configFile);
                return jSLinterAnnotationResult;
            }
            JSLinterAnnotationResult<JSHintState> jSLinterAnnotationResult = null;
            return jSLinterAnnotationResult;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RhinoFunctionManager getFunctionManager(@NotNull Project project, @NotNull String version) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "getFunctionManager"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "getFunctionManager"));
        }
        Pair<String, RhinoFunctionManager> pair = this.getCachedByVersion(version);
        if (pair != null) {
            return (RhinoFunctionManager)pair.getSecond();
        }
        Object object = this.myLock;
        synchronized (object) {
            Pair<String, RhinoFunctionManager> local = this.getCachedByVersion(version);
            if (local != null) {
                return (RhinoFunctionManager)local.getSecond();
            }
            RhinoFunctionManager rfm = JSHintExternalAnnotator.createRhinoFunctionManager(project, version);
            this.myVersionAndFunctionManager = Pair.create((Object)version, (Object)rfm);
            return rfm;
        }
    }

    @Nullable
    private Pair<String, RhinoFunctionManager> getCachedByVersion(@NotNull String version) {
        String aVersion;
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "getCachedByVersion"));
        }
        Pair<String, RhinoFunctionManager> versionAndFunctionManager = this.myVersionAndFunctionManager;
        if (versionAndFunctionManager != null && (aVersion = (String)versionAndFunctionManager.getFirst()).equals(version)) {
            return versionAndFunctionManager;
        }
        return null;
    }

    @Nullable
    private static RhinoFunctionManager createRhinoFunctionManager(@NotNull Project project, @NotNull String version) {
        String content;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "createRhinoFunctionManager"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "createRhinoFunctionManager"));
        }
        if (!JSHintVersionUtil.isSourceLocallyAvailable(version)) {
            JSHintExternalAnnotator.fetchSourceSync(project, version);
        }
        try {
            content = JSHintVersionUtil.loadSourceContentFromLocalDrive(version);
            if (content == null) {
                LOG.warn("No local source content found for " + version);
                return null;
            }
        }
        catch (IOException e) {
            LOG.warn("Can't load JSHint " + version, (Throwable)e);
            return null;
        }
        return new RhinoFunctionManager(new Supplier<String>(){

            public String get() {
                return content;
            }
        }, "JSHINT", version);
    }

    private static void fetchSourceSync(@NotNull Project project, @NotNull String version) {
        boolean headless;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "fetchSourceSync"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "fetchSourceSync"));
        }
        Application app = ApplicationManager.getApplication();
        boolean bl = headless = app.isUnitTestMode() || app.isCommandLine() || app.isHeadlessEnvironment();
        if (headless || app.isDispatchThread()) {
            try {
                JSHintVersionUtil.downloadSourceContent(version);
            }
            catch (IOException e) {
                LOG.warn("Can't download JSHint " + version, (Throwable)e);
            }
        } else {
            Semaphore semaphore = new Semaphore(0, true);
            UIUtil.invokeLaterIfNeeded(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "lambda$fetchSourceSync$2"));
                }
                if (version == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "lambda$fetchSourceSync$2"));
                }
                JSHintVersionUtil.downloadSourceContentUnderProgress(project, version, () -> semaphore.release());
            });
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                LOG.warn("Thread has been interrupted unexpectedly", (Throwable)e);
            }
        }
    }

    @Nullable
    private static List<JSLinterError> doLint(Context cx, @NotNull RhinoFunctionManager manager, @NotNull JSHintOptionsState optionsState, @NotNull String fileContent) throws WrappedRhinoException {
        Object status;
        Object[] args;
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "doLint"));
        }
        if (optionsState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsState", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "doLint"));
        }
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "doLint"));
        }
        NativeObject optionsNativeObject = JSHintExternalAnnotator.convertOptionsToRhinoObject(optionsState);
        Object predefObj = optionsState.getValue(JSHintOption.PREDEF);
        if (predefObj != null) {
            NativeObject predefRhinoObject = JSLinterUtil.convertPredefToRhinoMap(predefObj);
            args = new Object[]{fileContent, optionsNativeObject, predefRhinoObject};
        } else {
            args = new Object[]{fileContent, optionsNativeObject};
        }
        FunctionWithScope functionWithScope = manager.getFunctionWithScope();
        Function function = functionWithScope.getFunction();
        Scriptable scope = functionWithScope.getScope();
        try {
            status = function.call(cx, scope, scope, args);
        }
        catch (JavaScriptException e) {
            JSLinterError error;
            NativeObject nativeError = (NativeObject)ObjectUtils.tryCast((Object)e.getValue(), NativeObject.class);
            if (nativeError != null && (error = JSHintExternalAnnotator.toLinterError(nativeError)) != null) {
                return ContainerUtil.newArrayList((Object[])new JSLinterError[]{error});
            }
            throw new WrappedRhinoException((RhinoException)e);
        }
        Boolean noErrors = (Boolean)Context.jsToJava((Object)status, Boolean.class);
        if (!noErrors.booleanValue()) {
            Object errorsObj = function.get("errors", scope);
            if (errorsObj == null || errorsObj == Scriptable.NOT_FOUND) {
                throw new RuntimeException(manager.getFunctionName() + ".errors is " + errorsObj);
            }
            return JSHintExternalAnnotator.convertErrors((NativeArray)errorsObj);
        }
        return null;
    }

    @NotNull
    private static List<JSLinterError> convertErrors(@NotNull NativeArray errorsNativeArray) {
        if (errorsNativeArray == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorsNativeArray", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "convertErrors"));
        }
        ArrayList errors = ContainerUtil.newArrayListWithCapacity((int)errorsNativeArray.size());
        for (Object errorObj : errorsNativeArray) {
            JSLinterError error;
            if (!(errorObj instanceof NativeObject) || (error = JSHintExternalAnnotator.toLinterError((NativeObject)errorObj)) == null) continue;
            errors.add(error);
        }
        ArrayList arrayList = errors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "convertErrors"));
        }
        return arrayList;
    }

    @Nullable
    private static JSLinterError toLinterError(@NotNull NativeObject nativeError) {
        if (nativeError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeError", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "toLinterError"));
        }
        int line = JSHintExternalAnnotator.toInt(nativeError.get((Object)"line"));
        int character = JSHintExternalAnnotator.toInt(nativeError.get((Object)"character"));
        if (line < 0 || character < 0) {
            return null;
        }
        String code = RhinoUtil.getStringKey((ScriptableObject)nativeError, "code");
        String reason = RhinoUtil.getStringKey((ScriptableObject)nativeError, "reason");
        if (reason == null) {
            reason = RhinoUtil.getStringKey((ScriptableObject)nativeError, "message");
        }
        if (reason != null) {
            return new JSLinterError(line, character, reason, code);
        }
        return null;
    }

    private static int toInt(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return -1;
    }

    @NotNull
    private static NativeObject convertOptionsToRhinoObject(@NotNull JSHintOptionsState optionsState) {
        if (optionsState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsState", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "convertOptionsToRhinoObject"));
        }
        HashMap options = ContainerUtil.newHashMap(optionsState.getValueByOptionMap());
        options.remove(JSHintOption.PREDEF.getKey());
        NativeObject nativeObject = RhinoUtil.toRhinoMap(options);
        if (nativeObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "convertOptionsToRhinoObject"));
        }
        return nativeObject;
    }

    @Override
    public void apply(@NotNull PsiFile file, JSLinterAnnotationResult<JSHintState> annotationResult, @NotNull AnnotationHolder holder) {
        Annotation annotation;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/linter/jshint/JSHintExternalAnnotator", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        InspectionProjectProfileManager inspectionProjectProfileManager = InspectionProjectProfileManager.getInstance((Project)file.getProject());
        SeverityRegistrar severityRegistrar = inspectionProjectProfileManager.getSeverityRegistrar();
        HighlightDisplayKey inspectionKey = JSHintInspection.getHighlightDisplayKey();
        HighlightSeverity severity = JSLinterUtil.getSeverity(inspectionProjectProfileManager, inspectionKey, file);
        EditorColorsScheme colorsScheme = annotationResult.getInput().getColorsScheme();
        TextAttributes forcedTextAttributes = JSLinterUtil.getTextAttributes(colorsScheme, severityRegistrar, severity);
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        JSHintConfigurable configurable = new JSHintConfigurable(file.getProject(), true);
        Icon icon = JavaScriptLanguageIcons.FileTypes.JsHint;
        Object fix = annotationResult.getConfigFile() != null ? new JSLinterEditConfigFileAction(annotationResult.getConfigFile(), icon) : new JSLinterEditSettingsAction((JSLinterConfigurable)configurable, icon);
        JSLinterErrorBase fileErrorMessage = annotationResult.getFileWideErrorMessage();
        if (fileErrorMessage != null && (annotation = JSLinterUtil.createErrorAnnotation(holder, (PsiElement)file, fileErrorMessage.getDescription())) != null) {
            annotation.setFileLevelAnnotation(true);
            annotation.registerFix((IntentionAction)fix, null, inspectionKey);
        }
        List<JSLinterError> limitedErrors = JSLinterUtil.limitErrorsAtTheSamePosition(annotationResult.getErrors(), 10);
        int tabSize = 4;
        for (JSLinterError linterError : limitedErrors) {
            Annotation annotation2 = JSHintExternalAnnotator.createAnnotation(holder, file, document, linterError, "JSHint: ", tabSize, severity, forcedTextAttributes, inspectionKey, JSLinterExternalAnnotator.HighlightingGranularity.element);
            if (annotation2 == null) continue;
            annotation2.registerFix((IntentionAction)fix, null, inspectionKey);
        }
    }
}

