/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.AmdJsModulesSuggester;
import com.intellij.lang.javascript.modules.JSBaseModulesDependenciesElementVisitor;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmdModulesDependenciesInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(ProblemsHolder holder, LocalInspectionToolSession session) {
        MyJSElementVisitor myJSElementVisitor = new MyJSElementVisitor(session, holder, this.myOnTheFly);
        if (myJSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/modules/AmdModulesDependenciesInspection", "createVisitor"));
        }
        return myJSElementVisitor;
    }

    private static class MyJSElementVisitor
    extends JSBaseModulesDependenciesElementVisitor {
        public MyJSElementVisitor(LocalInspectionToolSession session, ProblemsHolder holder, boolean onTheFly) {
            super(session, holder, onTheFly);
        }

        @Override
        protected String getInspectionText() {
            return "Missing AMD module dependency";
        }

        @Override
        @Nullable
        protected JsModulesSuggester createSuggester() {
            if (!MyJSElementVisitor.isForBrowser(this.myNode.getProject(), this.mySession.getFile().getVirtualFile())) {
                return null;
            }
            JSAmdUtil.AmdLoaderCallOnPointers definition = JSAmdUtil.getCachedWrappingAmdDefinition((PsiElement)this.myNode);
            return definition == null ? null : new AmdJsModulesSuggester(this.mySession, this.myModuleReferenceInfo, this.myNode, definition.toCall());
        }
    }
}

