/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.nashorn.resolve;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NashornJSReferenceExpressionResolver
extends JSReferenceExpressionResolver {
    public NashornJSReferenceExpressionResolver(JSReferenceExpressionImpl expression, PsiFile file) {
        super(expression, file);
    }

    @Override
    protected ResolveResult[] getResultsFromProcessor(WalkUpResolveProcessor processor) {
        List<WalkUpResolveProcessor.TaggedResolveResult> taggedResolveResults = processor.getTaggedResolveResults();
        if (taggedResolveResults.isEmpty() || taggedResolveResults.get(0).hasTag(WalkUpResolveProcessor.ResolveResultTag.PARTIAL)) {
            Module module;
            if (JSSymbolUtil.isAccurateReferenceExpression(this.myRef)) {
                PsiElement qualifierResolve;
                if (this.myQualifier instanceof JSReferenceExpression && (qualifierResolve = ((JSReferenceExpression)this.myQualifier).resolve()) instanceof PsiClass) {
                    List<ResolveResult> results = this.resolveInPsiClass((PsiClass)qualifierResolve, true);
                    return results.isEmpty() ? ResolveResult.EMPTY_ARRAY : results.toArray(new ResolveResult[results.size()]);
                }
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myContainingFile.getProject());
                module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myContainingFile);
                JSQualifiedName qualifiedName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)this.myRef);
                if (qualifiedName != null) {
                    qualifiedName = ((JSQualifiedNameImpl)qualifiedName).withoutInnermostComponent("Packages");
                }
                if (qualifiedName != null) {
                    PsiClass aClass;
                    String qName = qualifiedName.getQualifiedName();
                    if (module != null && (aClass = psiFacade.findClass(qName, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) != null) {
                        return new ResolveResult[]{new JSResolveResult((PsiElement)aClass)};
                    }
                    PsiPackage aPackage = psiFacade.findPackage(qName);
                    if (aPackage != null) {
                        return new ResolveResult[]{new JSResolveResult((PsiElement)aPackage)};
                    }
                }
            }
            BaseJSSymbolProcessor.TypeInfo typeInfo = processor.getTypeInfo();
            if (!typeInfo.myContextLevels.isEmpty() && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myContainingFile)) != null) {
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myContainingFile.getProject());
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                SmartList javaResults = new SmartList();
                boolean contextResolvesToJavaClass = false;
                for (BaseJSSymbolProcessor.TypeInfo.ContextLevel level : typeInfo.myContextLevels) {
                    PsiClass aClass;
                    JSQualifiedName qualifiedName = level.myNamespace.getQualifiedName();
                    if (level.myRelativeLevel != 0 || qualifiedName == null || (aClass = psiFacade.findClass(qualifiedName.getQualifiedName(), scope)) == null) continue;
                    contextResolvesToJavaClass = true;
                    List<ResolveResult> results = this.resolveInPsiClass(aClass, level.myNamespace.getJSContext() == JSContext.STATIC);
                    javaResults.addAll(results);
                }
                if (contextResolvesToJavaClass) {
                    return javaResults.isEmpty() ? ResolveResult.EMPTY_ARRAY : javaResults.toArray(new ResolveResult[javaResults.size()]);
                }
            }
        }
        return WalkUpResolveProcessor.convertResults(taggedResolveResults);
    }

    @NotNull
    private List<ResolveResult> resolveInPsiClass(PsiClass aClass, boolean isStatic) {
        PsiMethod[] candidates;
        SmartList results = new SmartList();
        if (this.myParent instanceof JSCallExpression) {
            candidates = aClass.findMethodsByName(this.myReferencedName, true);
        } else {
            PsiMember[] psiMemberArray;
            PsiField candidate = aClass.findFieldByName(this.myReferencedName, true);
            if (candidate == null) {
                PsiMethod[] accessors;
                boolean isSetter = this.myParent instanceof JSDefinitionExpression;
                String prefix = isSetter ? "set" : "get";
                String accessorName = prefix + StringUtil.capitalize((String)this.myReferencedName);
                for (PsiMethod accessor : accessors = aClass.findMethodsByName(accessorName, true)) {
                    int parametersCount = accessor.getParameterList().getParametersCount();
                    if (parametersCount != (isSetter ? 1 : 0)) continue;
                    candidate = accessor;
                    break;
                }
            }
            if (candidate == null) {
                candidate = aClass.findInnerClassByName(this.myReferencedName, true);
            }
            if (candidate != null) {
                PsiModifierListOwner[] psiModifierListOwnerArray = new PsiModifierListOwner[1];
                psiMemberArray = psiModifierListOwnerArray;
                psiModifierListOwnerArray[0] = candidate;
            } else {
                psiMemberArray = PsiMember.EMPTY_ARRAY;
            }
            candidates = psiMemberArray;
        }
        for (PsiMethod candidate : candidates) {
            boolean hasStaticModifier = candidate.hasModifierProperty("static");
            String resolveProblem = isStatic && !hasStaticModifier ? "javascript.instance.member.is.not.accessible.message" : (!isStatic && hasStaticModifier ? "javascript.static.member.is.not.accessible.message" : (!candidate.hasModifierProperty("public") ? "javascript.element.is.not.accessible.message" : null));
            JSResolveResult resolveResult = resolveProblem == null ? new JSResolveResult((PsiElement)candidate) : new JSResolveResult((PsiElement)candidate, null, resolveProblem);
            results.add(resolveResult);
        }
        SmartList smartList = results;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/nashorn/resolve/NashornJSReferenceExpressionResolver", "resolveInPsiClass"));
        }
        return smartList;
    }
}

