/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGlobalTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeUtils {
    @Nullable
    public static PsiElement getScopeInOriginalTree(@NotNull PsiElement scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/psi/JSTypeUtils", "getScopeInOriginalTree"));
        }
        if (scope instanceof ImplicitJSVariableImpl) {
            return scope;
        }
        PsiElement originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)scope);
        if (originalElement != null) {
            return originalElement;
        }
        PsiElement someElementAtOriginalTree = scope.getContainingFile().getOriginalFile().findElementAt(scope.getTextRange().getStartOffset());
        return someElementAtOriginalTree;
    }

    private JSTypeUtils() {
    }

    public static String transformActionScriptSpecificTypesIntoEcma(String type) {
        if ("int".equals(type) || "uint".equals(type)) {
            type = "Number";
        }
        return type;
    }

    public static boolean isNewPropertiesDefinitionAllowed(@Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) == null || type instanceof JSAnyType || type instanceof JSObjectType || type instanceof JSPrimitiveArrayType || type instanceof JSPrimitiveFunctionType || type instanceof JSFunctionTypeImpl) {
            return true;
        }
        if (type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.INSTANCE) {
            return false;
        }
        return !type.getSource().isExplicitlyDeclared();
    }

    public static boolean isStrictType(@Nullable JSType type) {
        return type != null && type.getSource().isExplicitlyDeclared() && !(type instanceof JSAnyType) && !(type instanceof JSObjectType);
    }

    @Nullable
    public static JSType createType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/JSTypeUtils", "createType"));
        }
        return JSTypeUtils.createType(typeString, source, false);
    }

    @Nullable
    public static JSType createType(@Nullable String typeString, @NotNull JSTypeSource source, boolean allowCommentAfterType) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/JSTypeUtils", "createType"));
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser = new JSTypeParser(typeString, source);
        return parser.parse(allowCommentAfterType);
    }

    @Nullable
    public static JSParameterTypeDecorator createParameterType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/JSTypeUtils", "createParameterType"));
        }
        return JSTypeUtils.createParameterType(typeString, source, false);
    }

    @Nullable
    public static JSParameterTypeDecorator createParameterType(@Nullable String typeString, @NotNull JSTypeSource source, boolean allowCommentAfterType) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/JSTypeUtils", "createParameterType"));
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser = new JSTypeParser(typeString, source);
        return parser.parseParameterType(allowCommentAfterType);
    }

    public static boolean isArrayType(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "isArrayType"));
        }
        return JSTypeUtils.getComponentType(type) != null;
    }

    public static boolean isMapType(@NotNull JSType type) {
        JSType baseType;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "isMapType"));
        }
        if (type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getArguments().size() == 2 && (baseType = ((JSGenericTypeImpl)type).getType()) instanceof JSNamedType) {
            String typeText = baseType.getTypeText(JSType.TypeTextFormat.SIMPLE);
            return "Array".equals(typeText) || "Object".equals(typeText) || "Map".equals(typeText) || "WeakMap".equals(typeText);
        }
        return false;
    }

    @Nullable
    public static JSType getPromiseComponentType(@NotNull JSType type) {
        List<JSType> arguments;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "getPromiseComponentType"));
        }
        if (type instanceof JSGenericTypeImpl && (arguments = ((JSGenericTypeImpl)type).getArguments()).size() >= 1) {
            return (JSType)ContainerUtil.getFirstItem(arguments);
        }
        return type;
    }

    @Nullable
    public static JSType getComponentType(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "getComponentType"));
        }
        if (type instanceof JSArrayTypeImpl) {
            return ((JSArrayTypeImpl)type).getType();
        }
        if (type instanceof JSPrimitiveArrayType) {
            return JSAnyType.get((PsiElement)type.getSource().getScope(), false);
        }
        if (type instanceof JSGenericTypeImpl) {
            String s;
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            JSType baseType = genericType.getType();
            List<JSType> genericArguments = genericType.getArguments();
            if (baseType instanceof JSNamedType && !genericArguments.isEmpty() && ((s = baseType.getTypeText(JSType.TypeTextFormat.SIMPLE)).equals("Vector") || s.equals("Array") || s.equals("Object") || s.equals("Iterable") || s.equals("Iterator") || s.equals("IterableIterator") || s.equals("Set") || s.equals("WeakSet"))) {
                return genericArguments.get(genericArguments.size() - 1);
            }
            return null;
        }
        if (type instanceof JSRecordType) {
            for (JSRecordType.TypeMember member : ((JSRecordType)type).getTypeMembers()) {
                if (!(member instanceof JSRecordType.IndexSignature)) continue;
                return ((JSRecordType.IndexSignature)member).getType();
            }
        }
        return null;
    }

    @Nullable
    public static JSType getIterableComponentType(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "getIterableComponentType"));
        }
        if (type instanceof JSAnyType || type instanceof JSNullType) {
            return type;
        }
        JSType realType = JSTypeUtils.getValuableType(type);
        JSType componentType = JSTypeUtils.getComponentType(realType);
        if (componentType == null) {
            JSRecordType recordType = realType.asRecordType();
            for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
                JSRecordType.PropertySignature propertySignature;
                JSType genericType;
                if (!(member instanceof JSRecordType.PropertySignature) || (genericType = JSTypeUtils.getIteratorComponentType((propertySignature = (JSRecordType.PropertySignature)member).getName(), propertySignature.getType())) == null) continue;
                return genericType;
            }
        }
        return componentType;
    }

    @Nullable
    private static JSType getIteratorComponentType(String name, JSType iteratorType) {
        if ("Symbol.iterator".equals(name)) {
            JSGenericTypeImpl genericType;
            if (iteratorType instanceof JSFunctionTypeImpl) {
                iteratorType = ((JSFunctionTypeImpl)iteratorType).getReturnType();
            }
            if (iteratorType instanceof JSGenericTypeImpl && "Iterator".equals((genericType = (JSGenericTypeImpl)iteratorType).getType().getTypeText(JSType.TypeTextFormat.SIMPLE))) {
                return (JSType)ContainerUtil.getFirstItem(genericType.getArguments());
            }
        }
        return null;
    }

    public static boolean typeCanBeAssignedWithoutCoercion(@NotNull JSType lOpType, @Nullable JSType rOpType) {
        if (lOpType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lOpType", "com/intellij/lang/javascript/psi/JSTypeUtils", "typeCanBeAssignedWithoutCoercion"));
        }
        if (lOpType instanceof JSNumberType) {
            return rOpType instanceof JSIntType || rOpType instanceof JSNumberType || rOpType instanceof JSUintType;
        }
        if (lOpType instanceof JSIntType || lOpType instanceof JSUintType) {
            return rOpType instanceof JSIntType || rOpType instanceof JSUintType;
        }
        if (lOpType instanceof JSObjectType) {
            return true;
        }
        if (lOpType instanceof JSSpecialNamedTypeImpl || lOpType instanceof JSUndefinedType || lOpType instanceof JSNullType || lOpType instanceof JSVoidType) {
            return lOpType.isEquivalentTo(rOpType, null);
        }
        if (lOpType instanceof JSCompositeTypeImpl) {
            boolean anyTypeCanBeAssignedWithoutCoercion = false;
            for (JSType lOpTypePart : ((JSCompositeTypeImpl)lOpType).getTypes()) {
                anyTypeCanBeAssignedWithoutCoercion |= JSTypeUtils.typeCanBeAssignedWithoutCoercion(lOpTypePart, rOpType);
            }
            return anyTypeCanBeAssignedWithoutCoercion;
        }
        return rOpType != null && !(rOpType instanceof JSAnyType) && !(rOpType instanceof JSObjectType) && !(rOpType instanceof JSUndefinedType) && !(rOpType instanceof JSNullType) && !(rOpType instanceof JSVoidType);
    }

    @NotNull
    public static String getTypeMatchingNamespace(@NotNull String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "getTypeMatchingNamespace"));
        }
        JSType jsType = JSTypeUtils.createType(type, JSTypeSource.EMPTY_TS);
        if (jsType == null) {
            String string = type;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getTypeMatchingNamespace"));
            }
            return string;
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(jsType, false);
        String string = qName != null ? qName : type;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getTypeMatchingNamespace"));
        }
        return string;
    }

    @Nullable
    public static String getQualifiedNameMatchingType(@NotNull JSType type, boolean resolved) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "getQualifiedNameMatchingType"));
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getQualifiedNameMatchingType(((JSGenericTypeImpl)type).getType(), resolved);
        }
        if (type instanceof JSArrayTypeImpl) {
            return "Array";
        }
        if (type instanceof JSNullType || type instanceof JSUndefinedType) {
            return null;
        }
        if (type instanceof JSStringType) {
            return "String";
        }
        if (type instanceof JSNumberType) {
            return "Number";
        }
        if (type instanceof JSBooleanType || type instanceof TypeScriptTypePredicateTypeImpl) {
            return "Boolean";
        }
        if (type instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
            if (constraintType == null) {
                return null;
            }
            return JSTypeUtils.getQualifiedNameMatchingType(constraintType, resolved);
        }
        if (type instanceof JSFunctionTypeImpl) {
            return "Function";
        }
        if (type instanceof JSNamedType) {
            String text = type.getTypeText(resolved ? JSType.TypeTextFormat.RESOLVED : JSType.TypeTextFormat.SIMPLE);
            return StringUtil.replace((String)text, (String)"prototype.", (String)"");
        }
        if (type instanceof JSGlobalTypeImpl) {
            return "";
        }
        return null;
    }

    @Nullable
    public static JSNamespace getNamespaceMatchingType(@NotNull JSType type, boolean resolved, boolean forcedExplicitlyDeclared) {
        JSTypeSubstitutor typeSubstitutor;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "getNamespaceMatchingType"));
        }
        String qualifiedName = JSTypeUtils.getQualifiedNameMatchingType(type = JSTypeUtils.unwrapDecorations(type), resolved);
        if (qualifiedName == null) {
            return null;
        }
        JSContext context = type instanceof JSNamedType ? ((JSNamedType)type).isStaticOrInstance() : JSContext.UNKNOWN;
        boolean explicitlyDeclared = forcedExplicitlyDeclared || type.getSource().isExplicitlyDeclared();
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromNamepath(qualifiedName);
        PsiElement sourceElement = type.getSource().getSourceElement();
        JSNamespaceImpl namespace = new JSNamespaceImpl(name, context, explicitlyDeclared);
        if (type instanceof JSGenericTypeImpl && sourceElement != null && (typeSubstitutor = JSGenericTypesEvaluator.findTypeArgumentsForClassInHierarchy(type, name, sourceElement)) != JSTypeSubstitutor.EMPTY) {
            namespace.putUserData(JSNamespace.GENERIC_ARGUMENTS_KEY, typeSubstitutor);
        }
        return namespace;
    }

    @Nullable
    public static JSNamedType getNamedType(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "getNamedType"));
        }
        if (type instanceof JSNamedType) {
            return (JSNamedType)type;
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getNamedType(((JSGenericTypeImpl)type).getType());
        }
        return null;
    }

    @NotNull
    public static JSType getNonValueType(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "getNonValueType"));
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            JSStringType jSStringType = new JSStringType(true, type.getSource(), JSTypeContext.INSTANCE);
            if (jSStringType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getNonValueType"));
            }
            return jSStringType;
        }
        JSType jSType = type;
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getNonValueType"));
        }
        return jSType;
    }

    @Nullable
    public static String getPresentableType(@Nullable JSType type, boolean resolved) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            return ((JSStringLiteralTypeImpl)type).isEcma() || resolved ? "String" : "string";
        }
        return resolved ? type.getResolvedTypeText() : type.getTypeText();
    }

    @NotNull
    public static String getNonEmptyPresentableType(@Nullable JSType type) {
        String string = type == null ? "<unknown>" : type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getNonEmptyPresentableType"));
        }
        return string;
    }

    public static boolean hasFunctionType(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "hasFunctionType"));
        }
        return JSTypeUtils.hasFunctionType(type, false, false);
    }

    public static boolean hasConstructorType(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "hasConstructorType"));
        }
        return JSTypeUtils.hasFunctionType(type, false, true);
    }

    private static boolean hasFunctionType(@NotNull JSType _type, boolean typedefsExpanded, boolean includeConstructorSignatures) {
        if (_type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_type", "com/intellij/lang/javascript/psi/JSTypeUtils", "hasFunctionType"));
        }
        return !JSTypeUtils.getFunctionType(_type, typedefsExpanded, includeConstructorSignatures, null).isEmpty();
    }

    @NotNull
    public static Collection<JSType> getFunctionType(@Nullable JSType _type, boolean includeConstructorSignatures) {
        if (_type == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
            }
            return list;
        }
        Collection<JSType> collection = JSTypeUtils.getFunctionType(_type, false, includeConstructorSignatures, null);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
        }
        return collection;
    }

    @NotNull
    private static Collection<JSType> getFunctionType(@NotNull JSType _type, boolean typedefsExpanded, boolean includeConstructorSignatures, @Nullable Collection<String> visited) {
        JSType substitute;
        if (_type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_type", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
        }
        JSType type = _type;
        if ((type = JSTypeUtils.getValuableType(type)) instanceof JSFunctionTypeImpl || type instanceof JSPrimitiveFunctionType || JSTypeCastUtil.isAlwaysAssignableType(type)) {
            List list = ContainerUtil.createMaybeSingletonList((Object)type);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
            }
            return list;
        }
        if (visited != null && !visited.add((String)type.getResolvedTypeText())) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
            }
            return list;
        }
        if (type instanceof JSArrayType) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
            }
            return list;
        }
        if (type instanceof JSCompositeTypeBaseImpl) {
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            for (JSType jsType : ((JSCompositeTypeBaseImpl)type).getTypes()) {
                Collection<JSType> functionType2 = JSTypeUtils.getFunctionType(jsType, typedefsExpanded, includeConstructorSignatures, visited);
                if (functionType2.isEmpty()) continue;
                Collection<JSType> collection = functionType2;
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
                }
                return collection;
            }
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
            }
            return list;
        }
        if (type instanceof JSTypeImpl) {
            Collection<TypeScriptInterface> context;
            JSType typedefType;
            JSTypeImpl typeImpl = (JSTypeImpl)type;
            JSTypeSource source = type.getSource();
            if (!typedefsExpanded && source.isExplicitlyDeclared() && (typedefType = JSTypeEvaluateManager.expandTypedefs((PsiElement)source.getScope(), type.getResolvedTypeText())) != null) {
                Collection<JSType> collection = JSTypeUtils.getFunctionType(typedefType, true, includeConstructorSignatures, visited);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
                }
                return collection;
            }
            if (((JSTypeImpl)type).inheritsFunction()) {
                List list = ContainerUtil.createMaybeSingletonList((Object)type);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
                }
                return list;
            }
            if (source.getLanguage() == JSTypeSource.SourceLanguage.JS && typeImpl.getTypeContext() != JSTypeContext.STATIC && (context = JSTypeUtils.getTypeScriptInterfaceInJavaScriptContext(type)).size() > 0) {
                ArrayList result = ContainerUtil.newArrayList();
                for (TypeScriptInterface anInterface : context) {
                    result.addAll(ContainerUtil.mapNotNull(TypeScriptPsiUtil.getCallSignatures(anInterface, includeConstructorSignatures), function -> TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl(function)));
                }
                ArrayList arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
                }
                return arrayList;
            }
        } else {
            Collection<JSType> baseFunctionTypes;
            if (type instanceof JSRecordType) {
                List result = ContainerUtil.newSmartList();
                for (JSRecordType.TypeMember typeMember : ((JSRecordType)type).getTypeMembers()) {
                    if (!(typeMember instanceof JSRecordType.CallSignature) || ((JSRecordType.CallSignature)typeMember).hasNew() != includeConstructorSignatures) continue;
                    result.add(((JSRecordType.CallSignature)typeMember).getFunctionType());
                }
                List list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
                }
                return list;
            }
            if (type instanceof JSGenericTypeImpl && !(baseFunctionTypes = JSTypeUtils.getFunctionType(((JSGenericTypeImpl)type).getType(), typedefsExpanded, includeConstructorSignatures, visited)).isEmpty()) {
                JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
                List list = ContainerUtil.map(baseFunctionTypes, functionType -> new JSGenericTypeImpl(genericType.getSource(), (JSType)functionType, genericType.getArguments(), genericType.getOuterArguments()));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
                }
                return list;
            }
        }
        if ((substitute = type.substitute()) != type) {
            Collection<JSType> collection = JSTypeUtils.getFunctionType(substitute, typedefsExpanded, includeConstructorSignatures, visited);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getFunctionType"));
        }
        return list;
    }

    @NotNull
    public static Collection<TypeScriptInterface> getTypeScriptInterfaceInJavaScriptContext(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "getTypeScriptInterfaceInJavaScriptContext"));
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        if (sourceElement == null || qName == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getTypeScriptInterfaceInJavaScriptContext"));
            }
            return list;
        }
        boolean isTypeScriptSource = DialectDetector.isTypeScript(sourceElement);
        JSTypeResolveResult result = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler().resolveTypeName(qName, sourceElement);
        if (!isTypeScriptSource && result.hasElements()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getTypeScriptInterfaceInJavaScriptContext"));
            }
            return list;
        }
        if (isTypeScriptSource) {
            List list = ContainerUtil.mapNotNull(result.getElements(), TypeScriptUtil.TYPESCRIPT_INTERFACE_FILTER);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getTypeScriptInterfaceInJavaScriptContext"));
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull(JSDialectSpecificHandlersFactory.forElement(sourceElement).getClassResolver().findElementsByQName(qName, (GlobalSearchScope)new DelegatingGlobalSearchScope(GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)JSResolveUtil.getResolveScope(sourceElement), (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/JSTypeUtils$1", "contains"));
                }
                if (!super.contains(file)) {
                    return false;
                }
                return !JavaScriptIndex.LIBS_D_TS.contains(file.getName());
            }
        }), TypeScriptUtil.TYPESCRIPT_INTERFACE_FILTER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getTypeScriptInterfaceInJavaScriptContext"));
        }
        return list;
    }

    public static boolean hasAnyType(@NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "hasAnyType"));
        }
        if (type instanceof JSAnyType) {
            return true;
        }
        if (type instanceof JSCompositeTypeImpl) {
            return JSTypeUtils.hasAnyType(((JSCompositeTypeImpl)type).getTypes());
        }
        if (type instanceof JSTypeofTypeImpl) {
            return JSTypeUtils.hasAnyType(((JSTypeofTypeImpl)type).evaluateType());
        }
        return false;
    }

    public static boolean hasAnyType(@NotNull Collection<JSType> types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/psi/JSTypeUtils", "hasAnyType"));
        }
        for (JSType type : types) {
            if (!JSTypeUtils.hasAnyType(type)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static JSType tryGetReturnType(@NotNull JSType functionType, @NotNull JSCallExpression callExpression) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "com/intellij/lang/javascript/psi/JSTypeUtils", "tryGetReturnType"));
        }
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/JSTypeUtils", "tryGetReturnType"));
        }
        return JSTypeUtils.tryGetReturnType(functionType, callExpression, null);
    }

    @Nullable
    private static JSType tryGetReturnType(@NotNull JSType functionType, @NotNull JSCallExpression callExpression, @Nullable Collection<String> visitedTypes) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "com/intellij/lang/javascript/psi/JSTypeUtils", "tryGetReturnType"));
        }
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/JSTypeUtils", "tryGetReturnType"));
        }
        return JSTypeUtils.tryGetReturnType(functionType, null, callExpression, visitedTypes);
    }

    @Nullable
    private static JSType tryGetReturnType(@NotNull JSType functionType, @Nullable Pair<List<JSType>, Ref<Boolean>> generics, @NotNull JSCallExpression callExpression, @Nullable Collection<String> visitedTypes) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "com/intellij/lang/javascript/psi/JSTypeUtils", "tryGetReturnType"));
        }
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/psi/JSTypeUtils", "tryGetReturnType"));
        }
        boolean isNew = callExpression instanceof JSNewExpression;
        if (functionType instanceof JSFunctionTypeImpl) {
            return isNew ? ((JSFunctionTypeImpl)functionType).getNewType() : ((JSFunctionTypeImpl)functionType).getReturnType();
        }
        if (functionType instanceof JSRecordType) {
            ArrayList<JSType> argumentTypes = null;
            for (JSRecordType.TypeMember typeMember : ((JSRecordType)functionType).getTypeMembers()) {
                JSFunctionTypeImpl type;
                boolean typescript;
                if (!(typeMember instanceof JSRecordType.CallSignature)) continue;
                if (argumentTypes == null) {
                    argumentTypes = new ArrayList<JSType>();
                    for (JSExpression expression : callExpression.getArguments()) {
                        argumentTypes.add(JSResolveUtil.getExpressionJSType(expression));
                    }
                }
                boolean bl = typescript = (type = (JSFunctionTypeImpl)((JSRecordType.CallSignature)typeMember).getFunctionType()).getSource().getLanguage() == JSTypeSource.SourceLanguage.TS;
                if (!JSTypeUtils.areArgumentsAssignable(type.getParameters(), JSTypeUtils.getParameterTypeDecorators(argumentTypes), new ProcessingContext(), false, false, typescript)) continue;
                JSType resultType = isNew && !((JSRecordType.CallSignature)typeMember).hasNew() ? type.getNewType() : type.getReturnType();
                PsiElement sourceElement = type.getSource().getSourceElement();
                if (sourceElement instanceof TypeScriptTypeParameterListOwner) {
                    TypeScriptTypeParameterList list = ((TypeScriptTypeParameterListOwner)sourceElement).getTypeParameterList();
                    if (list != null && list.getTypeParameters().length > 0) {
                        if (generics != null && resultType != null && !((Boolean)((Ref)generics.second).get()).booleanValue()) {
                            JSTypeSubstitutor arguments = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(list, (List)generics.first);
                            if (arguments != null) {
                                ((Ref)generics.second).set((Object)true);
                                return JSTypeUtils.applyGenericArguments(resultType, (Map<String, JSType>)arguments);
                            }
                        } else if (resultType != null && callExpression instanceof TypeScriptNewExpression && !JSTypeUtils.hasTypeArguments(callExpression)) {
                            resultType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(resultType, callExpression.getMethodExpression(), sourceElement);
                        }
                    } else if (generics != null && ((List)generics.first).size() > 0) continue;
                }
                return resultType;
            }
        } else if (functionType instanceof JSTypeImpl) {
            JSTypeSource source = functionType.getSource();
            JSType returnTypeFromRecord = JSTypeUtils.tryGetReturnType((JSType)TypeScriptTypeParser.buildResolvedType(functionType), generics, callExpression, visitedTypes);
            if (source.isTypeScript()) {
                if (returnTypeFromRecord != null) {
                    return returnTypeFromRecord;
                }
                if (isNew) {
                    return JSNamedType.createType(functionType.getTypeText(JSType.TypeTextFormat.SIMPLE), functionType.getSource(), JSContext.INSTANCE);
                }
                return JSAnyType.get((PsiElement)callExpression, false);
            }
            if (source.isExplicitlyDeclared()) {
                String resolvedTypeText = functionType.getResolvedTypeText();
                JSType typedefType = JSTypeEvaluateManager.expandTypedefs((PsiElement)source.getScope(), resolvedTypeText);
                if (typedefType != null) {
                    if (visitedTypes == null) {
                        visitedTypes = ContainerUtil.newHashSet();
                    }
                    if (visitedTypes.add(resolvedTypeText)) {
                        return JSTypeUtils.tryGetReturnType(typedefType, generics, callExpression, visitedTypes);
                    }
                }
            }
            if (isNew) {
                return JSNamedType.createType(functionType.getTypeText(JSType.TypeTextFormat.SIMPLE), functionType.getSource(), JSContext.INSTANCE);
            }
        } else if (functionType instanceof JSCompositeTypeBaseImpl) {
            JSCompositeTypeBaseImpl type = (JSCompositeTypeBaseImpl)functionType;
            JSType resolvedType = type.substitute();
            if (resolvedType != type) {
                return JSTypeUtils.tryGetReturnType(resolvedType, generics, callExpression, visitedTypes);
            }
        } else if (functionType instanceof JSGenericTypeImpl) {
            Ref ref;
            List<JSType> arguments;
            Pair pair;
            JSType type;
            JSType substitute = functionType.substitute();
            if (substitute != functionType && (type = JSTypeUtils.tryGetReturnType(substitute, generics, callExpression, visitedTypes)) != null) {
                return type;
            }
            JSType innerType = ((JSGenericTypeImpl)functionType).getType();
            JSType innerReturnType = JSTypeUtils.tryGetReturnType(innerType, (Pair<List<JSType>, Ref<Boolean>>)(pair = Pair.create(arguments = ((JSGenericTypeImpl)functionType).getArguments(), (Object)(ref = Ref.create((Object)false)))), callExpression, visitedTypes);
            if (innerReturnType != null) {
                Boolean genericsApplied = (Boolean)((Ref)pair.second).get();
                if (genericsApplied.booleanValue()) {
                    return innerReturnType;
                }
                return new JSGenericTypeImpl(functionType.getSource(), innerReturnType, ((JSGenericTypeImpl)functionType).getArguments());
            }
        }
        return null;
    }

    public static boolean hasTypeArguments(@NotNull JSCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/JSTypeUtils", "hasTypeArguments"));
        }
        if (expression instanceof TypeScriptNewExpression) {
            TypeScriptNewExpression newExpression = (TypeScriptNewExpression)expression;
            TypeScriptTypeArgumentList arguments = newExpression.getTypeArguments();
            return arguments != null && arguments.getTypeArguments().length > 0;
        }
        return false;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSType getValuableType(@Nullable JSType type) {
        return JSTypeUtils.getValuableType(type, false);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    private static JSType getValuableType(@Nullable JSType type, boolean typedefExpanded) {
        if (type == null) {
            return null;
        }
        JSTypeSource source = type.getSource();
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSTypeImpl && !typedefExpanded) {
            JSType typedefValue;
            if (source.isExplicitlyDeclared() && source.getLanguage() == JSTypeSource.SourceLanguage.JS && (typedefValue = JSTypeEvaluateManager.expandTypedefs((PsiElement)source.getScope(), type.getTypeText())) != null) {
                return JSTypeUtils.getValuableType(typedefValue, true);
            }
        } else if (type instanceof JSTypeofTypeImpl) {
            return JSTypeUtils.getValuableType(((JSTypeofTypeImpl)type).evaluateType(), typedefExpanded);
        }
        return type;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSType unwrapDecorations(@Nullable JSType type) {
        if (type instanceof JSDecoratedTypeImpl) {
            return JSTypeUtils.unwrapDecorations(((JSDecoratedTypeImpl)type).getType());
        }
        return type;
    }

    public static boolean canBeCalledWithArguments(@Nullable JSType functionType, List<JSType> arguments, boolean inNewExpression) {
        JSType substitute;
        if (functionType == null || functionType instanceof JSAnyType || functionType instanceof JSPrimitiveFunctionType || functionType instanceof JSNullType && functionType.getSource().isTypeScript()) {
            return true;
        }
        if (functionType instanceof JSFunctionTypeImpl) {
            boolean typescript = ((JSFunctionTypeImpl)functionType).isTypeScript();
            return JSTypeUtils.areArgumentsAssignable(((JSFunctionTypeImpl)functionType).getParameters(), JSTypeUtils.getParameterTypeDecorators(arguments), new ProcessingContext(), false, false, typescript);
        }
        if (functionType instanceof JSCompositeTypeImpl) {
            for (JSType type : ((JSCompositeTypeImpl)functionType).getTypes()) {
                if (!JSTypeUtils.canBeCalledWithArguments(type, arguments, inNewExpression)) continue;
                return true;
            }
        } else if (functionType instanceof JSRecordType) {
            for (JSRecordType.TypeMember typeMember : ((JSRecordType)functionType).getTypeMembers()) {
                if (!(typeMember instanceof JSRecordType.CallSignature) || ((JSRecordType.CallSignature)typeMember).hasNew() != inNewExpression || !JSTypeUtils.canBeCalledWithArguments(((JSRecordType.CallSignature)typeMember).getFunctionType(), arguments, inNewExpression)) continue;
                return true;
            }
        }
        if ((substitute = functionType.substitute()) != functionType) {
            return JSTypeUtils.canBeCalledWithArguments(substitute, arguments, inNewExpression);
        }
        return false;
    }

    @Deprecated
    @Contract(value="!null -> !null")
    public static JSType resolveType(@Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) != null && type.getSource().getLanguage() == JSTypeSource.SourceLanguage.TS) {
            return type.substitute();
        }
        return type;
    }

    public static boolean areArgumentsAssignable(@NotNull List<JSParameterTypeDecorator> parameters, @Nullable List<JSParameterTypeDecorator> arguments, ProcessingContext processingContext, boolean functionAssignment, boolean jsDocFunctionAssignment, boolean typescript) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/javascript/psi/JSTypeUtils", "areArgumentsAssignable"));
        }
        if (arguments == null) {
            return parameters.isEmpty();
        }
        Iterator<JSParameterTypeDecorator> paramIterator = parameters.iterator();
        Iterator<JSParameterTypeDecorator> argIterator = arguments.iterator();
        Ref paramRestType = null;
        Ref argRestType = null;
        boolean remainingArgumentsAreOptional = false;
        boolean remainingParametersAreOptional = false;
        while (paramIterator.hasNext() || argIterator.hasNext()) {
            JSType argument;
            JSType parameter;
            JSParameterTypeDecorator parameterTypeDecorator = null;
            boolean hasParameter = true;
            if (paramIterator.hasNext()) {
                parameterTypeDecorator = paramIterator.next();
                parameter = parameterTypeDecorator.getType();
            } else if (paramRestType != null) {
                parameter = (JSType)paramRestType.get();
            } else {
                parameter = null;
                hasParameter = false;
            }
            if (parameterTypeDecorator != null && parameterTypeDecorator.isRest()) {
                paramRestType = Ref.create((Object)parameter);
                remainingParametersAreOptional = true;
            }
            if (parameterTypeDecorator != null && parameterTypeDecorator.isOptional()) {
                remainingParametersAreOptional = true;
            }
            JSParameterTypeDecorator argumentTypeDecorator = null;
            boolean hasArgument = true;
            if (argIterator.hasNext()) {
                argumentTypeDecorator = argIterator.next();
                argument = argumentTypeDecorator.getType();
            } else if (argRestType != null) {
                argument = (JSType)argRestType.get();
            } else {
                hasArgument = false;
                argument = null;
            }
            if (argumentTypeDecorator != null && argumentTypeDecorator.isRest()) {
                argRestType = Ref.create((Object)argument);
                remainingArgumentsAreOptional = true;
            }
            if (argumentTypeDecorator != null && argumentTypeDecorator.isOptional()) {
                remainingArgumentsAreOptional = true;
            }
            if (!hasParameter) {
                return functionAssignment && !typescript || remainingArgumentsAreOptional;
            }
            if (!hasArgument) {
                return remainingParametersAreOptional || functionAssignment && typescript;
            }
            if (JSTypeUtils.isAssignableType(parameter, argument, processingContext) || functionAssignment && !jsDocFunctionAssignment && JSTypeUtils.isAssignableType(argument, parameter, processingContext)) continue;
            return false;
        }
        return typescript || !functionAssignment || remainingParametersAreOptional || paramRestType != null || !remainingArgumentsAreOptional && (!jsDocFunctionAssignment || argRestType == null);
    }

    public static boolean haveAncestorChildRelation(@NotNull String qname1, @NotNull String qname2) {
        int i;
        if (qname1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qname1", "com/intellij/lang/javascript/psi/JSTypeUtils", "haveAncestorChildRelation"));
        }
        if (qname2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qname2", "com/intellij/lang/javascript/psi/JSTypeUtils", "haveAncestorChildRelation"));
        }
        for (i = 0; i < qname1.length() && i < qname2.length(); ++i) {
            if (qname1.charAt(i) == qname2.charAt(i)) continue;
            return false;
        }
        return qname1.length() == qname2.length() || i < qname1.length() && qname1.charAt(i) == '.' || i < qname2.length() && qname2.charAt(i) == '.';
    }

    public static JSType applyGenericArguments(@Nullable JSType _type, final @Nullable Map<String, JSType> typeArguments, final boolean call, final @Nullable JSGenericTypesEvaluator.GenericErrorReporter report) {
        if (_type == null || typeArguments == null || typeArguments.isEmpty()) {
            return _type;
        }
        return JSTypeUtils.applyCompositeMapping(_type, new Function<JSType, JSType>(){

            public JSType fun(JSType type) {
                JSType result;
                if (type instanceof JSTypeofTypeImpl) {
                    JSType evaluatedType = ((JSTypeofTypeImpl)type).evaluateType();
                    return JSTypeUtils.applyCompositeMapping(evaluatedType, this);
                }
                if (type instanceof JSTypeImpl || type instanceof JSGenericParameterImpl) {
                    JSTypeImpl typeImpl;
                    JSType jsType;
                    if (call) {
                        type = TypeScriptUtil.setCallEnvironmentIfGenericParameterType(type);
                    }
                    if ((jsType = (JSType)typeArguments.get(type.getTypeText())) instanceof JSTypeofTypeImpl) {
                        jsType = ((JSTypeofTypeImpl)jsType).evaluateType();
                    }
                    if (jsType != null) {
                        if (type instanceof JSGenericParameterImpl) {
                            JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
                            if (report != null && constraintType != null && !constraintType.isDirectlyAssignableType(jsType, null)) {
                                report.error("typescript.validation.cannot.find.best.common.type");
                                return constraintType;
                            }
                        }
                        return jsType;
                    }
                    if (type instanceof JSTypeImpl && (typeImpl = (JSTypeImpl)type).isLocal()) {
                        return new JSGenericTypeImpl(typeImpl.getSource(), (JSType)typeImpl, typeArguments);
                    }
                } else if (type instanceof JSGenericTypeImpl && (result = JSTypeUtils.concatGenericsToJSGenericTypeIfNestedLocal((JSGenericTypeImpl)type, typeArguments)) != null) {
                    return result;
                }
                return type;
            }
        });
    }

    private static JSType concatGenericsToJSGenericTypeIfNestedLocal(JSGenericTypeImpl genericType, @NotNull Map<String, JSType> typeArguments) {
        JSType jsType;
        JSTypeImpl typeImpl;
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "com/intellij/lang/javascript/psi/JSTypeUtils", "concatGenericsToJSGenericTypeIfNestedLocal"));
        }
        JSType innerType = genericType.getType();
        if (innerType instanceof JSTypeImpl && (typeImpl = (JSTypeImpl)innerType).isLocal() && (jsType = typeArguments.get(typeImpl.getTypeText())) == null) {
            Map newOuterArguments = typeArguments;
            if (genericType.getOuterArguments() != null) {
                newOuterArguments = ContainerUtil.union(newOuterArguments, genericType.getOuterArguments());
            }
            return new JSGenericTypeImpl(genericType.getSource(), typeImpl, genericType.getArguments(), newOuterArguments);
        }
        return null;
    }

    public static JSType applyGenericArguments(@NotNull JSType _type, @Nullable Map<String, JSType> typeArguments, @Nullable JSGenericTypesEvaluator.GenericErrorReporter report) {
        if (_type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_type", "com/intellij/lang/javascript/psi/JSTypeUtils", "applyGenericArguments"));
        }
        return JSTypeUtils.applyGenericArguments(_type, typeArguments, false, report);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType applyGenericArguments(@Nullable JSType _type, @Nullable Map<String, JSType> typeArguments) {
        return JSTypeUtils.applyGenericArguments(_type, typeArguments, false, null);
    }

    @NotNull
    public static JSType addGenericParameters(@NotNull JSType _type, @NotNull Set<String> genericParameters) {
        if (_type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_type", "com/intellij/lang/javascript/psi/JSTypeUtils", "addGenericParameters"));
        }
        if (genericParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericParameters", "com/intellij/lang/javascript/psi/JSTypeUtils", "addGenericParameters"));
        }
        JSType jSType = JSTypeUtils.applyCompositeMapping(_type, (Function<JSType, JSType>)((Function)type -> {
            if (genericParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericParameters", "com/intellij/lang/javascript/psi/JSTypeUtils", "lambda$addGenericParameters$2"));
            }
            if (type instanceof JSTypeImpl && genericParameters.contains(type.getTypeText())) {
                return new JSGenericParameterImpl(type.getTypeText(), type.getSource());
            }
            return type;
        }));
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "addGenericParameters"));
        }
        return jSType;
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType applyCompositeMapping(@Nullable JSType type, @NotNull Function<JSType, JSType> f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/lang/javascript/psi/JSTypeUtils", "applyCompositeMapping"));
        }
        return JSTypeUtils.transformTypeHierarchySafe(type, f, null);
    }

    public static boolean hasGenericParameter(@Nullable JSType type) {
        return JSTypeUtils.hasType(type, JSGenericParameterImpl.class);
    }

    public static boolean hasType(@Nullable JSType type, final @NotNull Class<?> typeClass) {
        if (typeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeClass", "com/intellij/lang/javascript/psi/JSTypeUtils", "hasType"));
        }
        if (type == null) {
            return false;
        }
        if (typeClass.isInstance(type)) {
            return true;
        }
        final Ref result = Ref.create((Object)Boolean.FALSE);
        type.accept(new JSRecursiveTypeVisitor(){

            public void visitJSType(JSType typeToVisit) {
                if (typeClass.isInstance(typeToVisit)) {
                    result.set((Object)Boolean.TRUE);
                    return;
                }
                super.visitJSType(typeToVisit);
            }
        });
        return (Boolean)result.get();
    }

    public static boolean hasThisGenericType(@Nullable JSType type) {
        return JSTypeUtils.hasType(type, TypeScriptGenericThisTypeImpl.class);
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithNewSourceRecursive(@Nullable JSType type, @NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/JSTypeUtils", "copyWithNewSourceRecursive"));
        }
        if (type == null) {
            return null;
        }
        if (source == type.getSource()) {
            return type;
        }
        return JSTypeUtils.transformTypeHierarchySafe(type, (Function<JSType, JSType>)((Function)type1 -> type1), source);
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithNewSource(@Nullable JSType type, @NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/JSTypeUtils", "copyWithNewSource"));
        }
        if (type == null) {
            return null;
        }
        if (source == type.getSource()) {
            return type;
        }
        return type.copyWithNewSource(source);
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithExplicitlyDeclaredRecursive(@Nullable JSType type, final boolean explicitlyDeclared) {
        if (type == null) {
            return null;
        }
        return type.transformTypeHierarchy((Function)new Function<JSType, JSType>(){

            public JSType fun(@Nullable JSType type) {
                if (type == null || type.getSource().isExplicitlyDeclared() == explicitlyDeclared) {
                    return type;
                }
                JSType newType = JSTypeUtils.copyWithExplicitlyDeclared(type, explicitlyDeclared);
                return newType.transformTypeHierarchy((Function)this, null);
            }
        }, null);
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithExplicitlyDeclared(@Nullable JSType type, boolean explicitlyDeclared) {
        if (type == null) {
            return null;
        }
        if (type.getSource().isExplicitlyDeclared() == explicitlyDeclared) {
            return type;
        }
        return type.copyWithNewSource(JSTypeSourceFactory.copyTypeSource(type.getSource(), explicitlyDeclared));
    }

    @NotNull
    public static List<JSType> addPossibleOption(@NotNull Collection<JSType> types, @NotNull JSType newOption) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/psi/JSTypeUtils", "addPossibleOption"));
        }
        if (newOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newOption", "com/intellij/lang/javascript/psi/JSTypeUtils", "addPossibleOption"));
        }
        boolean hasAnyType = false;
        int typesCount = 0;
        for (JSType addedType : types) {
            ++typesCount;
            if (!(addedType instanceof JSAnyType)) continue;
            hasAnyType = true;
        }
        JSTypeSource optionSource = newOption.getSource();
        List<JSType> typesToAdd = newOption instanceof JSCompositeTypeImpl && !optionSource.isExplicitlyDeclared() ? ((JSCompositeTypeImpl)newOption).getTypes() : Collections.singletonList(newOption);
        SmartList result = new SmartList();
        if (types.isEmpty()) {
            result.addAll(typesToAdd);
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "addPossibleOption"));
            }
            return smartList;
        }
        for (JSType typeToAdd : typesToAdd) {
            boolean alreadyPresent = false;
            String typeToAddText = typeToAdd.getTypeText(JSType.TypeTextFormat.SIMPLE);
            for (JSType addedType : types) {
                if (!StringUtil.equals((CharSequence)typeToAddText, (CharSequence)addedType.getTypeText(JSType.TypeTextFormat.SIMPLE))) continue;
                alreadyPresent = true;
                break;
            }
            if (alreadyPresent) continue;
            if (typesCount > 5) {
                if (hasAnyType) continue;
                result.add(JSAnyType.get((PsiElement)optionSource.getScope(), false));
                ++typesCount;
                continue;
            }
            result.add(typeToAdd);
            ++typesCount;
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "addPossibleOption"));
        }
        return smartList;
    }

    public static boolean processExpandedType(JSTypeProcessor processor, JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
        JSType newType;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/JSTypeUtils", "processExpandedType"));
        }
        if (type instanceof JSCompositeTypeBaseImpl) {
            boolean isStrictTypeScript;
            boolean bl = isStrictTypeScript = type.getSource().isExplicitlyDeclared() && type.getSource().isTypeScript();
            if (isStrictTypeScript && !(type instanceof JSIntersectionTypeImpl)) {
                JSType resolveUnionType = type.substitute();
                processor.process(resolveUnionType, context, source);
            } else {
                for (JSType jsType : ((JSCompositeTypeBaseImpl)type).getTypes()) {
                    processor.process(jsType, context, source);
                }
            }
            return false;
        }
        if (type instanceof JSTypeImpl) {
            JSType typedefValue;
            JSTypeSource typeSource = type.getSource();
            if (typeSource.isExplicitlyDeclared() && type.resolveClass() == null && (typedefValue = ((JSTypeImpl)type).getTypedef(null, new ProcessingContext())) != null) {
                processor.process(typedefValue, context, source);
                return true;
            }
        } else if (type instanceof JSDecoratedTypeImpl) {
            processor.process(((JSDecoratedTypeImpl)type).getType(), context, source);
            return false;
        }
        if (type instanceof TypeScriptGenericThisTypeImpl && type != (newType = type.substitute())) {
            processor.process(newType, context, source);
            return false;
        }
        return true;
    }

    public static boolean processExpandedType(@NotNull Processor<JSType> processor, @Nullable JSType type) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/JSTypeUtils", "processExpandedType"));
        }
        if (type instanceof JSCompositeTypeBaseImpl) {
            List<JSType> types = ((JSCompositeTypeBaseImpl)type).getTypes();
            for (JSType jsType : types) {
                if (JSTypeUtils.processExpandedType(processor, jsType)) continue;
                return false;
            }
            return true;
        }
        JSType jsType = JSTypeUtils.getValuableType(type);
        return jsType == type ? processor.process((Object)jsType) : JSTypeUtils.processExpandedType(processor, jsType);
    }

    public static boolean areTypesCompatible(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext processingContext, @Nullable PsiElement psiContext) {
        boolean eq;
        if (type1 == null || type2 == null) {
            return type1 == type2;
        }
        if (type1 instanceof JSTypeofTypeImpl) {
            return JSTypeUtils.areTypesCompatible(((JSTypeofTypeImpl)type1).evaluateType(), type2, processingContext, psiContext);
        }
        if (type2 instanceof JSTypeofTypeImpl) {
            return JSTypeUtils.areTypesCompatible(type1, ((JSTypeofTypeImpl)type2).evaluateType(), processingContext, psiContext);
        }
        if (type1 instanceof JSStringLiteralTypeImpl) {
            return type2 instanceof JSStringType;
        }
        if (type2 instanceof JSStringLiteralTypeImpl) {
            return type1 instanceof JSStringType;
        }
        if (type1 instanceof JSArrayTypeImpl) {
            if (type2 instanceof JSPrimitiveArrayType) {
                return true;
            }
            if (JSGenericTypeImpl.isGenericActionScriptVectorType(type2)) {
                return true;
            }
        }
        if (type2 instanceof JSArrayTypeImpl) {
            if (type1 instanceof JSPrimitiveArrayType) {
                return true;
            }
            if (JSGenericTypeImpl.isGenericActionScriptVectorType(type1)) {
                return true;
            }
        }
        if (eq = type1.isEquivalentTo(type2, processingContext)) {
            return true;
        }
        if (psiContext != null && DialectDetector.isTypeScript(psiContext)) {
            return type1.isDirectlyAssignableType(type2, processingContext) && type2.isDirectlyAssignableType(type1, processingContext);
        }
        return false;
    }

    @Nullable
    public static JSType getTypeOfElement(@Nullable PsiElement element) {
        if (element instanceof JSImplicitElement) {
            return JSTypeUtils.createType(((JSImplicitElement)element).getTypeString(), JSTypeSourceFactory.createTypeSource(element, true));
        }
        if (element instanceof JSVariable) {
            return ((JSVariable)element).getType();
        }
        if (element instanceof JSFunction && ((JSFunction)element).isGetProperty()) {
            return ((JSFunction)element).getReturnType();
        }
        if (element instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)element).getType();
        }
        if (element instanceof JSProperty) {
            return ((JSProperty)element).getType();
        }
        if (element instanceof JSField) {
            return ((JSField)element).getType();
        }
        return null;
    }

    public static boolean isActionScriptVectorType(@Nullable JSType type) {
        if (type != null && type.getSource().isTypeScript()) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        return type instanceof JSTypeImpl && "Vector".equals(type.getTypeText());
    }

    public static String defaultValueOfType(@Nullable JSType retType) {
        if (retType instanceof JSNumberType) {
            return "0";
        }
        if (retType instanceof JSBooleanType) {
            return "false";
        }
        if (retType instanceof JSStringType) {
            return "\"\"";
        }
        return null;
    }

    @Deprecated
    @NonNls
    public static String defaultValueOfType(@NonNls String retType) {
        if ("int".equals(retType) || "uint".equals(retType) || "Number".equals(retType)) {
            return "0";
        }
        if ("Boolean".equals(retType)) {
            return "false";
        }
        if ("String".equals(retType)) {
            return "\"\"";
        }
        return "null";
    }

    @Nullable
    public static List<JSType> getGenericTypeArguments(@Nullable JSType type) {
        if (type instanceof JSGenericTypeImpl) {
            return ((JSGenericTypeImpl)type).getArguments();
        }
        if (type instanceof JSArrayTypeImpl) {
            return Collections.singletonList(((JSArrayTypeImpl)type).getType());
        }
        if (type instanceof JSPrimitiveArrayType) {
            return Collections.singletonList(JSAnyType.get(type.getSource().getSourceElement(), ((JSPrimitiveArrayType)type).isExplicitlyDeclared()));
        }
        return null;
    }

    public static JSType getApparentType(@Nullable JSType type) {
        if (JSTypeUtils.hasType(type, JSStringLiteralTypeImpl.class)) {
            return type.transformTypeHierarchy(type1 -> {
                if (type1 instanceof JSStringLiteralTypeImpl && !((JSStringLiteralTypeImpl)((Object)type1)).isStrict()) {
                    return new JSStringType(true, type1.getSource(), JSTypeContext.INSTANCE);
                }
                return type1;
            }, null);
        }
        return type;
    }

    @NotNull
    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable DialectOptionHolder holder) {
        boolean isTypeScript;
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/lang/javascript/psi/JSTypeUtils", "getCommonType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/lang/javascript/psi/JSTypeUtils", "getCommonType"));
        }
        JSTypeSource source = type1.getSource();
        boolean bl = isTypeScript = holder != null && holder.isTypeScript;
        if (!(!(type1 instanceof JSStringType) || !(type2 instanceof JSStringType) || isTypeScript && type1 instanceof JSStringLiteralTypeImpl && type2 instanceof JSStringLiteralTypeImpl)) {
            JSType jSType = JSNamedType.createType("string", source, ((JSStringType)type1).isStaticOrInstance());
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getCommonType"));
            }
            return jSType;
        }
        if (isTypeScript) {
            JSType jSType = JSCompositeTypeImpl.getCommonType(type1, type2, null, true);
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getCommonType"));
            }
            return jSType;
        }
        if (type1.isEquivalentTo(type2, null)) {
            JSType jSType = type1;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getCommonType"));
            }
            return jSType;
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)source.getScope(), false);
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getCommonType"));
        }
        return jSAnyType;
    }

    public static boolean isAssignableType(@Nullable JSType thisType, @Nullable JSType elementType, ProcessingContext processingContext) {
        return thisType == null || thisType.isDirectlyAssignableType(elementType, processingContext);
    }

    public static List<JSParameterTypeDecorator> getParameterTypeDecorators(List<JSType> parameters) {
        ArrayList<JSParameterTypeDecorator> decorators = new ArrayList<JSParameterTypeDecorator>(parameters.size());
        for (JSType parameter : parameters) {
            decorators.add(new JSParameterTypeDecoratorImpl(parameter, false, false, true));
        }
        return decorators;
    }

    @NotNull
    public static JSRecordType buildRecordType(@NotNull JSFunctionTypeImpl functionType) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "com/intellij/lang/javascript/psi/JSTypeUtils", "buildRecordType"));
        }
        JSRecordType jSRecordType = functionType.asRecordType();
        if (jSRecordType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "buildRecordType"));
        }
        return jSRecordType;
    }

    @NotNull
    public static JSContext combineJSContexts(@NotNull JSContext f, @NotNull JSContext g) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/lang/javascript/psi/JSTypeUtils", "combineJSContexts"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/lang/javascript/psi/JSTypeUtils", "combineJSContexts"));
        }
        if (f == JSContext.STATIC && g == JSContext.STATIC) {
            JSContext jSContext = JSContext.STATIC;
            if (jSContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "combineJSContexts"));
            }
            return jSContext;
        }
        if (f == JSContext.INSTANCE || g == JSContext.INSTANCE) {
            JSContext jSContext = JSContext.INSTANCE;
            if (jSContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "combineJSContexts"));
            }
            return jSContext;
        }
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "combineJSContexts"));
        }
        return jSContext;
    }

    public static Object getTypeInvalidationDependency() {
        return PsiModificationTracker.MODIFICATION_COUNT;
    }

    @Nullable
    public static JSRecordType buildRecordTypeFromProperties(@NotNull Map<JSQualifiedName, String> properties, @NotNull Set<JSQualifiedName> optional, @NotNull JSTypeSource typeSource) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/lang/javascript/psi/JSTypeUtils", "buildRecordTypeFromProperties"));
        }
        if (optional == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optional", "com/intellij/lang/javascript/psi/JSTypeUtils", "buildRecordTypeFromProperties"));
        }
        if (typeSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSource", "com/intellij/lang/javascript/psi/JSTypeUtils", "buildRecordTypeFromProperties"));
        }
        ArrayList<Pair<JSQualifiedName, String>> list = new ArrayList<Pair<JSQualifiedName, String>>(properties.size());
        for (Map.Entry<JSQualifiedName, String> entry : properties.entrySet()) {
            list.add((Pair<JSQualifiedName, String>)Pair.create((Object)entry.getKey(), (Object)entry.getValue()));
        }
        return JSTypeUtils.buildRecordTypeFromQualifiedNames(list, optional, typeSource);
    }

    @Nullable
    public static JSRecordType buildRecordTypeFromQualifiedNames(@NotNull Collection<Pair<JSQualifiedName, String>> qualifiedNames, @NotNull Set<JSQualifiedName> optional, @NotNull JSTypeSource typeSource) {
        if (qualifiedNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNames", "com/intellij/lang/javascript/psi/JSTypeUtils", "buildRecordTypeFromQualifiedNames"));
        }
        if (optional == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optional", "com/intellij/lang/javascript/psi/JSTypeUtils", "buildRecordTypeFromQualifiedNames"));
        }
        if (typeSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSource", "com/intellij/lang/javascript/psi/JSTypeUtils", "buildRecordTypeFromQualifiedNames"));
        }
        RecordTypeNode root = new RecordTypeNode();
        for (Pair<JSQualifiedName, String> property : qualifiedNames) {
            List components = ((JSQualifiedName)property.getFirst()).toComponents();
            RecordTypeNode currentPath = root;
            for (int i = 0; i < components.size(); ++i) {
                String component = (String)components.get(i);
                RecordTypeNode child = currentPath.myChildren.get(component);
                if (child == null) {
                    child = new RecordTypeNode();
                    child.myOptional = optional.contains(property.getFirst());
                    currentPath.myChildren.put(component, child);
                }
                currentPath = child;
                if (i != components.size() - 1) continue;
                String typeString = (String)property.getSecond();
                currentPath.myType = JSTypeUtils.createType(typeString, typeSource);
            }
        }
        return (JSRecordType)JSTypeUtils.buildTypeFromRecordTypeNode(root, typeSource);
    }

    @Nullable
    private static JSType buildTypeFromRecordTypeNode(@NotNull RecordTypeNode node, @NotNull JSTypeSource typeSource) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/psi/JSTypeUtils", "buildTypeFromRecordTypeNode"));
        }
        if (typeSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSource", "com/intellij/lang/javascript/psi/JSTypeUtils", "buildTypeFromRecordTypeNode"));
        }
        if (node.myChildren.isEmpty()) {
            return node.myType;
        }
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>(node.myChildren.size());
        for (Map.Entry<String, RecordTypeNode> entry : node.myChildren.entrySet()) {
            JSType type = JSTypeUtils.buildTypeFromRecordTypeNode(entry.getValue(), typeSource);
            typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(entry.getKey(), type, entry.getValue().myOptional));
        }
        return new JSRecordTypeImpl(typeSource, typeMembers);
    }

    @NotNull
    public static Collection<JSImplicitElement> getImplicitMembersFromRecordType(@NotNull JSRecordType type, @Nullable JSQualifiedName namespace, @Nullable PsiElement parent) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/JSTypeUtils", "getImplicitMembersFromRecordType"));
        }
        SmartList elements = new SmartList();
        for (JSRecordType.TypeMember member : type.getTypeMembers()) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            String name = ((JSRecordType.PropertySignature)member).getName();
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, parent).setNamespace(namespace).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Property).setNamespaceExplicitlyDeclared(namespace != null);
            JSType jsType = ((JSRecordType.PropertySignature)member).getType();
            if (jsType instanceof JSRecordType) {
                Collection<JSImplicitElement> childElements = JSTypeUtils.getImplicitMembersFromRecordType((JSRecordType)jsType, JSQualifiedNameImpl.create(name, namespace), parent);
                elements.addAll(childElements);
            }
            if (jsType != null) {
                builder.setTypeString(jsType.getTypeText(JSType.TypeTextFormat.SERIALIZED));
            }
            JSImplicitElementImpl element = new JSImplicitElementImpl(builder);
            elements.add((Object)element);
        }
        SmartList smartList = elements;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getImplicitMembersFromRecordType"));
        }
        return smartList;
    }

    @Contract(value="!null,_,_ -> !null")
    public static JSType transformTypeHierarchySafe(@Nullable JSType type, @NotNull Function<JSType, JSType> transformation, @Nullable JSTypeSource newSource) {
        if (transformation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformation", "com/intellij/lang/javascript/psi/JSTypeUtils", "transformTypeHierarchySafe"));
        }
        if (type == null) {
            return null;
        }
        return type.transformTypeHierarchy(transformation, newSource);
    }

    @NotNull
    public static List<JSType> getArgumentTypes(@Nullable JSArgumentList argumentList) {
        if (argumentList == null) {
            List<JSType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getArgumentTypes"));
            }
            return list;
        }
        JSExpression[] arguments = argumentList.getArguments();
        ArrayList<JSType> argumentTypes = new ArrayList<JSType>(arguments.length);
        for (JSExpression argument : arguments) {
            argumentTypes.add(JSResolveUtil.getExpressionJSType(argument));
        }
        ArrayList<JSType> arrayList = argumentTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeUtils", "getArgumentTypes"));
        }
        return arrayList;
    }

    public static boolean isNeedWrapTypeForSerialization(@Nullable JSType type) {
        return type instanceof JSCompositeTypeBaseImpl || type instanceof JSFunctionTypeImpl;
    }

    private static class RecordTypeNode {
        Map<String, RecordTypeNode> myChildren = new LinkedHashMap<String, RecordTypeNode>();
        boolean myOptional;
        JSType myType;

        private RecordTypeNode() {
        }
    }
}

