/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptVariableImpl
extends JSVariableImpl<JSVariableStub<JSVariable>, JSVariable>
implements TypeScriptVariable {
    public TypeScriptVariableImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptVariableImpl(JSVariableStub<JSVariable> stub, JSStubElementType<JSVariableStub<JSVariable>, JSVariable> signature) {
        super(stub, signature);
    }

    private JSType doGetDeclarationTypeStubSafe() {
        JSType type = TypeScriptPsiUtil.getTypeFromDeclaration(this);
        if (type != null) {
            return type;
        }
        type = this.getTypeFromEnum();
        if (type != null) {
            return type;
        }
        return null;
    }

    @Override
    @Nullable
    protected JSType doGetType() {
        JSType type = this.doGetDeclarationTypeStubSafe();
        if (type != null) {
            return type;
        }
        if (this.hasInitializer()) {
            PsiElement parent = this.getParent();
            if (parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringProperty) {
                return null;
            }
            JSExpression initializer = this.getInitializer();
            if (initializer != null) {
                JSType possibleType;
                if (initializer instanceof JSLiteralExpression && (possibleType = JSTypeUtils.getApparentType(JSTypeEvaluator.getTypeFromConstant(initializer, false))) != null) {
                    return possibleType;
                }
                return new JSTypeofTypeImpl(initializer, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            }
        }
        return null;
    }

    @Override
    protected JSType doGetStubType(JSVariableStub<JSVariable> stub) {
        String typeString = stub.getTypeString();
        if (typeString == null) {
            return this.doGetDeclarationTypeStubSafe();
        }
        return super.doGetStubType(stub);
    }

    @Nullable
    private JSType getTypeFromEnum() {
        PsiElement parent = this.getParent();
        if (parent != null && parent.getParent() instanceof TypeScriptEnum) {
            String name = ((TypeScriptEnum)parent.getParent()).getQualifiedName();
            if (StringUtil.isEmpty((String)name)) {
                return null;
            }
            return JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource((PsiElement)this, true), JSContext.INSTANCE);
        }
        return null;
    }

    @Override
    public boolean isLocal() {
        return PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, JSFunction.class) != null;
    }

    public TypeScriptType getTypeElement() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Override
    public String getName() {
        JSVariableStub stub = (JSVariableStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        if (this.myName == null) {
            this.myName = TypeScriptPsiUtil.getNameFromIdentifier(this.findNameIdentifier());
        }
        return this.myName;
    }

    @Override
    public ASTNode findNameIdentifier() {
        if (this.getNode().findChildByType(JSTokenTypes.LBRACKET) != null) {
            return null;
        }
        if (this.getParent().getParent() instanceof TypeScriptClass) {
            return this.getNode().findChildByType(JSKeywordSets.PROPERTY_NAMES);
        }
        return super.findNameIdentifier();
    }

    @Nullable
    public ES6ComputedName getComputedPropertyName() {
        return (ES6ComputedName)this.getStubOrPsiChild((IStubElementType)ES6ElementTypes.COMPUTED_NAME);
    }

    @Override
    @Deprecated
    @Nullable
    public String getTypeString() {
        JSType type = this.getType();
        return type == null ? null : type.getTypeText(JSType.TypeTextFormat.SERIALIZED);
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        PsiElement parent = this.getParent();
        if (parent != null && parent.getParent() instanceof TypeScriptEnum) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PUBLIC;
            if (accessType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptVariableImpl", "getAccessType"));
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = super.getAccessType();
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptVariableImpl", "getAccessType"));
        }
        return accessType;
    }
}

