/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSuperExpressionImpl
extends JSExpressionImpl
implements JSSuperExpression {
    private PsiReference[] references;

    public JSSuperExpressionImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/ecmal4/impl/JSSuperExpressionImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSSuperExpression((JSSuperExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiReference getReference() {
        return this.getReferences()[0];
    }

    @NotNull
    public PsiReference[] getReferences() {
        if (this.references != null) {
            if (this.references == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSSuperExpressionImpl", "getReferences"));
            }
            return this.references;
        }
        PsiReference[] refs = new PsiReference[]{new PsiReference(){

            public PsiElement getElement() {
                return JSSuperExpressionImpl.this;
            }

            public TextRange getRangeInElement() {
                return new TextRange(0, JSSuperExpressionImpl.this.getTextLength());
            }

            @Nullable
            public PsiElement resolve() {
                JSClass contextClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), JSClass.class);
                PsiElement element = this.findClass(contextClass);
                PsiElement parentExpression = this.getElement().getParent();
                if (parentExpression instanceof JSCallExpression && element instanceof JSClass) {
                    TypeScriptClass tsClass;
                    PsiElement constructor;
                    JSCallExpression expression = (JSCallExpression)parentExpression;
                    if (contextClass instanceof TypeScriptClass && (constructor = JSSuperExpressionImpl.matchTypeScriptSuperConstructor(expression, tsClass = (TypeScriptClass)contextClass)) != null) {
                        return constructor;
                    }
                    PsiElement processor = this.findConstructorInClass((JSClass)element);
                    if (processor != null) {
                        return processor;
                    }
                }
                return element;
            }

            @Nullable
            private PsiElement findConstructorInClass(@NotNull JSClass clazz) {
                if (clazz == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/psi/ecmal4/impl/JSSuperExpressionImpl$1", "findConstructorInClass"));
                }
                String superConstructor = JSSuperExpressionImpl.this.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4) ? clazz.getName() : "constructor";
                SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(superConstructor, (PsiElement)JSSuperExpressionImpl.this, new ResolveResultSink((PsiElement)JSSuperExpressionImpl.this, superConstructor));
                if (DialectDetector.isTypeScript(this.getElement())) {
                    processor.setCheckArgumentTypes(true);
                }
                clazz.processDeclarations(processor, ResolveState.initial(), (PsiElement)clazz, this.getElement());
                return processor.getResult();
            }

            @Nullable
            private PsiElement findClass(JSClass jsClass) {
                if (jsClass != null) {
                    JSReferenceList extendsList = jsClass.getExtendsList();
                    if (extendsList != null) {
                        JSClass[] classes = extendsList.getReferencedClasses();
                        return classes.length == 0 ? null : classes[0];
                    }
                } else {
                    JSFile jsFile = (JSFile)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), JSFile.class);
                    if (jsFile != null) {
                        return JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)jsFile);
                    }
                }
                return null;
            }

            @NotNull
            public String getCanonicalText() {
                String string = JSSuperExpressionImpl.this.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSSuperExpressionImpl$1", "getCanonicalText"));
                }
                return string;
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                return null;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/ecmal4/impl/JSSuperExpressionImpl$1", "bindToElement"));
                }
                return null;
            }

            public boolean isReferenceTo(PsiElement element) {
                return false;
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSSuperExpressionImpl$1", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            public boolean isSoft() {
                return true;
            }
        }};
        this.references = refs;
        PsiReference[] psiReferenceArray = this.references;
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecmal4/impl/JSSuperExpressionImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Nullable
    public static PsiElement matchTypeScriptSuperConstructor(JSCallExpression expression, TypeScriptClass tsClass) {
        Collection constructors = tsClass.getIndirectSuperConstructors();
        if (constructors.size() > 0) {
            JSFunction function = TypeScriptResolveProcessor.getFunctionWithParameters(expression, constructors);
            if (function != null) {
                return function;
            }
            return (PsiElement)ContainerUtil.getFirstItem((Collection)constructors);
        }
        return null;
    }
}

