/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSElementIterator;
import com.intellij.lang.javascript.psi.impl.JSFunctionVisitor;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindReferenceUtil {
    private FindReferenceUtil() {
    }

    public static JSReferenceExpression[] findReferences(@NotNull JSVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil", "findReferences"));
        }
        JSReferenceVisitor visitor = new JSReferenceVisitor(variable, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        JSElement scope = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSFunction.class);
        if (scope == null) {
            scope = FindReferenceUtil.getFarthestAncestor((PsiElement)variable, JSElement.class);
        }
        visitor.visitJSElement(scope);
        return visitor.getReferences();
    }

    public static <T extends PsiElement> T getFarthestAncestor(@NotNull PsiElement element, @NotNull Class<T> aClass) {
        PsiElement currentElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil", "getFarthestAncestor"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil", "getFarthestAncestor"));
        }
        PsiElement previousElement = element;
        do {
            if (!aClass.isInstance(currentElement = previousElement.getParent())) {
                return (T)previousElement;
            }
            previousElement = currentElement;
        } while (currentElement != null);
        return null;
    }

    public static Iterable<PsiElement> getReferences(@NotNull JSVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil", "getReferences"));
        }
        return FindReferenceUtil.getReferences(variable, null, 0, Integer.MAX_VALUE);
    }

    public static Iterable<PsiElement> getReferences(@NotNull JSVariable variable, @Nullable PsiElement scope) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil", "getReferences"));
        }
        return FindReferenceUtil.getReferences(variable, scope, 0, Integer.MAX_VALUE);
    }

    public static Iterable<PsiElement> getReferencesBefore(@NotNull JSVariable variable, int textOffset) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil", "getReferencesBefore"));
        }
        return FindReferenceUtil.getReferences(variable, null, 0, textOffset);
    }

    public static Iterable<PsiElement> getReferencesAfter(@NotNull JSVariable variable, int textOffset) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil", "getReferencesAfter"));
        }
        return FindReferenceUtil.getReferences(variable, null, textOffset, Integer.MAX_VALUE);
    }

    private static Iterable<PsiElement> getReferences(final @NotNull JSVariable variable, @Nullable PsiElement scope, final int minTextOffset, final int maxTextOffset) {
        JSElement function;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil", "getReferences"));
        }
        final Object iteratedScope = scope == null ? ((function = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSFunction.class)) == null ? FindReferenceUtil.getFarthestAncestor((PsiElement)variable, XmlFile.class) : function) : scope;
        return new Iterable<PsiElement>(){

            @Override
            public Iterator<PsiElement> iterator() {
                return new JSReferenceIterator(variable, minTextOffset, maxTextOffset, iteratedScope);
            }
        };
    }

    public static final class JSReferenceIterator
    extends JSElementIterator {
        private final JSVariable variable;
        private final String variableName;

        public JSReferenceIterator(@NotNull JSVariable variable, int minTextOffset, int maxTextOffset, @NotNull PsiElement element) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil$JSReferenceIterator", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil$JSReferenceIterator", "<init>"));
            }
            super(element, false, minTextOffset, maxTextOffset);
            this.variable = variable;
            this.variableName = variable.getName();
        }

        @Override
        public boolean visitElement(PsiElement element) {
            if (!element.getText().equals(this.variableName) || !(element instanceof JSReferenceExpression)) {
                return false;
            }
            JSVariable referent = ControlFlowUtils.resolveVariable((JSExpression)((JSReferenceExpression)element));
            return referent != null && this.variable.equals(referent);
        }
    }

    private static final class JSReferenceVisitor
    extends JSFunctionVisitor {
        private final JSVariable variable;
        private final String variableName;
        private final int maxCount;
        private final int minTextOffset;
        private final int maxTextOffset;
        private final List<JSReferenceExpression> references;

        public JSReferenceVisitor(@NotNull JSVariable variable, int maxCount, int minTextOffset, int maxTextOffset) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/lang/javascript/psi/impl/FindReferenceUtil$JSReferenceVisitor", "<init>"));
            }
            this.variable = variable;
            this.variableName = variable.getName();
            this.maxCount = maxCount;
            this.minTextOffset = minTextOffset;
            this.maxTextOffset = maxTextOffset;
            this.references = new ArrayList<JSReferenceExpression>();
        }

        @Override
        public void visitElement(PsiElement element) {
            int elementTextOffset;
            if (this.references.size() < this.maxCount && (elementTextOffset = element.getTextOffset()) + element.getTextLength() >= this.minTextOffset && elementTextOffset <= this.maxTextOffset) {
                super.visitElement(element);
            }
        }

        public void visitJSReferenceExpression(JSReferenceExpression expression) {
            JSVariable referent;
            super.visitJSReferenceExpression(expression);
            if (expression.getText().equals(this.variableName) && (referent = ControlFlowUtils.resolveVariable((JSExpression)expression)) != null && this.variable.equals(referent)) {
                this.references.add(expression);
            }
        }

        public JSReferenceExpression[] getReferences() {
            return this.references.toArray(new JSReferenceExpression[this.references.size()]);
        }

        public JSReferenceExpression getReference(int index) {
            return index >= 0 && index < this.references.size() ? this.references.get(index) : null;
        }
    }
}

