/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringPropertyStubImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringPropertyImpl
extends JSStubElementImpl<JSDestructuringPropertyStubImpl>
implements JSDestructuringProperty,
StubBasedPsiElement<JSDestructuringPropertyStubImpl> {
    public JSDestructuringPropertyImpl(ASTNode node) {
        super(node);
    }

    public JSDestructuringPropertyImpl(JSDestructuringPropertyStubImpl stub) {
        super(stub, (IStubElementType)JSStubElementTypes.DESTRUCTURING_PROPERTY);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDestructuringProperty((JSDestructuringProperty)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public JSInitializerOwner getDestructuringElement() {
        return (JSInitializerOwner)JSStubBasedPsiTreeUtil.getStubOrPsiChild(this, JSExtendedLanguagesTokenSetProvider.INITIALIZER_OWNERS);
    }

    public static ASTNode getDestructuringElement(@NotNull ASTNode destructuringProperty) {
        if (destructuringProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destructuringProperty", "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyImpl", "getDestructuringElement"));
        }
        return destructuringProperty.findChildByType(JSExtendedLanguagesTokenSetProvider.INITIALIZER_OWNERS);
    }

    public String getName() {
        JSDestructuringPropertyStubImpl stub = (JSDestructuringPropertyStubImpl)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            return StringUtil.unquoteString((String)identifier.getText());
        }
        return null;
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getNode() : null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        PsiElement identifierName = this.findChildByType(JSKeywordSets.IDENTIFIER_NAMES);
        if (identifierName != null) {
            return identifierName;
        }
        JSInitializerOwner destructuringElement = this.getDestructuringElement();
        if (destructuringElement instanceof PsiNameIdentifierOwner) {
            return ((PsiNameIdentifierOwner)destructuringElement).getNameIdentifier();
        }
        return null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/impl/JSDestructuringPropertyImpl", "setName"));
        }
        ASTNode nameNode = this.findNameIdentifier();
        if (nameNode == null) {
            return this;
        }
        ASTNode parentForReplace = nameNode.getTreeParent();
        ASTNode nameElement = JSChangeUtil.createNameIdentifier(this.getProject(), name, nameNode.getElementType());
        parentForReplace.replaceChild(nameNode, nameElement);
        return this;
    }
}

