/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveHelper;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileImpl
extends JSFileBaseImpl
implements JSFile {
    private static final TokenSet mainDeclaredElementTokenSet = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.CLASS, ActionScriptElementTypes.FUNCTION_DECLARATION, JSStubElementTypes.NAMESPACE_DECLARATION, JSStubElementTypes.VAR_STATEMENT});

    public JSFileImpl(@NotNull FileViewProvider fileViewProvider) {
        if (fileViewProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileViewProvider", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "<init>"));
        }
        super(fileViewProvider, DialectDetector.getJSLanguage(fileViewProvider.getVirtualFile()));
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getViewProvider().getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "getFileType"));
        }
        return fileType;
    }

    public String toString() {
        return "JSFile:" + this.getName();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        boolean areNotRequestedForMembersProcessing;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "processDeclarations"));
        }
        boolean bl = areNotRequestedForMembersProcessing = !Boolean.TRUE.equals(state.get(XmlBackedJSClass.PROCESS_XML_BACKED_CLASS_MEMBERS_HINT));
        if (areNotRequestedForMembersProcessing && JSResolveUtil.weShouldSkipResolveBecauseOfImplicitClass((PsiElement)this)) {
            return true;
        }
        if (areNotRequestedForMembersProcessing) {
            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        }
        boolean result = JSResolveUtil.processDeclarationsInScope((JSElement)this, processor, state, lastParent, place);
        if (lastParent == null) {
            return result;
        }
        if (result) {
            if (!(lastParent instanceof JSPackageStatement)) {
                result = JSImportHandlingUtil.tryResolveImports(processor, (PsiNamedElement)this, place);
            }
            boolean newResolveAndCompletion = JSResolveUtil.isActionScript((PsiFile)this);
            if (result && newResolveAndCompletion && (JSResolveUtil.shouldProcessImports(place, processor) || place.getParent() instanceof JSImportStatement && processor instanceof ResolveProcessor && ((ResolveProcessor)processor).getName() == null)) {
                result = JSResolveUtil.processGlobalThings((ResolveProcessor)processor, state, place, (PsiElement)this);
            } else if (result && DialectDetector.isTypeScript((PsiElement)this) && processor instanceof ResolveProcessor && !((ResolveProcessor)processor).isLocalResolve()) {
                if (processor instanceof SinkResolveProcessor) {
                    Object sink = ((SinkResolveProcessor)processor).getResultSink();
                    ((ResultSink)sink).startGlobalDeclarations();
                }
                result = TypeScriptResolveHelper.processGlobalThings((ResolveProcessor)processor, state, place);
            }
        }
        return result;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSFile((JSFile)this);
        } else {
            super.accept(visitor);
        }
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "addRangeBefore"));
        }
        if (JSChangeUtil.isStatementOrComment(first)) {
            return JSChangeUtil.doAddRangeBefore((PsiElement)this, first, last, anchor);
        }
        return super.addRangeBefore(first, last, anchor);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return this.addRangeAfter(first, last, null);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "addAfter"));
        }
        if (JSChangeUtil.isStatementOrComment(element)) {
            return JSChangeUtil.doAddAfter((PsiElement)this, element, anchor);
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "addBefore"));
        }
        if (JSChangeUtil.isStatementOrComment(element)) {
            return JSChangeUtil.doAddBefore((PsiElement)this, element, anchor);
        }
        return super.addBefore(element, anchor);
    }

    public boolean isWritable() {
        return super.isWritable() && !this.isPredefined();
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (JSChangeUtil.isStatementOrComment(first)) {
            return JSChangeUtil.doAddRangeAfter((PsiElement)this, first, last, anchor);
        }
        return super.addRangeAfter(first, last, anchor);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "add"));
        }
        return this.addAfter(element, null);
    }

    public JSSourceElement[] getStatements() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return (JSSourceElement[])stub.getChildrenByType(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, (PsiElement[])JSSourceElement.EMPTY_ARRAY);
        }
        return (JSSourceElement[])this.findChildrenByClass(JSSourceElement.class);
    }

    public boolean isPredefined() {
        return JSResolveUtil.isFromPredefinedFile((PsiFile)this);
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = JSResolveUtil.getResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Nullable
    public static JSNamedElement findMainDeclaredElement(@NotNull PsiFileImpl file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/impl/JSFileImpl", "findMainDeclaredElement"));
        }
        JSNamedElement mainDeclaredElement = null;
        StubElement stub = file.getStub();
        if (stub != null) {
            StubElement packageStub = stub.findChildStubByType(JSStubElementTypes.PACKAGE_STATEMENT);
            if (packageStub != null) {
                StubElement qualifiedElement = packageStub.findChildStubByType((IStubElementType)JSStubElementTypes.CLASS);
                if (qualifiedElement == null) {
                    qualifiedElement = packageStub.findChildStubByType(ActionScriptElementTypes.FUNCTION_DECLARATION);
                }
                if (qualifiedElement == null) {
                    qualifiedElement = packageStub.findChildStubByType(JSStubElementTypes.NAMESPACE_DECLARATION);
                }
                if (qualifiedElement == null && (qualifiedElement = packageStub.findChildStubByType(JSStubElementTypes.VAR_STATEMENT)) != null) {
                    qualifiedElement = qualifiedElement.findChildStubByType(ActionScriptElementTypes.VARIABLE);
                }
                if (qualifiedElement != null) {
                    mainDeclaredElement = (JSNamedElement)qualifiedElement.getPsi();
                }
            }
        } else {
            JSPackageStatement statement = (JSPackageStatement)file.findChildByClass(JSPackageStatement.class);
            if (statement != null) {
                ASTNode node = statement.getNode().findChildByType(mainDeclaredElementTokenSet);
                if (node != null && node.getElementType() == JSStubElementTypes.VAR_STATEMENT) {
                    node = node.findChildByType(ActionScriptElementTypes.VARIABLE);
                }
                if (node != null) {
                    mainDeclaredElement = (JSNamedElement)node.getPsi();
                }
            }
        }
        return mainDeclaredElement;
    }
}

