/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class JSElementResolveScopeProvider
extends ResolveScopeProvider {
    public static final LanguageExtension<JSElementResolveScopeProvider> EP_NAME = new LanguageExtension("JavaScript.elementScopeProvider");

    @NotNull
    public GlobalSearchScope getElementResolveScope(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSElementResolveScopeProvider", "getElementResolveScope"));
        }
        Project project = element.getProject();
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null && (virtualFile = psiFile.getOriginalFile().getVirtualFile()) != null) {
            GlobalSearchScope globalSearchScope = ResolveScopeManager.getInstance((Project)project).getDefaultResolveScope(virtualFile);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSElementResolveScopeProvider", "getElementResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = JSResolveUtil.getJavaScriptSymbolsResolveScope(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/JSElementResolveScopeProvider", "getElementResolveScope"));
        }
        return globalSearchScope;
    }

    public static GlobalSearchScope getFilesAndDirectoriesScope(Project project, Set<VirtualFile> filesAndDirectories) {
        THashSet libraryFiles = new THashSet();
        GlobalSearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
        for (VirtualFile file : filesAndDirectories) {
            if (file.isDirectory()) {
                GlobalSearchScope directoryScope = GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)file, (boolean)true);
                scope = scope.uniteWith(directoryScope);
                continue;
            }
            libraryFiles.add(file);
        }
        if (libraryFiles.size() > 0) {
            scope = scope.uniteWith(GlobalSearchScope.filesScope((Project)project, (Collection)libraryFiles));
        }
        return scope;
    }
}

