/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSPropertyNameResolver
implements JSResolveUtil.Resolver<JSPropertyNameReference> {
    private final JSPropertyNameReference myProperty;

    public JSPropertyNameResolver(JSPropertyNameReference property) {
        this.myProperty = property;
    }

    @Override
    public ResolveResult[] doResolve() {
        String qName;
        JSProperty property = this.myProperty.getElement();
        JSType type = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSObjectLiteralExpression)property.getParent()));
        if (type != null && (qName = JSTypeUtils.getQualifiedNameMatchingType(type, true)) != null) {
            List<JSClass> classes = JSDialectSpecificHandlersFactory.forElement((PsiElement)property).getClassResolver().findClassesByQName(qName, JSResolveUtil.getResolveScope((PsiElement)property));
            final ArrayList results = new ArrayList();
            for (JSClass jsClass : classes) {
                jsClass.processDeclarations((PsiScopeProcessor)new ResolveProcessor(property.getName()){
                    {
                        super(name);
                        this.setToProcessHierarchy(true);
                        this.setSkipImplicitDeclarations(true);
                    }

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver$1", "execute"));
                        }
                        if (state == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver$1", "execute"));
                        }
                        results.add(new JSResolveResult(element));
                        return true;
                    }

                    @Override
                    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver$1", "handleEvent"));
                        }
                    }
                }, ResolveState.initial(), (PsiElement)property, (PsiElement)property);
            }
            if (!results.isEmpty()) {
                return results.toArray(new ResolveResult[results.size()]);
            }
        }
        return new ResolveResult[]{new JSResolveResult((PsiElement)property)};
    }
}

