/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementProviderStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubBase;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSPossiblyStoredStubImpl<T extends JSImplicitElementProvider>
extends JSStubBase<T>
implements JSImplicitElementProviderStub<T> {
    protected static final BooleanStructureElement HAS_INDEXING_DATA_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(HAS_INDEXING_DATA_FLAG);
    @Nullable
    private final JSElementIndexingData myIndexingData;

    public JSPossiblyStoredStubImpl(T clazz, StubElement parent, IStubElementType<?, T> elementType) {
        super(clazz, parent, elementType);
        JSElementIndexingData indexingData = clazz.getIndexingData();
        this.myIndexingData = indexingData != null && !indexingData.isEmpty() ? indexingData : null;
        this.writeFlag(HAS_INDEXING_DATA_FLAG, this.myIndexingData != null);
    }

    public JSPossiblyStoredStubImpl(StubInputStream dataStream, StubElement parentStub, IStubElementType<?, T> elementType) throws IOException {
        super(dataStream, parentStub, elementType);
        this.myIndexingData = this.readFlag(HAS_INDEXING_DATA_FLAG) != false ? JSElementIndexingDataImpl.deserialize(dataStream, this) : null;
    }

    public void index(IndexSink sink) {
        JSElementIndexingDataImpl.index(this.myIndexingData, this, sink);
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_INDEXING_DATA_FLAG).booleanValue()) {
            JSElementIndexingDataImpl.serialize(this.myIndexingData, dataStream);
        }
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSPossiblyStoredStubImpl", "getFlagsStructure"));
        }
        return flagsStructure;
    }

    @Nullable
    public JSElementIndexingData getIndexingData() {
        return this.myIndexingData;
    }
}

