/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIterableComponentTypeImpl
extends JSTypeBaseImpl {
    @NotNull
    private JSType myIterableType;

    public JSIterableComponentTypeImpl(@NotNull JSType type, @NotNull JSTypeSource source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/JSIterableComponentTypeImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSIterableComponentTypeImpl", "<init>"));
        }
        super(source);
        this.myIterableType = type;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.SERIALIZED || format == JSType.TypeTextFormat.SIMPLE) {
            String string = "#compof(" + this.myIterableType.getTypeText(format) + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSIterableComponentTypeImpl", "getTypeText"));
            }
            return string;
        }
        JSType substitute = this.substitute();
        if (this != substitute) {
            String string = substitute.getTypeText(format);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSIterableComponentTypeImpl", "getTypeText"));
            }
            return string;
        }
        if ("*" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSIterableComponentTypeImpl", "getTypeText"));
        }
        return "*";
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        JSType type = this.substitute();
        if (type != this) {
            return type.isDirectlyAssignableType(elementType, processingContext);
        }
        return JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext).isAssignable();
    }

    public boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        if (type instanceof JSIterableComponentTypeImpl) {
            return ((JSIterableComponentTypeImpl)type).myIterableType.isEquivalentTo(this.myIterableType, processingContext);
        }
        return false;
    }

    @NotNull
    public JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSIterableComponentTypeImpl", "copyWithNewSource"));
        }
        JSIterableComponentTypeImpl jSIterableComponentTypeImpl = new JSIterableComponentTypeImpl(this.myIterableType, source);
        if (jSIterableComponentTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSIterableComponentTypeImpl", "copyWithNewSource"));
        }
        return jSIterableComponentTypeImpl;
    }

    @Override
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform, @Nullable JSTypeSource newSource) {
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/JSIterableComponentTypeImpl", "copyTypeHierarchy"));
        }
        return new JSIterableComponentTypeImpl(JSTypeUtils.transformTypeHierarchySafe(this.myIterableType, childTransform, newSource), this.getSourceForCopy(newSource));
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType type = JSTypeUtils.getIterableComponentType(this.myIterableType);
        Object object = type != null ? type : this;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSIterableComponentTypeImpl", "substitute"));
        }
        return object;
    }
}

