/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeofTypeImpl
extends JSSimpleTypeBaseImpl {
    private static final Key<ParameterizedCachedValue<JSType, JSTypeofTypeImpl>> CACHED_VALUE_KEY = Key.create((String)"js.typeoftype.evaluated");
    private static final ParameterizedCachedValueProvider<JSType, JSTypeofTypeImpl> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<JSType, JSTypeofTypeImpl>(){

        @Nullable
        public CachedValueProvider.Result<JSType> compute(JSTypeofTypeImpl param) {
            return CachedValueProvider.Result.create((Object)JSTypeUtils.getApparentType(param.evaluateType((Set)new THashSet())), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };
    @NotNull
    private final SmartPsiFileRange myRange;

    public JSTypeofTypeImpl(@NotNull JSExpression expression, @NotNull JSTypeSource source) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        this(expression.getTextRange(), expression.getContainingFile(), source);
    }

    public JSTypeofTypeImpl(@NotNull TextRange range, @NotNull PsiFile file, @NotNull JSTypeSource source) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        super(source);
        this.myRange = SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiFileRangePointer(file, range);
    }

    private JSTypeofTypeImpl(@NotNull SmartPsiFileRange range, JSTypeSource source) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        super(source);
        this.myRange = range;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.SERIALIZED || format == JSType.TypeTextFormat.SIMPLE) {
            Segment range = this.myRange.getRange();
            String string = range == null ? JSAnyType.get((PsiElement)this.getScope(), false).getTypeText(JSType.TypeTextFormat.SERIALIZED) : "#typeof(" + range.getStartOffset() + "," + range.getEndOffset() + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "getTypeText"));
            }
            return string;
        }
        JSType evaluatedType = this.evaluateType();
        String string = evaluatedType.getTypeText(format);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "getTypeText"));
        }
        return string;
    }

    @NotNull
    public JSType evaluateType() {
        PsiElement element = this.getSource().getSourceElement();
        if (element != null) {
            JSType jSType = (JSType)CachedValuesManager.getManager((Project)element.getProject()).getParameterizedCachedValue((UserDataHolder)this, CACHED_VALUE_KEY, CACHED_VALUE_PROVIDER, false, (Object)this);
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "evaluateType"));
            }
            return jSType;
        }
        JSType jSType = JSTypeUtils.getApparentType(this.evaluateType((Set<JSExpression>)new THashSet()));
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "evaluateType"));
        }
        return jSType;
    }

    @NotNull
    private JSType evaluateType(Set<JSExpression> visitedExpressions) {
        PsiElement element;
        JSTypeSource source = this.getSource();
        PsiElement sourceElement = source.getSourceElement();
        JSAnyType defaultType = JSAnyType.get((PsiElement)this.getScope(), false);
        if (sourceElement == null || !sourceElement.isValid()) {
            JSAnyType jSAnyType = defaultType;
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "evaluateType"));
            }
            return jSAnyType;
        }
        Segment range = this.myRange.getRange();
        PsiFile scope = source.getScope();
        if (scope == null) {
            JSAnyType jSAnyType = defaultType;
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "evaluateType"));
            }
            return jSAnyType;
        }
        PsiElement psiElement = element = range != null ? scope.findElementAt(range.getStartOffset()) : null;
        while (element != null && !(element instanceof PsiFile) && element.getTextRange().getStartOffset() == range.getStartOffset() && element.getTextRange().getEndOffset() <= range.getEndOffset()) {
            if (element.getTextRange().getEndOffset() == range.getEndOffset() && element instanceof JSExpression) {
                if (visitedExpressions.contains(element)) {
                    JSAnyType jSAnyType = defaultType;
                    if (jSAnyType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "evaluateType"));
                    }
                    return jSAnyType;
                }
                visitedExpressions.add((JSExpression)element);
                Ref exprTypeRef = Ref.create(null);
                JSTypeEvaluator.processWithEvaluationGuard((JSExpression)element, JSEvaluateContext.JSEvaluationPlace.TYPEOF_TYPE, e -> exprTypeRef.set((Object)JSResolveUtil.getExpressionJSType(e)));
                JSType exprType = (JSType)exprTypeRef.get();
                if (exprType != null) {
                    JSTypeSource exprTypeSource = exprType.getSource();
                    boolean isExplicitlyDeclared = source.isExplicitlyDeclared() && exprTypeSource.isExplicitlyDeclared();
                    JSTypeSource newSource = new JSTypeSource(exprTypeSource.getScope(), exprTypeSource.getSourceElement(), exprTypeSource.getLanguage(), isExplicitlyDeclared);
                    exprType = exprType instanceof JSTypeImpl ? ((JSTypeImpl)exprType).copyWithNewSource(newSource, true) : exprType.copyWithNewSource(newSource);
                    exprType = exprType.transformTypeHierarchy(type -> {
                        if (type instanceof JSTypeofTypeImpl) {
                            return ((JSTypeofTypeImpl)((Object)type)).evaluateType(visitedExpressions);
                        }
                        return type;
                    }, null);
                }
                Object object = exprType != null ? exprType : defaultType;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "evaluateType"));
                }
                return object;
            }
            element = element.getParent();
        }
        JSAnyType jSAnyType = defaultType;
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "evaluateType"));
        }
        return jSAnyType;
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        return null;
    }

    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        JSType type = this.evaluateType();
        return type.isDirectlyAssignableType(elementType, processingContext);
    }

    public boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        JSType thisType = this.evaluateType();
        if (type instanceof JSTypeofTypeImpl) {
            type = ((JSTypeofTypeImpl)type).evaluateType();
        }
        return thisType.isEquivalentTo(type, processingContext);
    }

    @NotNull
    public SmartPsiFileRange getRange() {
        SmartPsiFileRange smartPsiFileRange = this.myRange;
        if (smartPsiFileRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "getRange"));
        }
        return smartPsiFileRange;
    }

    @NotNull
    public JSTypeofTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "copyWithNewSource"));
        }
        JSTypeofTypeImpl jSTypeofTypeImpl = new JSTypeofTypeImpl(this.myRange, source);
        if (jSTypeofTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "copyWithNewSource"));
        }
        return jSTypeofTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.evaluateType();
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "substitute"));
        }
        return jSType;
    }
}

