/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPrimitiveArrayType
extends JSSpecialNamedTypeImpl
implements JSArrayType {
    public JSPrimitiveArrayType(JSTypeSource source, JSTypeContext staticOrInstance) {
        super(source, staticOrInstance);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if ("Array" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveArrayType", "getTypeText"));
        }
        return "Array";
    }

    @Override
    public boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (super.isDirectlyAssignableType(elementType, processingContext)) {
            return true;
        }
        if (elementType instanceof JSNullType || elementType instanceof JSArrayTypeImpl) {
            return true;
        }
        if (elementType instanceof JSGenericTypeImpl) {
            JSType type = ((JSGenericTypeImpl)elementType).getType();
            if (type instanceof JSPrimitiveArrayType || type instanceof JSArrayTypeImpl) {
                return true;
            }
            if (type instanceof JSNamedType) {
                return this.getTypeHelper().areNamedTypesAssignable(this, (JSNamedType)type, processingContext);
            }
        }
        return elementType instanceof JSTypeImpl && ("Arguments".equals(elementType.getResolvedTypeText()) || this.getTypeHelper().areNamedTypesAssignable(this, (JSNamedType)elementType, processingContext));
    }

    @Override
    @NotNull
    public JSGenericTypeImpl asGenericType() {
        JSGenericTypeImpl jSGenericTypeImpl = JSArrayType.GenericArrayBuilder.getGenericType(this, JSAnyType.get((PsiElement)this.getScope(), false));
        if (jSGenericTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSPrimitiveArrayType", "asGenericType"));
        }
        return jSGenericTypeImpl;
    }
}

