/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSPropertyFunctionRenameProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInplaceRenameHandler
extends VariableInplaceRenameHandler {
    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file) {
        return element instanceof JSNamedElement && element.getUseScope() instanceof LocalSearchScope && !JavaScriptSupportLoader.isMxmlOrFxgFile(InjectedLanguageUtil.getTopLevelFile((PsiElement)file)) && !JSPropertyFunctionRenameProcessor.isFieldWithAccessors(element);
    }

    @Nullable
    protected VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor) {
        if (elementToRename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToRename", "com/intellij/lang/javascript/refactoring/JSInplaceRenameHandler", "createRenamer"));
        }
        return new VariableInplaceRenamer((PsiNamedElement)((PsiNameIdentifierOwner)elementToRename), editor){
            private final Collection<Pair<PsiElement, TextRange>> myStringUsages;
            private boolean myDone;
            {
                this.myStringUsages = Collections.synchronizedList(new ArrayList());
                this.myDone = false;
            }

            protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
                LOG.assertTrue(!this.myDone);
                List<PsiReference> result = Collections.synchronizedList(new ArrayList());
                ReferencesSearch.search((PsiElement)this.myElementToRename, (SearchScope)referencesSearchScope).forEach(psiReference -> {
                    if (JSDefaultRenameProcessor.isStrictlyRenameableReference(psiReference)) {
                        result.add((PsiReference)psiReference);
                    } else {
                        this.myStringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)psiReference.getElement(), (Object)psiReference.getRangeInElement()));
                    }
                    return true;
                });
                return result;
            }

            protected void collectAdditionalElementsToRename(List<Pair<PsiElement, TextRange>> stringUsages) {
                LOG.assertTrue(!this.myDone);
                stringUsages.addAll(this.myStringUsages);
                super.collectAdditionalElementsToRename(stringUsages);
            }

            public boolean performInplaceRename() {
                boolean result = super.performInplaceRename();
                this.myDone = true;
                return result;
            }

            protected boolean buildTemplateAndStart(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope, PsiFile containingFile) {
                boolean result = super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
                PsiElement container = PsiTreeUtil.getNonStrictParentOfType((PsiElement)scope, (Class[])new Class[]{PsiFile.class, JSEmbeddedContent.class});
                if (container != null) {
                    this.myLanguage = container.getLanguage();
                }
                return result;
            }
        };
    }
}

