/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.findUsages.SuperMethodUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureDialog;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeSignatureHandler
extends BaseJSRefactoringHandler
implements ChangeSignatureHandler {
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"changeSignature.refactoring.name");
    private static final String CANNOT_REFACTOR_REASON = JSBundle.message((String)"error.wrong.caret.position.method.name", (Object[])new Object[0]);

    public JSChangeSignatureHandler() {
        super(REFACTORING_NAME, CANNOT_REFACTOR_REASON);
    }

    public PsiElement findTargetMember(PsiFile file, Editor editor) {
        return this.findTargetMember(file.findElementAt(editor.getCaretModel().getOffset()));
    }

    public PsiElement findTargetMember(PsiElement element) {
        ASTNode nameIdentifier;
        if (PsiTreeUtil.getParentOfType((PsiElement)element, JSParameterList.class) != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
        }
        JSFunction parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
        if (parentFunction != null && PsiTreeUtil.isAncestor((PsiElement)parentFunction.getNameIdentifier(), (PsiElement)element, (boolean)false)) {
            return parentFunction;
        }
        JSVariable parentVar = (JSVariable)PsiTreeUtil.getParentOfType((PsiElement)element, JSVariable.class);
        if (parentVar != null && PsiTreeUtil.isAncestor((PsiElement)parentVar.getNameIdentifier(), (PsiElement)element, (boolean)false)) {
            return PsiTreeUtil.getChildOfType((PsiElement)parentVar, JSFunctionExpression.class);
        }
        JSAssignmentExpression parentAssignment = (JSAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSAssignmentExpression.class);
        if (parentAssignment != null && parentAssignment.getLOperand() instanceof JSDefinitionExpression && PsiTreeUtil.isAncestor((PsiElement)parentAssignment.getLOperand(), (PsiElement)element, (boolean)false)) {
            return PsiTreeUtil.getChildOfType((PsiElement)parentAssignment, JSFunctionExpression.class);
        }
        JSProperty parentProperty = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JSProperty.class);
        if (parentProperty != null && parentProperty.getParent() instanceof JSObjectLiteralExpression && (nameIdentifier = parentProperty.findNameIdentifier()) != null && PsiTreeUtil.isAncestor((PsiElement)nameIdentifier.getPsi(), (PsiElement)element, (boolean)false)) {
            return PsiTreeUtil.getChildOfType((PsiElement)parentProperty, JSFunctionExpression.class);
        }
        JSCallExpression expression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSCallExpression.class);
        if (expression != null) {
            JSClass clazz;
            JSExpression methodExpression = expression.getMethodExpression();
            if (methodExpression instanceof JSReferenceExpression) {
                PsiElement resolved = ((JSReferenceExpression)methodExpression).resolve();
                if (resolved instanceof JSFunction) {
                    return resolved;
                }
                if (resolved instanceof JSVariable) {
                    return PsiTreeUtil.getChildOfType((PsiElement)resolved, JSFunctionExpression.class);
                }
                if (resolved instanceof JSDefinitionExpression && resolved.getParent() instanceof JSAssignmentExpression) {
                    return PsiTreeUtil.getChildOfType((PsiElement)resolved.getParent(), JSFunctionExpression.class);
                }
                if (resolved instanceof JSProperty && resolved.getParent() instanceof JSObjectLiteralExpression) {
                    return PsiTreeUtil.getChildOfType((PsiElement)resolved, JSFunctionExpression.class);
                }
            } else if (methodExpression instanceof JSSuperExpression && (clazz = JSResolveUtil.getClassOfContext((PsiElement)methodExpression)) != null) {
                return clazz.getSuperClasses()[0].getConstructor();
            }
        }
        return element;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureHandler", "invoke"));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement context = file.findElementAt(editor.getCaretModel().getOffset());
        PsiElement element = this.findTargetMember(file, editor);
        if (element == null) {
            element = context;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus(element, editor, REFACTORING_NAME)) {
            return;
        }
        if (!(element instanceof JSFunction)) {
            CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)RefactoringBundle.getCannotRefactorMessage((String)CANNOT_REFACTOR_REASON), (String)REFACTORING_NAME, null);
            return;
        }
        JSChangeSignatureHandler.invoke((JSFunction)element, element.getProject(), context);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element = JSResolveUtil.unwrapProxy(elements[0]);
        JSFunctionItem functionItem = JSPsiImplUtils.calculatePossibleFunction(element);
        if (functionItem instanceof PsiElement) {
            element = functionItem;
        }
        if (!JSChangeSignatureHandler.canRefactor(element, editor)) {
            return;
        }
        PsiElement contextElement = JSChangeSignatureHandler.getContextElement(dataContext);
        JSChangeSignatureHandler.invoke((JSFunction)element, project, contextElement != null ? contextElement : element);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return null;
    }

    public static boolean canRefactor(PsiElement element, Editor editor) {
        if (!JSRefactoringUtil.checkReadOnlyStatus(element, editor, REFACTORING_NAME)) {
            return false;
        }
        if (element instanceof JSFunctionExpression) {
            boolean result = JSChangeSignatureHandler.canRefactorFunctionExpression((JSFunctionExpression)element, true);
            if (!result) {
                CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)JSBundle.message((String)"cannot.refactor.anonymous.function", (Object[])new Object[0])), (String)REFACTORING_NAME, null);
            }
            return result;
        }
        if (element instanceof JSFunction) {
            return true;
        }
        CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)CANNOT_REFACTOR_REASON), (String)REFACTORING_NAME, null);
        return false;
    }

    public static boolean canRefactorFunctionExpression(JSFunctionExpression element, boolean acceptEventListenerCall) {
        PsiElement parent = element.getParent();
        boolean result = parent instanceof JSVariable || parent instanceof JSProperty || parent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parent).getLOperand() instanceof JSDefinitionExpression ? ReferencesSearch.search((PsiElement)parent, (SearchScope)parent.getUseScope()).forEach(psiReference -> {
            if (!(psiReference instanceof JSReferenceExpression)) {
                return true;
            }
            if (JSResolveUtil.isSelfReference(parent, (PsiElement)psiReference)) {
                return true;
            }
            PsiElement refParent = ((JSReferenceExpression)psiReference).getParent();
            if (JSChangeSignatureHandler.isEventListenerCallArgument(refParent)) {
                return true;
            }
            return refParent instanceof JSCallExpression;
        }) : acceptEventListenerCall && JSChangeSignatureHandler.isEventListenerCallArgument(parent);
        return result;
    }

    private static boolean isEventListenerCallArgument(PsiElement element) {
        return element instanceof JSArgumentList && element.getParent() instanceof JSCallExpression && JSResolveUtil.isEventListenerCall((JSCallExpression)element.getParent());
    }

    @Nullable
    private static PsiElement getContextElement(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null) {
            return null;
        }
        return file.findElementAt(editor.getCaretModel().getOffset());
    }

    private static void invoke(JSFunction method, Project project, @Nullable PsiElement context) {
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)method, null, REFACTORING_NAME)) {
            return;
        }
        JSFunction newMethod = SuperMethodUtil.checkSuperMethod(method, REFACTORING_NAME, RefactoringBundle.message((String)"to.refactor"));
        if (newMethod == null) {
            return;
        }
        if (!newMethod.equals(method)) {
            JSChangeSignatureHandler.invoke(newMethod, project, context);
            return;
        }
        JSChangeSignatureDialog dialog = new JSChangeSignatureDialog(method, false, context);
        dialog.show();
    }
}

