/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduce;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.HighlightingUtils;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.ClassLevelIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlText;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSBaseIntroduceHandler<T extends JSElement, S extends BaseIntroduceSettings, D extends JSBaseIntroduceDialog>
implements RefactoringActionHandler {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler");
    @NonNls
    public static final String SYNC_TEST_CHOOSER = "sync.test.chooser";
    protected Replacer myReplacer;

    @Nullable
    public static List<Pair<JSExpression, TextRange>> findExpressionsInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        PsiElement sibling;
        int expressionEnd;
        PsiElement element2;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler", "findExpressionsInRange"));
        }
        PsiElement element1 = file.findElementAt(startOffset);
        ArrayList<Pair<JSExpression, TextRange>> result = new ArrayList<Pair<JSExpression, TextRange>>();
        if (startOffset == endOffset) {
            element1 = file.findElementAt(startOffset - 1);
            boolean checkedForInsideAnonymousEventHandler = false;
            for (element1 = JSBaseIntroduceHandler.adjustElement(startOffset, element1); element1 != null && !(element1 instanceof JSStatement); element1 = element1.getParent()) {
                if (element1 instanceof JSExpression) {
                    if (!checkedForInsideAnonymousEventHandler) {
                        checkedForInsideAnonymousEventHandler = true;
                        if (ActionScriptResolveUtil.computeIfInsideAnonymousEventHandler(element1, new ConstantFunction((Object)Boolean.TRUE)) != null) {
                            return null;
                        }
                    }
                    if (!JSBaseIntroduceHandler.isValidExpressionForSmartIntroduce(element1)) continue;
                    result.add((Pair<JSExpression, TextRange>)new Pair((Object)((JSExpression)element1), null));
                    continue;
                }
                if (!(element1 instanceof JSArgumentList) && !result.isEmpty()) break;
            }
            return result;
        }
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
        }
        if ((element2 = file.findElementAt(endOffset - 1)) instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
        }
        TextRange range = new TextRange(startOffset, endOffset);
        JSExpression expression = (JSExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, JSExpression.class);
        if (expression != null && (Boolean.TRUE.equals(ActionScriptResolveUtil.computeIfInsideAnonymousEventHandler((PsiElement)expression, new ConstantFunction((Object)Boolean.TRUE))) || !JSBaseIntroduceHandler.isValidExpression((PsiElement)expression))) {
            return null;
        }
        if (expression == null || (expressionEnd = expression.getTextRange().getEndOffset()) != endOffset && (expressionEnd != endOffset - 1 || (sibling = expression.getNextSibling()) == null || sibling.getNode().getElementType() != JSTokenTypes.SEMICOLON)) {
            expression = null;
        } else if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression) != ReadWriteAccessDetector.Access.Read) {
            return null;
        }
        if (expression == null && element1 == element2 && element1 != null) {
            PsiElement parent = element1.getParent();
            if (parent instanceof XmlText) {
                parent = parent.getParent();
            }
            if (parent instanceof JSLiteralExpression && element1.getTextRange().contains(range)) {
                result.add((Pair<JSExpression, TextRange>)Pair.create((Object)((JSExpression)parent), (Object)range));
                return result;
            }
        }
        if (expression == null && element1 != null && element2 != null) {
            JSExpression element1ExpressionParent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)element1, JSExpression.class);
            JSExpression element2ExpressionParent = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, JSExpression.class);
            range = new TextRange(startOffset, endOffset);
            if (element1ExpressionParent != null && element2ExpressionParent != null && range.contains(element1ExpressionParent.getTextRange()) && range.contains(element2ExpressionParent.getTextRange())) {
                PsiElement nextParent;
                PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
                if (!(parent instanceof JSExpression)) {
                    parent = null;
                }
                while (!(parent == null || parent instanceof JSBinaryExpression && parent.getTextRange().contains(range) || JSBaseIntroduceHandler.elementNotAllowedInRange(range, parent) || !((nextParent = parent.getParent()) instanceof JSExpression))) {
                    parent = nextParent;
                }
                if (parent instanceof JSBinaryExpression) {
                    if ((parent = JSBaseIntroduceHandler.ensureNoIntersection(range, parent, element1ExpressionParent)) != null) {
                        parent = JSBaseIntroduceHandler.ensureNoIntersection(range, parent, element2ExpressionParent);
                    }
                    if (parent != null) {
                        result.add((Pair<JSExpression, TextRange>)Pair.create((Object)((JSExpression)parent), (Object)range));
                        return result;
                    }
                }
            }
        }
        if (expression == null) {
            return null;
        }
        if (expression instanceof JSReferenceExpression && JSBaseIntroduceHandler.isInvalidRefExpr((JSReferenceExpression)expression)) {
            return null;
        }
        result.add((Pair<JSExpression, TextRange>)new Pair((Object)expression, null));
        return result;
    }

    public static PsiElement adjustElement(int startOffset, PsiElement element1) {
        JSExpression returnedExpression;
        JSReturnStatement ret;
        IElementType element1NodeType;
        if (element1 instanceof PsiWhiteSpace && startOffset == element1.getTextRange().getEndOffset()) {
            element1 = PsiTreeUtil.nextLeaf((PsiElement)element1);
        } else if (element1 != null && element1.getNode() != null && ((element1NodeType = element1.getNode().getElementType()) == JSTokenTypes.LPAR || element1NodeType == JSTokenTypes.LBRACKET || element1NodeType == JSTokenTypes.COMMA)) {
            element1 = PsiTreeUtil.nextLeaf((PsiElement)element1);
        }
        if (element1 != null && element1.getNode() != null && (element1.getNode().getElementType() == JSTokenTypes.SEMICOLON || element1.getNode().getElementType() == JSTokenTypes.RPAR)) {
            element1 = PsiTreeUtil.prevLeaf((PsiElement)element1);
        }
        if (element1 != null && element1.getNode() != null && element1.getNode().getElementType() == JSTokenTypes.RETURN_KEYWORD && (ret = (JSReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)element1, JSReturnStatement.class)) != null && (returnedExpression = ret.getExpression()) != null) {
            element1 = returnedExpression.getFirstChild();
        }
        return element1;
    }

    private static boolean isValidExpressionForSmartIntroduce(PsiElement element1) {
        boolean validExpression = JSBaseIntroduceHandler.isValidExpression(element1);
        if (validExpression && element1 instanceof JSReferenceExpression && element1.getParent() instanceof JSCallExpression) {
            validExpression = false;
        }
        return validExpression;
    }

    private static boolean isValidExpression(PsiElement element1) {
        boolean result = true;
        if (element1 instanceof JSReferenceExpression && JSBaseIntroduceHandler.isInvalidRefExpr((JSReferenceExpression)element1) || element1 instanceof JSDefinitionExpression || element1 instanceof JSLiteralExpression && element1.getParent() instanceof TypeScriptModule || element1 instanceof JSExpression && element1.getParent() instanceof JSReferenceListMember && !(element1.getParent().getParent() instanceof ES6ReferenceList) || element1 instanceof JSArrayLiteralExpression && element1.getParent() instanceof JSNewExpression || element1 instanceof JSCallExpression && "void".equals(JSResolveUtil.getExpressionType((JSExpression)element1, element1.getContainingFile()))) {
            result = false;
        }
        return result;
    }

    private static boolean isInvalidRefExpr(JSReferenceExpression element1) {
        PsiElement element1Parent = element1.getParent();
        return element1Parent instanceof JSGenericSignature || element1 instanceof TypeScriptEntityName || element1Parent instanceof JSDefinitionExpression || JSResolveUtil.isSelfReference((PsiElement)element1) || element1.getQualifier() == null && element1.resolve() instanceof JSClass || element1.resolve() instanceof JSPackage || element1Parent instanceof JSImportStatement;
    }

    private static PsiElement ensureNoIntersection(TextRange range, PsiElement parent, JSExpression element2ExpressionParent) {
        for (JSExpression e = element2ExpressionParent; e != parent; e = e.getParent()) {
            if (!JSBaseIntroduceHandler.elementNotAllowedInRange(range, (PsiElement)e)) continue;
            parent = null;
            break;
        }
        return parent;
    }

    private static boolean elementNotAllowedInRange(TextRange range, PsiElement parent) {
        return parent instanceof JSParenthesizedExpression && !range.contains(parent.getTextRange());
    }

    protected boolean visitInnerFunctions() {
        return false;
    }

    public void invoke(final @NotNull Project project, final Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler", "invoke"));
        }
        String featureId = this.getProductivityFeatureId();
        if (featureId != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int start = editor.getSelectionModel().getSelectionStart();
        int end = editor.getSelectionModel().getSelectionEnd();
        final Pair<JSExpression, TextRange> expressionDescriptor = this.findIntroducedExpression(file, start, end, editor, dataContext);
        if (expressionDescriptor == null) {
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)file, editor, this.getRefactoringName())) {
            return;
        }
        final JSElement scope = this.findIntroducedScope(expressionDescriptor, dataContext);
        if (scope == null) {
            CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor, (String)JSBundle.message((String)"javascript.introduce.variable.arrow.function.parameter.referenced", (Object[])new Object[0]), (String)this.getRefactoringName(), null);
            return;
        }
        final JSExpression[] occurrences = JSUtils.findExpressionOccurrences(scope, expressionDescriptor, this.visitInnerFunctions());
        final boolean inplaceJavaScriptIntroduce = this.isInplaceIntroduce(editor, file);
        Pass<OccurrencesChooser.ReplaceChoice> callback = new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice choice) {
                BaseIntroduceSettings settings;
                InplaceSettings inplaceSettings = JSBaseIntroduceHandler.this.getInplaceSettings((Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope, choice);
                BaseIntroduceSettings baseIntroduceSettings = settings = choice == null ? JSBaseIntroduceHandler.this.getSettings(project, editor, (Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope) : (BaseIntroduceSettings)inplaceSettings.getSettings();
                if (settings == null) {
                    return;
                }
                editor.getSelectionModel().removeSelection();
                JSBaseIntroduceHandler.this.doPreprocess(project, settings);
                BaseIntroduceContext<BaseIntroduceSettings> introduceContext = new BaseIntroduceContext<BaseIntroduceSettings>((Pair<JSExpression, TextRange>)expressionDescriptor, occurrences, (PsiElement)scope, settings);
                if (inplaceJavaScriptIntroduce) {
                    JSBaseInplaceIntroducer<BaseIntroduceSettings> introducer = JSBaseIntroduceHandler.this.createInplaceIntroducer(introduceContext, scope, editor, project, occurrences);
                    introducer.startInplaceIntroduceTemplate();
                } else {
                    CommandProcessor.getInstance().executeCommand(project, () -> {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler$1", "lambda$pass$1"));
                        }
                        ApplicationManager.getApplication().runWriteAction(() -> {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler$1", "lambda$null$0"));
                            }
                            JSBaseIntroduceHandler.this.doRefactoring(project, editor, introduceContext, true);
                            JSBaseIntroduceHandler.this.performIntroduce(introduceContext);
                        });
                    }, JSBaseIntroduceHandler.this.getRefactoringName(), null);
                }
            }
        };
        if (inplaceJavaScriptIntroduce) {
            LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<JSExpression>> occurrencesMap = new LinkedHashMap<OccurrencesChooser.ReplaceChoice, List<JSExpression>>();
            occurrencesMap.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(expressionDescriptor.getFirst()));
            if (occurrences.length > 1) {
                occurrencesMap.put(OccurrencesChooser.ReplaceChoice.ALL, Arrays.asList(occurrences));
            }
            this.chooseOccurrencesToReplace(editor, occurrencesMap, callback);
        } else {
            callback.pass(null);
        }
    }

    protected boolean isInplaceIntroduce(Editor editor, PsiFile file) {
        return (file.getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4 || this instanceof JSIntroduceVariableHandler) && editor.getSettings().isVariableInplaceRenameEnabled();
    }

    protected void chooseOccurrencesToReplace(Editor editor, Map<OccurrencesChooser.ReplaceChoice, List<JSExpression>> occurrencesMap, Pass<OccurrencesChooser.ReplaceChoice> callback) {
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser(callback, occurrencesMap);
    }

    protected abstract JSBaseInplaceIntroducer<S> createInplaceIntroducer(BaseIntroduceContext<S> var1, JSElement var2, Editor var3, Project var4, JSExpression[] var5);

    protected void doPreprocess(Project project, S settings) {
    }

    @Nullable
    protected String getProductivityFeatureId() {
        return null;
    }

    protected static String prependAccessModifier(BaseIntroduceContext<? extends ClassLevelIntroduceSettings> baseIntroduceContext, String baseDeclText) {
        JSExpression expression;
        JSAttributeList.AccessType type = ((ClassLevelIntroduceSettings)baseIntroduceContext.settings).getAccessType();
        String accessText = JSChangeVisibilityUtil.accessTypeToCodeString(type, (PsiElement)(expression = (JSExpression)baseIntroduceContext.expressionDescriptor.first));
        if (!StringUtil.isEmpty((String)accessText)) {
            baseDeclText = accessText + " " + baseDeclText;
        }
        return baseDeclText;
    }

    public static boolean introduceOverVariableNameRef(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof JSVariable && JSResolveUtil.isSelfReference(element);
    }

    public static boolean calcDependsOnContext(final PsiElement occurrence, final boolean okToAccessThis, final boolean okToAccessOccurrence) {
        if (occurrence == null) {
            return false;
        }
        final Ref localContextDependent = new Ref();
        occurrence.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (node.getQualifier() == null && !JSResolveUtil.isExprInStrictTypeContext(node)) {
                    ResolveResult[] results = node.multiResolve(true);
                    if (results.length == 0) {
                        localContextDependent.set((Object)Boolean.TRUE);
                    } else {
                        PsiElement element = results[0].getElement();
                        if ((element instanceof JSVariable || element instanceof JSFunction) && !(JSResolveUtil.findParent(element) instanceof JSClass) && PsiTreeUtil.findCommonParent((PsiElement)element, (PsiElement)occurrence) != occurrence && (occurrence.getParent() != element || okToAccessOccurrence)) {
                            localContextDependent.set((Object)Boolean.TRUE);
                        }
                    }
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSThisExpression(JSThisExpression node) {
                if (!okToAccessThis) {
                    localContextDependent.set((Object)Boolean.TRUE);
                }
                super.visitJSThisExpression(node);
            }
        });
        return localContextDependent.get() == Boolean.TRUE;
    }

    @Nullable
    protected JSElement findIntroducedScope(Pair<JSExpression, TextRange> expressionDescriptor, DataContext dataContext) {
        JSExpression expression = (JSExpression)expressionDescriptor.first;
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)expression, JSExecutionScope.class);
        if (scope != null && scope.getNode().getElementType() == JSElementTypes.EMBEDDED_EXPRESSION) {
            return (JSElement)PsiTreeUtil.getParentOfType((PsiElement)scope.getParent(), JSExecutionScope.class);
        }
        if (scope instanceof JSFunction && JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)scope) != null) {
            JSParameter[] parameters = ((JSFunction)scope).getParameterVariables();
            final THashSet parameterNames = new THashSet();
            for (JSParameter parameter : parameters) {
                parameterNames.add((Object)parameter.getName());
            }
            final Ref paramRefFound = Ref.create((Object)Boolean.FALSE);
            final TextRange range = (TextRange)expressionDescriptor.second;
            expression.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    if (!((Boolean)paramRefFound.get()).booleanValue()) {
                        super.visitElement(element);
                    }
                }

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    if (node.getQualifier() == null && parameterNames.contains((Object)node.getReferenceName()) && (range == null || range.contains(node.getTextRange()))) {
                        paramRefFound.set((Object)Boolean.TRUE);
                    } else {
                        super.visitJSReferenceExpression(node);
                    }
                }
            });
            return (Boolean)paramRefFound.get() != false ? null : (JSElement)PsiTreeUtil.getParentOfType((PsiElement)scope, JSExecutionScope.class);
        }
        return scope;
    }

    protected abstract String getRefactoringName();

    protected abstract String getCannotIntroduceMessagePropertyKey();

    protected abstract String getCannotIntroduceVoidExpressionTypeMessagePropertyKey();

    protected static boolean isIntroducingPartOfExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        return expressionDescriptor.second != null;
    }

    @Nullable
    protected Pair<JSExpression, TextRange> findIntroducedExpression(final PsiFile file, int start, int end, final Editor editor, DataContext dataContext) {
        Pair<JSExpression, TextRange> rangePair;
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)file, editor, this.getRefactoringName())) {
            return null;
        }
        List<Pair<JSExpression, TextRange>> expressionDescriptors = JSBaseIntroduceHandler.findExpressionsInRange(file, start, end);
        String errorMessage = null;
        if (expressionDescriptors == null || expressionDescriptors.isEmpty()) {
            errorMessage = JSBundle.message((String)this.getCannotIntroduceMessagePropertyKey(), (Object[])new Object[0]);
        } else {
            if (expressionDescriptors.size() > 1) {
                List expressions = ContainerUtil.map2List(expressionDescriptors, jsExpressionTextRangePair -> (JSExpression)jsExpressionTextRangePair.first);
                Pass<JSExpression> callback = new Pass<JSExpression>(){

                    public void pass(JSExpression jsExpression) {
                        TextRange textRange = jsExpression.getTextRange();
                        editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                        JSBaseIntroduceHandler.this.invoke(editor.getProject(), editor, file, DataManager.getInstance().getDataContext());
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    Object chooser = dataContext != null ? dataContext.getData(SYNC_TEST_CHOOSER) : null;
                    JSExpression chosen = (JSExpression)expressions.get(expressions.size() - 1);
                    if (chooser instanceof Function) {
                        chosen = (JSExpression)((Function)chooser).fun((Object)expressions.toArray(new JSExpression[expressions.size()]));
                    }
                    callback.pass((Object)chosen);
                    return null;
                }
                IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions, (Pass)callback, jsExpression -> jsExpression.getText());
                return null;
            }
            String s = JSResolveUtil.getExpressionType((JSExpression)expressionDescriptors.get((int)0).first, file);
            if ("void".equals(s)) {
                errorMessage = JSBundle.message((String)this.getCannotIntroduceVoidExpressionTypeMessagePropertyKey(), (Object[])new Object[0]);
                expressionDescriptors = null;
            }
        }
        if (errorMessage != null) {
            CommonRefactoringUtil.showErrorHint((Project)file.getProject(), (Editor)editor, (String)errorMessage, (String)this.getRefactoringName(), null);
            return null;
        }
        Pair<JSExpression, TextRange> pair = rangePair = expressionDescriptors != null && !expressionDescriptors.isEmpty() ? expressionDescriptors.get(0) : null;
        if (rangePair != null && !editor.getSelectionModel().hasSelection()) {
            TextRange textRange = rangePair.second != null ? (TextRange)rangePair.second : ((JSExpression)rangePair.first).getTextRange();
            editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        }
        return rangePair;
    }

    protected abstract InplaceSettings<S> getInplaceSettings(Pair<JSExpression, TextRange> var1, JSExpression[] var2, PsiElement var3, OccurrencesChooser.ReplaceChoice var4);

    @Nullable
    protected S getSettings(Project project, Editor editor, Pair<JSExpression, TextRange> expressionDescriptor, JSExpression[] occurrences, PsiElement scope) {
        ArrayList<RangeHighlighter> highlighters = null;
        if (occurrences.length > 1) {
            highlighters = HighlightingUtils.highlightOccurrences(project, editor, (PsiElement[])occurrences);
        }
        D dialog = this.createDialog(project, this.getReplacementExpression(expressionDescriptor), occurrences, scope);
        dialog.show();
        if (highlighters != null) {
            for (RangeHighlighter highlighter : highlighters) {
                HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, highlighter);
            }
        }
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return this.createSettings(dialog);
    }

    protected S createSettings(D dialog) {
        return (S)dialog;
    }

    protected abstract D createDialog(Project var1, JSExpression var2, JSExpression[] var3, PsiElement var4);

    @Nullable
    IntroduceInfo doRefactoring(Project project, Editor editor, BaseIntroduceContext<S> introduceContext, boolean replaceExpressions) {
        Object settings = introduceContext.settings;
        boolean replaceAllOccurences = settings.isReplaceAllOccurrences();
        T anchorStatement = this.findAnchor(introduceContext, replaceAllOccurences);
        String varDeclText = this.getDeclText(introduceContext, anchorStatement);
        JSExpression expression = (JSExpression)introduceContext.expressionDescriptor.first;
        JSExpression[] occurrences = introduceContext.occurences;
        this.myReplacer = new Replacer(introduceContext.expressionDescriptor);
        PsiFile containingFile = expression.getContainingFile();
        JSLanguageDialect languageDialect = JSUtils.getDialect(containingFile);
        boolean ecma = JavaScriptSupportLoader.ECMA_SCRIPT_L4 == languageDialect;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        SmartPsiElementPointer expressionPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)expression);
        if (ecma) {
            String type = settings.getVariableType();
            if (type == null) {
                type = new BasicIntroducedEntityInfoProvider(expression, occurrences, introduceContext.scope).evaluateType();
                if ((type = JSResolveUtil.getQualifiedTypeName(type)) == null) {
                    type = JSClassUtils.getAnyTypeString((PsiElement)expression, false);
                }
            }
            if (!JSBaseIntroduceHandler.isIntroducingPartOfExpression(introduceContext.expressionDescriptor)) {
                ArrayList<SmartPsiElementPointer> occurrencesPointers = new ArrayList<SmartPsiElementPointer>(occurrences.length);
                for (JSExpression occurrence : occurrences) {
                    occurrencesPointers.add(smartPointerManager.createSmartPsiElementPointer((PsiElement)occurrence));
                }
                type = (String)ImportUtils.importAndShortenReference((String)type, (PsiElement)expression, (boolean)true, (boolean)true).first;
                ArrayList<PsiElement> occurrencesList = new ArrayList<PsiElement>(occurrences.length);
                for (SmartPsiElementPointer occurrencesPointer : occurrencesPointers) {
                    occurrencesList.add(occurrencesPointer.getElement());
                }
                Pair rangePair = new Pair((Object)expressionPointer.getElement(), null);
                occurrences = occurrencesList.toArray(new JSExpression[occurrencesList.size()]);
                introduceContext = new BaseIntroduceContext((Pair<JSExpression, TextRange>)rangePair, occurrences, introduceContext.scope, introduceContext.settings);
                anchorStatement = this.findAnchor(introduceContext, replaceAllOccurences);
            }
            varDeclText = varDeclText + ":" + type;
        }
        try {
            LOG.assertTrue(anchorStatement != null);
            if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)anchorStatement.getContainingFile(), editor, this.getRefactoringName())) {
                return null;
            }
            Pair<JSVarStatement, Boolean> preparedDeclarationStatus = this.prepareDeclaration(varDeclText, introduceContext, project, languageDialect, anchorStatement, editor, expression);
            JSVarStatement declaration = (JSVarStatement)preparedDeclarationStatus.first;
            boolean replacedOriginal = (Boolean)preparedDeclarationStatus.second;
            SmartPsiElementPointer jsVariablePointer = null;
            SmartPsiElementPointer jsVarStatementPointer = null;
            PsiElement elementToFixFormat = null;
            if (!replacedOriginal) {
                JSExpression oldExpression = expression;
                TextRange expressionTextRange = expression.getTextRange();
                JSExpression[] statementTextRange = anchorStatement.getTextRange();
                RangeMarker marker = editor.getDocument().createRangeMarker(expressionTextRange);
                JSVariable jsVariable = this.addStatementBefore(anchorStatement, declaration);
                PsiElement jsStatement = jsVariable.getParent();
                if (jsStatement instanceof JSVarStatement) {
                    jsVarStatementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)((JSVarStatement)jsStatement));
                } else {
                    jsVariablePointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)jsVariable);
                }
                if (!expression.isValid()) {
                    JSExpression candidateExpression;
                    int relativeOffset;
                    JSElement newAnchorStatement = (JSElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)jsStatement, anchorStatement.getClass());
                    JSExpression newExpression = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)newAnchorStatement.findElementAt(relativeOffset = marker.getStartOffset() - statementTextRange.getStartOffset()), oldExpression.getClass());
                    if (newExpression == null) assert (false) : "Could not find " + oldExpression.getClass() + " in " + newAnchorStatement.getText() + " with offset " + marker.getStartOffset();
                    while (newExpression.getTextRange().getLength() != expressionTextRange.getLength() && (candidateExpression = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)newExpression, oldExpression.getClass())) != null && candidateExpression.getTextRange().getStartOffset() - newAnchorStatement.getTextRange().getStartOffset() == marker.getStartOffset() - statementTextRange.getStartOffset()) {
                        newExpression = candidateExpression;
                    }
                    for (int i = 0; i < occurrences.length; ++i) {
                        if (occurrences[i] != oldExpression) continue;
                        occurrences[i] = newExpression;
                        break;
                    }
                    expression = newExpression;
                    expressionPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)expression);
                }
                elementToFixFormat = jsStatement;
            } else {
                jsVariablePointer = null;
                jsVarStatementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)declaration);
            }
            JSExpression refExpr = this.createRefExpr(project, settings, languageDialect);
            if (replaceExpressions && replaceAllOccurences) {
                ArrayList<JSExpression> toHighlight = new ArrayList<JSExpression>();
                for (JSExpression occurrence : occurrences) {
                    if (occurrence != expression || !replacedOriginal) {
                        JSExpression jsExpression = this.myReplacer.replaceExpr(occurrence, refExpr);
                        if (jsExpression == null) continue;
                        if (occurrence == expression) {
                            expression = jsExpression;
                        }
                        toHighlight.add(this.getExpressionForHighlight(jsExpression));
                        continue;
                    }
                    JSExpression initializer = declaration.getVariables()[0].getInitializer();
                    if (initializer == null) continue;
                    toHighlight.add(initializer);
                }
                HighlightingUtils.highlightOccurrences(project, editor, (PsiElement[])toHighlight.toArray(new JSExpression[toHighlight.size()]));
            }
            if (!replaceAllOccurences && !replacedOriginal) {
                expression = this.getExpressionForHighlight(this.myReplacer.replaceExpr((JSExpression)expressionPointer.getElement(), refExpr));
            }
            PsiDocumentManager instance = PsiDocumentManager.getInstance((Project)project);
            instance.doPostponedOperationsAndUnblockDocument(editor.getDocument());
            instance.commitDocument(editor.getDocument());
            if (elementToFixFormat != null) {
                JSBaseIntroduceHandler.fixFormat(project, elementToFixFormat);
            }
            this.doPostprocess(declaration, settings, editor);
            JSVariable createdVar = null;
            if (jsVarStatementPointer != null) {
                JSVarStatement varStatement = (JSVarStatement)jsVarStatementPointer.getElement();
                if (varStatement != null) {
                    createdVar = varStatement.getVariables()[0];
                }
            } else {
                createdVar = (JSVariable)jsVariablePointer.getElement();
            }
            return new IntroduceInfo(createdVar, (JSExpression)(expression.isValid() ? expression : null));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected JSExpression getExpressionForHighlight(JSExpression expression) {
        return expression;
    }

    protected JSExpression createRefExpr(Project project, S settings, JSLanguageDialect languageDialect) {
        return (JSExpression)JSChangeUtil.createExpressionFromText(project, settings.getVariableName(), languageDialect).getPsi();
    }

    protected static void fixFormat(Project project, PsiElement jsStatement) {
        CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(jsStatement.getParent().getNode(), jsStatement.getNode());
    }

    protected void doPostprocess(JSVarStatement declaration, S settings, Editor editor) {
    }

    public void performIntroduce(@NotNull BaseIntroduceContext<S> introduceContext) {
        if (introduceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "introduceContext", "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler", "performIntroduce"));
        }
    }

    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, BaseIntroduceContext<S> context, Project project, JSLanguageDialect languageDialect, T anchorStatement, Editor editor, JSExpression introducedExpression) throws IncorrectOperationException {
        JSExpression initializerReplacementExpression = this.getReplacementExpression(context.expressionDescriptor);
        JSVarStatement declaration = (JSVarStatement)JSChangeUtil.createStatementFromText(project, varDeclText + (initializerReplacementExpression != null ? " = 0" : "") + JSCodeStyleSettings.getSemicolon(context.scope.getContainingFile()), languageDialect).getPsi();
        this.replaceInitializer(initializerReplacementExpression, declaration);
        return Pair.create((Object)declaration, (Object)Boolean.FALSE);
    }

    protected void replaceInitializer(JSExpression initializerReplacementExpression, JSVarStatement declaration) {
        JSVariable variable = declaration.getVariables()[0];
        JSExpression initializer = variable.getInitializer();
        if (initializer != null && initializerReplacementExpression != null) {
            initializer.replace(initializerReplacementExpression);
        }
    }

    protected JSExpression getReplacementExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        JSExpression jsExpression = (JSExpression)expressionDescriptor.first;
        if (!JSBaseIntroduceHandler.isIntroducingPartOfExpression(expressionDescriptor)) {
            return jsExpression;
        }
        String value = this.getIntroducedExpressionText(expressionDescriptor);
        JSVarStatement declaration = (JSVarStatement)JSChangeUtil.createStatementFromText(jsExpression.getProject(), "var xxx = " + value + JSCodeStyleSettings.getSemicolon(jsExpression.getContainingFile()), JSUtils.getDialect(jsExpression.getContainingFile())).getPsi();
        return declaration.getVariables()[0].getInitializer();
    }

    protected String getIntroducedExpressionText(Pair<JSExpression, TextRange> expressionDescriptor) {
        if (this.myReplacer == null) {
            this.myReplacer = new Replacer(expressionDescriptor);
        }
        return this.myReplacer.getIntroducedExpressionText();
    }

    @NonNls
    protected String getDeclText(BaseIntroduceContext<S> baseIntroduceContext, T anchor) {
        return this.calcDeclText(baseIntroduceContext, "var", anchor);
    }

    protected String calcDeclText(BaseIntroduceContext<S> baseIntroduceContext, String s, T anchor) {
        boolean isStatic = JSResolveUtil.calculateStaticFromContext((PsiElement)this.getElementForContextTypeCheck(baseIntroduceContext, anchor));
        JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType(anchor, JSFunction.class);
        if (s.length() > 0) {
            s = s + " ";
        }
        return (isStatic && fun == null ? "static " : "") + s + baseIntroduceContext.settings.getVariableName();
    }

    protected JSElement getElementForContextTypeCheck(BaseIntroduceContext<S> baseIntroduceContext, T anchor) {
        return (JSElement)baseIntroduceContext.expressionDescriptor.first;
    }

    protected JSVariable addStatementBefore(T anchor, JSVarStatement declaration) throws IncorrectOperationException {
        JSVarStatement statement = JSChangeUtil.addSourceElement((JSSourceElement)anchor, declaration, true);
        return statement.getVariables()[0];
    }

    protected T findAnchor(BaseIntroduceContext<S> context, boolean replaceAllOccurences) {
        JSSourceElement anchorStatement;
        JSExpression expression = (JSExpression)context.expressionDescriptor.first;
        JSSourceElement jSSourceElement = anchorStatement = replaceAllOccurences ? JSBaseIntroduceHandler.getAnchorToInsert(context.occurences) : JSUtils.findSourceAnchor((PsiElement)expression, DialectDetector.isActionScript((PsiElement)expression));
        if (anchorStatement instanceof JSVarStatement && anchorStatement.getParent() instanceof JSStatement && !(anchorStatement.getParent() instanceof JSBlockStatement) || anchorStatement != null && anchorStatement.getParent() instanceof JSLabeledStatement) {
            anchorStatement = (JSStatement)anchorStatement.getParent();
        }
        return (T)anchorStatement;
    }

    private static JSSourceElement getAnchorToInsert(JSExpression[] expressions) {
        JSSourceElement statement;
        JSExpression place = expressions[0];
        block0: while (true) {
            PsiElement statementAnchor;
            statement = (statementAnchor = JSUtils.findStatementAnchor((PsiElement)place, place.getContainingFile(), true)) instanceof JSSourceElement && !(statementAnchor instanceof JSExpression) ? (JSSourceElement)statementAnchor : JSUtils.findSourceAnchor(statementAnchor, DialectDetector.isActionScript((PsiElement)place));
            LOG.assertTrue(statement != null);
            PsiElement parent = statement.getParent();
            for (JSExpression expression : expressions) {
                if (PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)expression, (boolean)true)) continue;
                place = statement;
                continue block0;
            }
            break;
        }
        return statement;
    }

    public static JSElement findClassAnchor(PsiElement expression) {
        PsiElement classRef;
        PsiElement nextParent;
        PsiElement nearestParent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{JSVarStatement.class, JSFunction.class});
        while (nearestParent != null && (nextParent = PsiTreeUtil.getParentOfType((PsiElement)nearestParent, (Class[])new Class[]{JSVarStatement.class, JSFunction.class})) != null) {
            nearestParent = nextParent;
        }
        if (!(nearestParent == null || nearestParent instanceof JSFunctionExpression && ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)nearestParent))) {
            return (JSElement)nearestParent;
        }
        JSElement parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{JSFile.class, JSClass.class});
        if (parent instanceof JSFile && (classRef = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)parent)) instanceof JSClass) {
            parent = (JSElement)classRef;
        }
        return parent;
    }

    protected static JSVariable addToClassAnchor(JSElement anchorStatement, JSVarStatement declaration) throws IncorrectOperationException {
        JSVarStatement varStatement;
        if (!(anchorStatement instanceof JSClass)) {
            JSElement element = JSBaseIntroduceHandler.findClassAnchor((PsiElement)anchorStatement);
            varStatement = (JSVarStatement)element.addBefore((PsiElement)declaration, (PsiElement)anchorStatement);
        } else {
            varStatement = (JSVarStatement)anchorStatement.add((PsiElement)declaration);
        }
        return varStatement.getVariables()[0];
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler", "invoke"));
        }
        throw new RuntimeException("Not implemented");
    }

    public static class Replacer {
        public final Pair<JSExpression, TextRange> myExpressionDescriptor;
        private final String myExpressionText;
        private final TextRange myExpressionRange;

        public Replacer(Pair<JSExpression, TextRange> expressionDescriptor) {
            this.myExpressionDescriptor = expressionDescriptor;
            JSExpression expression = (JSExpression)expressionDescriptor.first;
            TextRange range = (TextRange)expressionDescriptor.second;
            if (range == null) {
                range = expression.getTextRange();
            }
            if (expression instanceof JSXmlLiteralExpressionImpl && (expression.getParent() instanceof JSXmlLiteralExpressionImpl || JSBaseIntroduceHandler.isIntroducingPartOfExpression(this.myExpressionDescriptor))) {
                expression = Replacer.findTopXmlLiteralExpression(expression);
            }
            this.myExpressionText = expression.getText();
            int offset = expression.getTextRange().getStartOffset();
            this.myExpressionRange = new TextRange(range.getStartOffset() - offset, range.getEndOffset() - offset);
        }

        private static JSExpression findTopXmlLiteralExpression(JSExpression expression) {
            PsiElement myParent;
            while ((myParent = expression.getParent()) instanceof JSXmlLiteralExpressionImpl) {
                expression = (JSExpression)myParent;
            }
            return expression;
        }

        @Nullable
        public JSExpression replaceExpr(@NotNull JSExpression toReplace, @NotNull JSExpression replacement) {
            if (toReplace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toReplace", "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler$Replacer", "replaceExpr"));
            }
            if (replacement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/intellij/lang/javascript/refactoring/introduce/JSBaseIntroduceHandler$Replacer", "replaceExpr"));
            }
            PsiElement toReplaceParent = toReplace.getParent();
            if (toReplace instanceof JSXmlLiteralExpressionImpl && (toReplaceParent instanceof JSXmlLiteralExpressionImpl || JSBaseIntroduceHandler.isIntroducingPartOfExpression(this.myExpressionDescriptor))) {
                replacement = this.buildTextForReplacement(replacement, "{", "}");
                toReplace = Replacer.findTopXmlLiteralExpression(toReplace);
            } else if (JSBaseIntroduceHandler.isIntroducingPartOfExpression(this.myExpressionDescriptor)) {
                if (this.myExpressionDescriptor.first instanceof JSLiteralExpression) {
                    String quote = this.myExpressionText.substring(0, 1);
                    replacement = this.buildTextForReplacement(replacement, quote + " + ", " + " + quote);
                } else if (this.myExpressionDescriptor.first instanceof JSBinaryExpression || this.myExpressionDescriptor.first instanceof JSConditionalExpression) {
                    replacement = this.buildTextForReplacement(replacement, "", "");
                }
            }
            if (JSBaseIntroduceHandler.introduceOverVariableNameRef((PsiElement)toReplace)) {
                toReplaceParent.delete();
                return null;
            }
            JSExpression replaced = toReplace.replace(replacement);
            JSExpression newExpr = (JSExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)replaced.getContainingFile(), (int)(replaced.getTextRange().getStartOffset() + this.myExpressionRange.getStartOffset()), JSExpression.class, (boolean)false);
            return newExpr;
        }

        private JSExpression buildTextForReplacement(JSExpression refExpr, String quote, String quote2) {
            String text = "";
            if (this.myExpressionRange.getStartOffset() > 1) {
                text = text + this.myExpressionText.substring(0, this.myExpressionRange.getStartOffset()) + quote;
            }
            text = text + refExpr.getText();
            if (this.myExpressionRange.getEndOffset() < this.myExpressionText.length() - 1) {
                text = text + quote2 + this.myExpressionText.substring(this.myExpressionRange.getEndOffset());
            }
            refExpr = (JSExpression)JSChangeUtil.createExpressionFromText(refExpr.getProject(), text).getPsi();
            return refExpr;
        }

        public String getIntroducedExpressionText() {
            String text = this.myExpressionText;
            text = this.myExpressionRange.substring(text);
            PsiElement expression = (PsiElement)this.myExpressionDescriptor.first;
            if (expression instanceof JSXmlLiteralExpressionImpl) {
                text = "<>" + text + "</>";
            } else if (expression instanceof JSLiteralExpression && JSTokenTypes.STRING_LITERALS.contains(expression.getNode().getFirstChildNode().getElementType()) && !this.myExpressionRange.equals((Object)new TextRange(0, expression.getTextLength()))) {
                String quote = this.myExpressionText.substring(0, 1);
                text = quote + text + quote;
            }
            return text;
        }
    }

    public static class IntroduceInfo {
        final JSVariable createdVariable;
        final JSExpression expression;

        public IntroduceInfo(JSVariable variable, JSExpression expression) {
            this.createdVariable = variable;
            this.expression = expression;
        }
    }

    public static final class BaseIntroduceContext<S extends BaseIntroduceSettings> {
        public final S settings;
        final JSExpression[] occurences;
        final PsiElement scope;
        public final Pair<JSExpression, TextRange> expressionDescriptor;

        public BaseIntroduceContext(Pair<JSExpression, TextRange> _mainoccurence, JSExpression[] _occurences, PsiElement _scope, S _settings) {
            this.occurences = _occurences;
            this.expressionDescriptor = _mainoccurence;
            this.settings = _settings;
            this.scope = _scope;
        }
    }
}

