/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSVariableInplaceIntroducerBase;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class JSVariableInplaceIntroducer
extends JSVariableInplaceIntroducerBase {
    private JRadioButton myVarTypeSelector;
    private JRadioButton myConstTypeSelector;
    private JRadioButton myLetTypeSelector;
    private Settings.IntroducedVarType myVarType;

    public JSVariableInplaceIntroducer(Project project, Editor editor, JSExpression[] occurrences, JSBaseIntroduceHandler<? extends JSElement, Settings, ? extends JSBaseIntroduceDialog> handler, JSBaseIntroduceHandler.BaseIntroduceContext<Settings> context) {
        super(project, editor, occurrences, (FileType)JavaScriptFileType.INSTANCE, handler, context);
        this.myVarType = JSIntroduceVariableHandler.getLastIntroduceType(project);
    }

    protected JComponent getComponent() {
        boolean letEnabled;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(null);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.myVarTypeSelector = new JRadioButton("Variable");
        this.initTypeSelector(this.myVarTypeSelector, 'v', Settings.IntroducedVarType.VAR);
        panel.add(this.myVarTypeSelector);
        buttonGroup.add(this.myVarTypeSelector);
        this.myConstTypeSelector = new JRadioButton("Constant");
        this.initTypeSelector(this.myConstTypeSelector, 'c', Settings.IntroducedVarType.CONST);
        panel.add(this.myConstTypeSelector);
        buttonGroup.add(this.myConstTypeSelector);
        DialectOptionHolder holder = DialectDetector.dialectOfElement(this.myScope);
        boolean bl = letEnabled = holder != null && holder.hasFeature(JSLanguageFeature.LET_DEFINITIONS);
        if (letEnabled) {
            this.myLetTypeSelector = new JRadioButton("Local variable");
            this.initTypeSelector(this.myLetTypeSelector, 'l', Settings.IntroducedVarType.LET);
            panel.add(this.myLetTypeSelector);
            buttonGroup.add(this.myLetTypeSelector);
        }
        return panel;
    }

    private void initTypeSelector(JRadioButton selector, char mnemonic, final Settings.IntroducedVarType newVarType) {
        selector.setFocusable(false);
        selector.setMnemonic(mnemonic);
        Settings.IntroducedVarType lastSelected = JSIntroduceVariableHandler.getLastIntroduceType(this.myProject);
        selector.setSelected(lastSelected == newVarType);
        selector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSVariableInplaceIntroducer.this.myVarType = newVarType;
                JSIntroduceVariableHandler.setLastIntroduceType(JSVariableInplaceIntroducer.this.myProject, newVarType);
                JSVariableInplaceIntroducer.this.restartInplaceIntroduceTemplate();
            }
        });
    }

    public void selectVarType(@NotNull Settings.IntroducedVarType varType) {
        if (varType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varType", "com/intellij/lang/javascript/refactoring/introduceVariable/JSVariableInplaceIntroducer", "selectVarType"));
        }
        this.myVarType = varType;
        this.restartInplaceIntroduceTemplate();
    }

    @Override
    protected Settings getInplaceIntroduceSettings(final String name) {
        return new Settings(){

            @Override
            public Settings.IntroducedVarType getIntroducedVarType() {
                return JSVariableInplaceIntroducer.this.myVarType;
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return ((Settings)JSVariableInplaceIntroducer.this.myInitialSettings).isReplaceAllOccurrences();
            }

            @Override
            public String getVariableName() {
                return name;
            }

            @Override
            public String getVariableType() {
                return ((Settings)JSVariableInplaceIntroducer.this.myInitialSettings).getVariableType();
            }
        };
    }
}

