/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPushDown;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.memberPushDown.JSPushDownDialog;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JSPushDownHandler
extends BaseJSRefactoringHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"push.members.down.title");
    private static final String CANNOT_REFACTOR_REASON = RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from");

    public JSPushDownHandler() {
        super(REFACTORING_NAME, CANNOT_REFACTOR_REASON);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        Editor editor;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownHandler", "invoke"));
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = JSResolveUtil.unwrapProxy(elements[0]);
        if (!this.checkEcma(element, editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext))) {
            return;
        }
        JSClass aClass = JSPushDownHandler.getClass(element);
        if (aClass == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)CANNOT_REFACTOR_REASON);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
            return;
        }
        Collection<JSClass> subClasses = JSInheritanceUtil.findDirectSubClasses(aClass, false);
        if (subClasses.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JSBundle.message((String)"class.does.not.have.inheritors.in.current.project", (Object[])new Object[]{JSFormatUtil.formatClass(aClass, 2048)}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, null);
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)aClass, editor, REFACTORING_NAME)) {
            return;
        }
        ArrayList<JSMemberInfo> memberInfos = new ArrayList<JSMemberInfo>();
        JSMemberInfo.extractClassMembers(aClass, memberInfos, (MemberInfoBase.Filter<JSAttributeListOwner>)new MemberInfoBase.EmptyFilter());
        if (element instanceof JSElement) {
            for (JSMemberInfo memberInfo : memberInfos) {
                memberInfo.setChecked(Collections.singletonList((JSElement)element));
            }
        }
        JSPushDownDialog dialog = new JSPushDownDialog(project, memberInfos, aClass, subClasses);
        dialog.show();
    }
}

