/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.settings.JSRootConfigurationPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSRootConfigurable
implements SearchableConfigurable {
    private JSRootConfigurationPanel myMainPanel;
    private final JSRootConfiguration myRootConfiguration;

    public JSRootConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/settings/JSRootConfigurable", "<init>"));
        }
        this.myRootConfiguration = JSRootConfiguration.getInstance(project);
    }

    @Nls
    public String getDisplayName() {
        return JSBundle.message((String)"settings.javascript.root.configurable.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return this.getId();
    }

    public JComponent createComponent() {
        return this.getMainPanel();
    }

    public boolean isModified() {
        JSLanguageLevel storedLanguageLevel = this.myRootConfiguration.getStoredLanguageLevel();
        JSLanguageLevel panelLanguageLevel = this.myMainPanel.getLanguageLevel();
        return storedLanguageLevel == null && !panelLanguageLevel.equals((Object)JSLanguageLevel.DEFAULT) || storedLanguageLevel != null && !panelLanguageLevel.equals((Object)storedLanguageLevel) || this.myRootConfiguration.getPreferStrict() != this.myMainPanel.isPreferStrict() || this.myRootConfiguration.isOnlyTypeBasedCompletion() != this.myMainPanel.getOnlyTypeBasedCompletion();
    }

    public void apply() throws ConfigurationException {
        JSLanguageLevel newLanguageLevel = this.myMainPanel.getLanguageLevel();
        this.myRootConfiguration.storeLanguageLevelAndUpdateCaches(newLanguageLevel);
        this.myRootConfiguration.storePreferStrict(this.myMainPanel.isPreferStrict());
        this.myRootConfiguration.storeOnlyTypeBasedCompletion(this.myMainPanel.getOnlyTypeBasedCompletion());
    }

    public void reset() {
        JSLanguageLevel storedLanguageLevel = this.myRootConfiguration.getStoredLanguageLevel();
        if (storedLanguageLevel == null) {
            storedLanguageLevel = JSLanguageLevel.DEFAULT;
        }
        this.myMainPanel.setLanguageLevel(storedLanguageLevel);
        boolean preferStrict = this.myRootConfiguration.getPreferStrict();
        this.myMainPanel.setPreferStrict(preferStrict);
        boolean simplerCompletion = this.myRootConfiguration.isOnlyTypeBasedCompletion();
        this.myMainPanel.setOnlyTypeBasedCompletion(simplerCompletion);
    }

    public void disposeUIResources() {
        this.myMainPanel = null;
    }

    @NotNull
    public JPanel getMainPanel() {
        if (this.myMainPanel == null) {
            this.myMainPanel = new JSRootConfigurationPanel();
        }
        JPanel jPanel = this.myMainPanel.getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSRootConfigurable", "getMainPanel"));
        }
        return jPanel;
    }

    @NotNull
    public String getId() {
        if ("Settings.JavaScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSRootConfigurable", "getId"));
        }
        return "Settings.JavaScript";
    }

    public Runnable enableSearch(String option) {
        return null;
    }
}

