/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.watcher;

import com.intellij.ide.macro.FilePathRelativeToProjectRootMacro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceurCompilerTaskConsumer
extends BackgroundTaskConsumer {
    public boolean isAvailable(PsiFile file) {
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(file);
        return dialect == DialectOptionHolder.ECMA_6;
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName(JSBundle.message((String)"js.file.watcher.traceur.name", (Object[])new Object[0]));
        options.setDescription(JSBundle.message((String)"js.file.watcher.traceur.description", (Object[])new Object[0]));
        options.setFileExtension(JavaScriptSupportLoader.ECMA_SCRIPT_6.getFileExtension());
        options.setScopeName(PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        String relativeFilePathMacroName = new FilePathRelativeToProjectRootMacro().getName();
        options.setArguments("--source-maps file --out out/$" + relativeFilePathMacroName + "$ $" + relativeFilePathMacroName + "$");
        options.setWorkingDir("$" + new ProjectFileDirMacro().getName() + "$");
        options.setOutput("out/$" + relativeFilePathMacroName + "$:out/$" + relativeFilePathMacroName + "$.map");
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/watcher/TraceurCompilerTaskConsumer", "getOptionsTemplate"));
        }
        return taskOptions;
    }

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/watcher/TraceurCompilerTaskConsumer", "additionalConfiguration"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/watcher/TraceurCompilerTaskConsumer", "additionalConfiguration"));
        }
        super.additionalConfiguration(project, file, options);
        options.setProgram(TraceurCompilerTaskConsumer.findExecutableInPath((String)(SystemInfo.isWindows ? "traceur.cmd" : "traceur")));
    }
}

