/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompiledFilePropertyPusher;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerConfigUtil {
    public static final String SOURCE_MAP = "--sourceMap";
    public static final String COMPILED_FILES = "compiledFiles";
    private static final String FILENAME = "filename";
    private static final String MESSAGE = "message";
    private static final String LINE = "line";
    private static final String COLUMN = "column";
    private static final String CATEGORY = "category";

    @NotNull
    public static String getConfigDirectoryByCompilerId(@NotNull String compilerId) {
        if (compilerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerId", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigDirectoryByCompilerId"));
        }
        String string = compilerId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigDirectoryByCompilerId"));
        }
        return string;
    }

    @Nullable
    public static TypeScriptConfig getConfigByCompilerId(@Nullable Project project, @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigByCompilerId"));
        }
        for (TypeScriptConfig config : TypeScriptConfigService.Provider.getConfigFiles(project)) {
            if (!TypeScriptCompilerConfigUtil.getConfigIdByConfig(config).equals(id)) continue;
            return config;
        }
        return null;
    }

    @NotNull
    public static String getConfigIdByConfig(@NotNull TypeScriptConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigIdByConfig"));
        }
        String string = TypeScriptCompilerConfigUtil.getConfigIdByConfig(config.getConfigFile());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigIdByConfig"));
        }
        return string;
    }

    public static String getConfigIdByConfig(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigIdByConfig"));
        }
        return TypeScriptCompileInfoBuilder.toPath(file);
    }

    @Nullable
    public static String getConfigIdForFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigIdForFile"));
        }
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForFile(project, file);
        return config == null ? null : TypeScriptCompilerConfigUtil.getConfigIdByConfig(config);
    }

    public static boolean isConfig(VirtualFile file, FileType type) {
        return "tsconfig.json".equals(file.getName());
    }

    @Nullable
    public static TypeScriptConfig getConfigForFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "getConfigForFile"));
        }
        return TypeScriptConfigUtil.getConfigForFile(project, file);
    }

    @Nullable
    public static String normalizeNameAndPath(@NotNull VirtualFile name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "normalizeNameAndPath"));
        }
        String path = name.getCanonicalPath();
        if (!name.isInLocalFileSystem() || null == path) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path);
    }

    @NotNull
    public static JSLanguageServiceResultContainer build(@NotNull JsonElement parse) {
        JsonElement dataArray;
        if (parse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parse", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "build"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        JsonObject object = parse.getAsJsonObject();
        if (object.has("error")) {
            String errorText = object.get("error").getAsString();
            JSLanguageServiceResultContainer jSLanguageServiceResultContainer = new JSLanguageServiceResultContainer((List<JSLanguageServiceAnnotationResult>)JSLanguageServiceAnnotationResult.buildError(errorText), null);
            if (jSLanguageServiceResultContainer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "build"));
            }
            return jSLanguageServiceResultContainer;
        }
        JsonElement compiledFilesObject = object.get(COMPILED_FILES);
        ArrayList compiledFiles = null;
        if (compiledFilesObject != null && !compiledFilesObject.isJsonNull() && compiledFilesObject.isJsonArray()) {
            compiledFiles = ContainerUtil.newArrayList();
            for (JsonElement element : compiledFilesObject.getAsJsonArray()) {
                compiledFiles.add(element.getAsString());
            }
        }
        if ((dataArray = object.get("dataArray")) != null) {
            assert (dataArray.isJsonArray());
            for (JsonElement element : dataArray.getAsJsonArray()) {
                assert (element.isJsonObject());
                JsonObject errorRow = element.getAsJsonObject();
                JsonElement fileNameElement = errorRow.get(FILENAME);
                JsonElement errorMessageElement = errorRow.get(MESSAGE);
                JsonElement lineElement = errorRow.get(LINE);
                JsonElement columnElement = errorRow.get(COLUMN);
                JsonElement categoryElement = errorRow.get(CATEGORY);
                String errorText = errorMessageElement == null || errorMessageElement.isJsonNull() ? null : errorMessageElement.getAsString();
                String fileName = fileNameElement == null || fileNameElement.isJsonNull() ? null : fileNameElement.getAsString();
                String category = categoryElement == null || categoryElement.isJsonNull() ? null : categoryElement.getAsString();
                int line = lineElement == null || lineElement.isJsonNull() ? 0 : lineElement.getAsInt();
                int column = columnElement == null || columnElement.isJsonNull() ? 0 : columnElement.getAsInt();
                result.add(new JSLanguageServiceAnnotationResult(errorText, fileName, category, line, column, 0, 0));
            }
        }
        JSLanguageServiceResultContainer jSLanguageServiceResultContainer = new JSLanguageServiceResultContainer(result, compiledFiles);
        if (jSLanguageServiceResultContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "build"));
        }
        return jSLanguageServiceResultContainer;
    }

    public static void refreshFiles(@NotNull Project project, @NotNull Collection<String> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "refreshFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "refreshFiles"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "lambda$refreshFiles$1"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "lambda$refreshFiles$1"));
            }
            Collection result = (Collection)ReadAction.compute(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "lambda$null$0"));
                }
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "lambda$null$0"));
                }
                if (project.isDisposed()) {
                    return ContainerUtil.emptyList();
                }
                HashSet dirtyFiles = ContainerUtil.newHashSet();
                for (String file : files) {
                    String systemIndependentName = FileUtil.toSystemIndependentName((String)file);
                    VirtualFile path = LocalFileSystem.getInstance().findFileByPath(systemIndependentName);
                    if (path != null) {
                        dirtyFiles.add(path);
                        continue;
                    }
                    String parentDir = VfsUtil.getParentDir((String)systemIndependentName);
                    if (StringUtil.isEmpty((String)parentDir) || (path = LocalFileSystem.getInstance().findFileByPath(parentDir)) == null) continue;
                    dirtyFiles.add(path);
                }
                for (String file : dirtyFiles) {
                    Boolean data;
                    if (file.isDirectory() || (data = (Boolean)file.getUserData(JSLanguageService.GENERATED_FILE_MARKER)) == Boolean.TRUE) continue;
                    PushedFilePropertiesUpdater.getInstance((Project)project).findAndUpdateValue((VirtualFile)file, (FilePropertyPusher)new TypeScriptCompiledFilePropertyPusher(), (Object)true);
                }
                return dirtyFiles;
            });
            if (result.isEmpty()) {
                return;
            }
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)result));
        });
    }

    public static void processEmitFilesAfterCompiling(@NotNull Project project, @NotNull JsonObject objectWithFiles, @NotNull String fieldName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "processEmitFilesAfterCompiling"));
        }
        if (objectWithFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectWithFiles", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "processEmitFilesAfterCompiling"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/lang/typescript/compiler/TypeScriptCompilerConfigUtil", "processEmitFilesAfterCompiling"));
        }
        JsonElement emitFiles = objectWithFiles.get(fieldName);
        if (emitFiles != null) {
            assert (emitFiles.isJsonArray());
            List files = ContainerUtil.map((Collection)ContainerUtil.newArrayList((Iterable)emitFiles.getAsJsonArray()), JsonElement::getAsString);
            TypeScriptCompilerConfigUtil.refreshFiles(project, files);
        }
    }
}

