/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileCurrentAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TypeScriptToolWindowProvider {
    private final JSLanguageServiceToolWindowManager myToolWindow;

    @Nullable
    public static JSLanguageServiceToolWindowManager getToolWindow(Project project) {
        TypeScriptToolWindowProvider provider = (TypeScriptToolWindowProvider)ServiceManager.getService((Project)project, TypeScriptToolWindowProvider.class);
        return provider == null ? null : provider.getToolWindow();
    }

    public TypeScriptToolWindowProvider(final Project project) {
        AnAction restartCompilerAction = new AnAction(JSBundle.message((String)"typescript.service.action.restart", (Object[])new Object[0]), JSBundle.message((String)"typescript.service.action.restart", (Object[])new Object[0]), AllIcons.Javaee.UpdateRunningApplication){

            public void actionPerformed(AnActionEvent e) {
                TypeScriptCompilerService service = TypeScriptCompilerService.getService(project);
                if (service != null) {
                    service.restartService(false);
                }
            }
        };
        TypeScriptCompileCurrentAction typeScriptCompileCurrentAction = new TypeScriptCompileCurrentAction(){

            @Override
            protected VirtualFile[] getFiles(Project project, DataContext dataContext) {
                return FileEditorManager.getInstance((Project)project).getSelectedFiles();
            }

            @Override
            protected void logErrors(JSLanguageServiceToolWindowManager manager, Collection<JSLanguageServiceAnnotationResult> infos) {
                manager.logCurrentErrors((ImmutableList<JSLanguageServiceAnnotationResult>)ContainerUtil.immutableList((List)ContainerUtil.newArrayList(infos)), true);
            }
        };
        this.myToolWindow = new JSLanguageServiceToolWindowManager(project, "TypeScript", "reference.tool.windows.typescript", JavaScriptLanguageIcons.Typescript.TypeScript_Compiler, typeScriptCompileCurrentAction, new TypeScriptCompileAllAction(), restartCompilerAction);
        Disposer.register((Disposable)project, (Disposable)this.myToolWindow);
    }

    public JSLanguageServiceToolWindowManager getToolWindow() {
        return this.myToolWindow;
    }
}

