/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import icons.JavaScriptLanguageIcons;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileCurrentAction
extends TypeScriptCompileAllAction {
    public TypeScriptCompileCurrentAction() {
        super(JSBundle.message((String)"typescript.compiler.action.compile.current", (Object[])new Object[0]), JSBundle.message((String)"typescript.compiler.action.compile.current.description", (Object[])new Object[0]), JavaScriptLanguageIcons.Typescript.CompileCurrentFile1);
    }

    @Nullable
    private static VirtualFile getCurrentFile(DataContext dataContext) {
        if (dataContext == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            return psiFile != null ? psiFile.getVirtualFile() : null;
        }
        return null;
    }

    @Override
    protected boolean canSkipIterateAll() {
        return false;
    }

    @Override
    protected void iterateFilesForCompile(Project project, ProgressIndicator indicator, final Processor<VirtualFile> processor, @Nullable VirtualFile[] files) {
        if (project == null) {
            return;
        }
        if (files == null) {
            return;
        }
        for (VirtualFile file : files) {
            if (file.isDirectory()) {
                ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
                index.iterateContentUnderDirectory(file, new ContentIterator(){

                    public boolean processFile(VirtualFile descendant) {
                        if (!descendant.isDirectory() && TypeScriptCompilerSettings.acceptFileType(descendant.getFileType())) {
                            return processor.process((Object)descendant);
                        }
                        return true;
                    }
                });
                continue;
            }
            if (!processor.process((Object)file)) break;
        }
    }

    @Override
    @Nullable
    protected VirtualFile[] getFiles(Project project, DataContext dataContext) {
        VirtualFile file = TypeScriptCompileCurrentAction.getCurrentFile(dataContext);
        if (file != null) {
            return new VirtualFile[]{file};
        }
        return (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
    }
}

