/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class TypeScriptLanguageServiceEvents {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    @NotNull
    private final Project myProject;
    @NotNull
    private final TypeScriptCompilerService myService;

    public static TypeScriptLanguageServiceEvents getService(Project project) {
        return (TypeScriptLanguageServiceEvents)ServiceManager.getService((Project)project, TypeScriptLanguageServiceEvents.class);
    }

    public TypeScriptLanguageServiceEvents(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "<init>"));
        }
        this.myProject = project;
        this.myService = TypeScriptCompilerService.getService(project);
    }

    public void onOpenEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "onOpenEditor"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        TypeScriptOpenEditorCommand command = this.createOpenEditorCommand(file);
        this.myService.sendCommand(command, JSLanguageServiceCommandResultProcessor.SUCCESS);
    }

    @NotNull
    public TypeScriptOpenEditorCommand createOpenEditorCommand(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "createOpenEditorCommand"));
        }
        TypeScriptFileWithConfigArgs arguments = new TypeScriptFileWithConfigArgs();
        arguments.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        TypeScriptOpenEditorCommand typeScriptOpenEditorCommand = new TypeScriptOpenEditorCommand(arguments);
        if (typeScriptOpenEditorCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "createOpenEditorCommand"));
        }
        return typeScriptOpenEditorCommand;
    }

    public void onCloseEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "onCloseEditor"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        TypeScriptFileObject arguments = new TypeScriptFileObject();
        TypeScriptCloseEditorCommand command = new TypeScriptCloseEditorCommand(arguments);
        arguments.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        this.myService.sendCommand(command, JSLanguageServiceCommandResultProcessor.SUCCESS);
    }
}

