/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.refactoring;

import com.intellij.lang.typescript.compiler.refactoring.TypeScriptCompilerMoveFileUtils;
import com.intellij.lang.typescript.compiler.ui.projectView.TypeScriptNestingTreeStructureProvider;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;

public class TypeScriptCompilerFilesRenamer
extends AutomaticRenamer {
    public TypeScriptCompilerFilesRenamer(PsiFile psiFile, String newName) {
        this.addElementsRecursively(psiFile, newName);
    }

    private void addElementsRecursively(PsiFile psiFile, String newName) {
        String oldFileName = TypeScriptNestingTreeStructureProvider.getName(psiFile.getVirtualFile());
        if (oldFileName == null) {
            return;
        }
        String cleanNewName = TypeScriptNestingTreeStructureProvider.getName(newName);
        for (PsiFile generatedPsiFile : TypeScriptCompilerMoveFileUtils.getSiblings(psiFile)) {
            this.myElements.add(generatedPsiFile);
            String newGeneratedName = cleanNewName + generatedPsiFile.getName().substring(oldFileName.length());
            this.suggestAllNames(generatedPsiFile.getName(), newGeneratedName);
            this.addElementsRecursively(generatedPsiFile, newGeneratedName);
        }
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    public String getDialogTitle() {
        return "Rename Generated Files";
    }

    public String getDialogDescription() {
        return "Rename generated files with the following names to:";
    }

    public String entityName() {
        return "Generated file";
    }
}

