/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptCompilerVersionDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;

public class TypeScriptCompilerVersionPanel
extends JPanel {
    private final JBLabel myLabel;
    private final JButton myEditButtion;
    private final TypeScriptCompilerSettings mySettings;
    private String myServiceDirectory;
    private TypeScriptCompilerSettings.TypeScriptCompilerVersionType myVersionType;

    public TypeScriptCompilerSettings.TypeScriptCompilerVersionType getMyVersionType() {
        return this.myVersionType;
    }

    public TypeScriptCompilerVersionPanel(final Project project, TypeScriptCompilerSettings settings) {
        super(new FlowLayout(0));
        this.mySettings = settings;
        this.myLabel = new JBLabel("Text field");
        this.myEditButtion = new JButton("Edit...");
        this.add((Component)this.myLabel, "Center");
        this.add((Component)this.myEditButtion, "East");
        this.myEditButtion.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeScriptCompilerVersionDialog dialog = new TypeScriptCompilerVersionDialog(project, TypeScriptCompilerVersionPanel.this);
                if (dialog.showAndGet()) {
                    TypeScriptCompilerVersionPanel.this.myVersionType = dialog.getVersionType();
                    TypeScriptCompilerVersionPanel.this.myServiceDirectory = dialog.getServiceDirectory();
                    TypeScriptCompilerVersionPanel.this.myLabel.setText(TypeScriptCompilerVersionPanel.this.myVersionType.getTitle(TypeScriptCompilerVersionPanel.this.mySettings));
                }
            }
        });
    }

    public void resetValue() {
        this.myVersionType = this.mySettings.getVersionType();
        this.myLabel.setText(this.myVersionType.getTitle(this.mySettings));
        this.myServiceDirectory = this.mySettings.getTypeScriptServiceDirectory();
    }

    public void apply() {
        this.mySettings.setVersionType(this.myVersionType);
        this.mySettings.setTypeScriptServiceDirectory(this.myServiceDirectory);
    }

    public boolean isModified() {
        return this.myVersionType != this.mySettings.getVersionType() || !StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myServiceDirectory), (CharSequence)this.mySettings.getTypeScriptServiceDirectory());
    }

    public String getServiceDirectory() {
        return this.myServiceDirectory;
    }
}

