/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.ES6CompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;

public class TypeScriptCompletionKeywordsContributor
extends ES6CompletionKeywordsContributor {
    @Override
    public boolean process(KeywordCompletionConsumer consumer, PsiElement context) {
        JSFunction function;
        if (!super.process(consumer, context)) {
            return false;
        }
        PsiElement parent = context.getParent();
        if (parent instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)parent)) {
            if (PsiTreeUtil.getParentOfType((PsiElement)context, JSReferenceList.class) == null && ((JSReferenceExpression)parent).getQualifier() == null) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "string", "boolean", "number", "void", "any");
            }
            return false;
        }
        if (parent instanceof TypeScriptImportStatement) {
            return false;
        }
        if (parent instanceof JSParameter && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class)) != null && function.isConstructor()) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "private", "public", "protected");
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof JSExpressionStatement || grandParent instanceof JSAttributeList) {
            if (grandParent instanceof JSExpressionStatement) {
                PsiElement prev;
                PsiElement grandParentParent = grandParent.getParent();
                if (grandParentParent instanceof PsiFile || grandParentParent instanceof TypeScriptModule) {
                    consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, "class", "enum", "interface", "declare", "abstract", "async", "export", "type", "module", "namespace", "import");
                }
                if ((prev = JSPsiImplUtils.findPrevCodeElement(grandParent)) instanceof TypeScriptClass && prev.getNode().findChildByType(JSTokenTypes.LBRACE) == null || prev instanceof TypeScriptInterface && ((TypeScriptInterface)prev).getBody() == null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "extends");
                    if (prev instanceof TypeScriptClass) {
                        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "implements");
                    }
                    return false;
                }
            }
            consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, "public", "private", "protected", "function", "let", "const", "var");
            return !TypeScriptPsiUtil.isAmbientDeclaration(grandParent.getParent());
        }
        if (grandParent instanceof TypeScriptImportStatement && parent instanceof JSReferenceExpression) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "require");
            return false;
        }
        if (grandParent instanceof JSVarStatement && grandParent.getParent() instanceof TypeScriptClass) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, "constructor");
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "public", "private", "protected", "static", "abstract", "readonly", "async", "get", "set");
            return false;
        }
        if (parent instanceof JSReferenceExpression && grandParent instanceof ES6Property) {
            return false;
        }
        if (grandParent instanceof JSBinaryExpression || grandParent instanceof TypeScriptTypeParameterList) {
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, "extends");
        }
        return true;
    }

    @Override
    public void appendSpecificKeywords(KeywordCompletionConsumer consumer) {
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, "super", "require");
    }

    @Override
    protected void appendKeywordsAfterExport(KeywordCompletionConsumer consumer) {
        super.appendKeywordsAfterExport(consumer);
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, "namespace", "module", "enum", "type", "interface");
    }
}

