/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.formatter.JSCodeStylePanel;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TypeScriptCodeStylePanel
extends JSCodeStylePanel {
    public TypeScriptCodeStylePanel(CodeStyleSettings settings) {
        super(JavaScriptSupportLoader.TYPESCRIPT, settings);
        this.myNamingConventionsPane.setVisible(true);
        this.myUsePublicModifierJBCheckBox.setVisible(true);
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = TypeScriptFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/formatter/TypeScriptCodeStylePanel", "getFileType"));
        }
        return languageFileType;
    }

    @Override
    protected String getFileTypeExtension(FileType fileType) {
        return TypeScriptFileType.INSTANCE.getDefaultExtension();
    }

    @Override
    protected JSCodeStyleSettings getCustomJSSettings(CodeStyleSettings settings) {
        return (JSCodeStyleSettings)settings.getCustomSettings(TypeScriptCodeStyleSettings.class);
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(this.getFileType())).getEditorHighlighter(ProjectUtil.guessCurrentProject((JComponent)this.getPanel()), this.getFileType(), null, scheme);
    }
}

