/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.formatter.blocks;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.lang.typescript.formatter.TypeScriptSpacingProcessor;
import com.intellij.lang.typescript.formatter.blocks.TypeScriptSubBlockVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptBlock
extends JSBlock {
    public TypeScriptBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @NotNull CodeStyleSettings settings, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/formatter/blocks/TypeScriptBlock", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/formatter/blocks/TypeScriptBlock", "<init>"));
        }
        super(node, alignment, indent, wrap, settings, alignmentFactory, JavaScriptSupportLoader.TYPESCRIPT, (JSCodeStyleSettings)settings.getCustomSettings(TypeScriptCodeStyleSettings.class));
    }

    @Override
    protected SubBlockVisitor createSubBlockVisitor() {
        return new TypeScriptSubBlockVisitor(this, this.getSettings(), this.mySharedAlignmentFactory);
    }

    @Override
    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/intellij/lang/typescript/formatter/blocks/TypeScriptBlock", "getSpacing"));
        }
        if (!(child1 instanceof JSBlock) || !(child2 instanceof JSBlock)) {
            return null;
        }
        return new TypeScriptSpacingProcessor(this.getNode(), ((JSBlock)child1).getNode(), ((JSBlock)child2).getNode(), this.mySettings, this.myDialect).calcSpacing();
    }

    @Override
    protected boolean isChainedCallsFormattingSupported() {
        return true;
    }
}

