/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.fix;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringFactory;
import com.intellij.refactoring.RenameRefactoring;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import org.jetbrains.annotations.NotNull;

public class RenameFix
extends InspectionJSFix {
    private final String m_targetName;

    public RenameFix() {
        this.m_targetName = null;
    }

    public RenameFix(String targetName) {
        this.m_targetName = targetName;
    }

    @NotNull
    public String getName() {
        if (this.m_targetName == null) {
            String string = InspectionJSBundle.message("rename.fix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/fix/RenameFix", "getName"));
            }
            return string;
        }
        String string = InspectionJSBundle.message("rename.to.fix", this.m_targetName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/fix/RenameFix", "getName"));
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement nameIdentifier = descriptor.getPsiElement();
        PsiElement elementToRename = nameIdentifier.getParent();
        if (this.m_targetName == null) {
            RefactoringActionHandlerFactory factory = RefactoringActionHandlerFactory.getInstance();
            RefactoringActionHandler renameHandler = factory.createRenameHandler();
            renameHandler.invoke(project, new PsiElement[]{elementToRename}, DataManager.getInstance().getDataContext());
        } else {
            RefactoringFactory factory = RefactoringFactory.getInstance((Project)project);
            RenameRefactoring renameRefactoring = factory.createRename(elementToRename, this.m_targetName);
            renameRefactoring.run();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

