/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.coldFusion.model.CfmlLanguage;
import com.intellij.coldFusion.model.files.CfmlFileType;
import com.intellij.coldFusion.model.formatter.CfmlCodeStyleSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CfmlCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myMainPanel;
    private JPanel myPreviewPanel;
    private JCheckBox myAlignKeyValuePairsBox;
    private JCheckBox myAlignAssignments;

    protected CfmlCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CfmlCodeStylePanel.this.somethingChanged();
            }
        };
        this.myAlignKeyValuePairsBox.addItemListener(listener);
        this.myAlignAssignments.addItemListener(listener);
    }

    protected int getRightMargin() {
        return 80;
    }

    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)new LightVirtualFile("a.cfml"), scheme, null);
    }

    @NotNull
    protected FileType getFileType() {
        CfmlFileType cfmlFileType = CfmlFileType.INSTANCE;
        if (cfmlFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/formatter/CfmlCodeStylePanel", "getFileType"));
        }
        return cfmlFileType;
    }

    protected String getPreviewText() {
        return "<?cfml\n\nfunction foo($one, $two = 0, $three = \"String\")\n{\n    $f = \"The first value\";\n    $second = \"The second value\";\n    echo 'Hello, world!';\n    $t = \"The third value\";\n    $fourth = \"The fourth value\";\n    if (true) {\n        $x = array(\n            0 => \"zero\",\n            123 => \"one two three\",\n            25 => \"two five\"\n        );\n    }\n}\n\n?>";
    }

    public void apply(CodeStyleSettings settings) {
        CfmlCodeStyleSettings cfmlCodeStyleSettings = (CfmlCodeStyleSettings)settings.getCustomSettings(CfmlCodeStyleSettings.class);
        cfmlCodeStyleSettings.ALIGN_KEY_VALUE_PAIRS = this.myAlignKeyValuePairsBox.isSelected();
        cfmlCodeStyleSettings.ALIGN_ASSIGNMENTS = this.myAlignAssignments.isSelected();
    }

    public boolean isModified(CodeStyleSettings settings) {
        CfmlCodeStyleSettings cfmlCodeStyleSettings = (CfmlCodeStyleSettings)settings.getCustomSettings(CfmlCodeStyleSettings.class);
        return cfmlCodeStyleSettings.ALIGN_KEY_VALUE_PAIRS != this.myAlignKeyValuePairsBox.isSelected() || cfmlCodeStyleSettings.ALIGN_ASSIGNMENTS != this.myAlignAssignments.isSelected();
    }

    public JComponent getPanel() {
        return this.myMainPanel;
    }

    protected void resetImpl(CodeStyleSettings settings) {
        CfmlCodeStyleSettings cfmlCodeStyleSettings = (CfmlCodeStyleSettings)settings.getCustomSettings(CfmlCodeStyleSettings.class);
        this.myAlignKeyValuePairsBox.setSelected(cfmlCodeStyleSettings.ALIGN_KEY_VALUE_PAIRS);
        this.myAlignAssignments.setSelected(cfmlCodeStyleSettings.ALIGN_ASSIGNMENTS);
    }

    public Language getDefaultLanguage() {
        return CfmlLanguage.INSTANCE;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAlignKeyValuePairsBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Align key-value pairs");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAlignAssignments = jCheckBox = new JCheckBox();
        jCheckBox.setText("Align consecutive assignments");
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactoryBoldWithIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, new Dimension(-1, 150), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

