/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlComponent;
import com.intellij.coldFusion.model.psi.CfmlComponentReference;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlFunctionCall;
import com.intellij.coldFusion.model.psi.CfmlFunctionCallExpression;
import com.intellij.coldFusion.model.psi.CfmlResolveResult;
import com.intellij.coldFusion.model.psi.CfmlStringLiteralExpression;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlComponentConstructorCall
extends CfmlFunctionCallExpression
implements CfmlFunctionCall {
    public CfmlComponentConstructorCall(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/model/psi/CfmlComponentConstructorCall", "<init>"));
        }
        super(node);
    }

    @Override
    @Nullable
    public CfmlComponentReference getReferenceExpression() {
        ASTNode node;
        CfmlStringLiteralExpression childrenByClass;
        PsiElement childByType = this.findChildByType(CfmlElementTypes.COMPONENT_REFERENCE);
        if (childByType == null && (childrenByClass = (CfmlStringLiteralExpression)this.findChildByClass(CfmlStringLiteralExpression.class)) != null) {
            childByType = childrenByClass.getValueElement();
        }
        if (childByType != null && (node = childByType.getNode()) != null) {
            return new CfmlComponentReference(node, this){

                @Override
                @NotNull
                public ResolveResult[] multiResolve(boolean incompleteCode) {
                    ResolveResult[] resolveResults = super.multiResolve(incompleteCode);
                    LinkedList<CfmlFunction> result = new LinkedList<CfmlFunction>();
                    for (ResolveResult resolveResult : resolveResults) {
                        CfmlFunction[] functions;
                        PsiElement element = resolveResult.getElement();
                        if (!(element instanceof CfmlComponent)) continue;
                        CfmlComponent component = (CfmlComponent)element;
                        for (CfmlFunction function : functions = component.getFunctions()) {
                            if (!"init".equalsIgnoreCase(function.getName())) continue;
                            result.add(function);
                        }
                    }
                    ResolveResult[] resolveResultArray = CfmlResolveResult.create(result);
                    if (resolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlComponentConstructorCall$1", "multiResolve"));
                    }
                    return resolveResultArray;
                }
            };
        }
        return null;
    }

    @Override
    public PsiType getPsiType() {
        CfmlComponentReference referenceExpression = this.getReferenceExpression();
        return referenceExpression != null ? referenceExpression.getPsiType() : null;
    }
}

