/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8.value;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.chromium.sdk.internal.v8native.protocol.input.ValueHandle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.ValueBase;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.V8EvaluateContextValue;
import org.jetbrains.v8.protocol.LookupMessage;
import org.jetbrains.v8.protocol.Protocol_exKt;
import org.jetbrains.v8.value.V8ValueManager;

public class LoadableString
extends ValueBase
implements V8EvaluateContextValue,
StringValue {
    private static final PromiseManager<LoadableString, String> FULL_STRING_LOADER = new PromiseManager<LoadableString, String>(LoadableString.class){

        @NotNull
        public Promise<String> load(@NotNull LoadableString host) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/v8/value/LoadableString$1", "load"));
            }
            if (host.valueManager.getVm().getHasJbDebuggerSupport()) {
                Promise promise2 = host.valueManager.getVm().getCommandProcessor().send((Request)Protocol_exKt.GetObjects(host.id, -1, false)).then(result -> {
                    if (host == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/v8/value/LoadableString$1", "lambda$load$0"));
                    }
                    return host.value = result.objects().get(0).getDescription();
                });
                if (promise2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/v8/value/LoadableString$1", "load"));
                }
                return promise2;
            }
            int maxLength = -1;
            Promise promise3 = host.valueManager.getVm().getCommandProcessor().send((Request)new LookupMessage(new int[]{host.id}, false, maxLength)).then(map -> {
                if (host == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/v8/value/LoadableString$1", "lambda$load$1"));
                }
                ValueHandle valueHandle = (ValueHandle)map.get(host.id);
                if (valueHandle == null) {
                    throw new IllegalStateException("Failed to find value for ref=" + host.id);
                }
                host.valueManager.createValue(valueHandle);
                host.value = valueHandle.value();
                return host.value;
            });
            if (promise3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/v8/value/LoadableString$1", "load"));
            }
            return promise3;
        }
    };
    private final int id;
    private final V8ValueManager valueManager;
    private final int length;
    private volatile String value;
    private volatile Promise<String> fullValue;

    public LoadableString(@NotNull V8ValueManager valueManager, int id, @NotNull String value, int length) {
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "org/jetbrains/v8/value/LoadableString", "<init>"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/v8/value/LoadableString", "<init>"));
        }
        super(ValueType.STRING);
        this.valueManager = valueManager;
        this.id = id;
        this.value = value;
        this.length = length;
    }

    public String getValueString() {
        return this.value;
    }

    public boolean isTruncated() {
        return !FULL_STRING_LOADER.has((Object)this);
    }

    public int getLength() {
        return this.length;
    }

    @NotNull
    public Promise<String> getFullString() {
        Promise promise2 = FULL_STRING_LOADER.get((Object)this);
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/v8/value/LoadableString", "getFullString"));
        }
        return promise2;
    }

    @Override
    public void writeEvaluateContext(@NotNull JsonWriter writer) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/v8/value/LoadableString", "writeEvaluateContext"));
        }
        writer.name("handle").value((long)this.id);
    }
}

