/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.SuspendContextBase;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipExceptionData;
import org.jetbrains.wip.WipReaderService;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.WipWorker;
import org.jetbrains.wip.protocol.WipProtocolReader;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.GetBacktraceResult;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.debugger.PausedEventData;
import org.jetbrains.wip.protocol.debugger.ScopeValue;
import org.jetbrains.wip.protocol.debugger.StackTraceValue;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000s\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000*\u0001 \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ+\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00102\b\u00109\u001a\u0004\u0018\u00010:H\u0002\u00a2\u0006\u0002\u0010;J\n\u0010<\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u001e\u0010=\u001a\u00020>2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00102\b\u00109\u001a\u0004\u0018\u00010:R\u001c\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\r0\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010\u001f\u001a\u00020 8\u0002X\u0083\u0004\u00a2\u0006\n\n\u0002\u0010#\u0012\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0016\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010)\u001a\u0004\u0018\u00010\u00022\b\u0010(\u001a\u0004\u0018\u00010\u00028\u0016@RX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u0006?"}, d2={"Lorg/jetbrains/wip/WipSuspendContext;", "Lorg/jetbrains/debugger/SuspendContextBase;", "Lorg/jetbrains/wip/WipCallFrame;", "vm", "Lorg/jetbrains/wip/WipVm;", "workerId", "", "data", "Lorg/jetbrains/wip/protocol/debugger/PausedEventData;", "explicitPaused", "", "(Lorg/jetbrains/wip/WipVm;Ljava/lang/String;Lorg/jetbrains/wip/protocol/debugger/PausedEventData;Z)V", "_frames", "", "[Lorg/jetbrains/wip/WipCallFrame;", "breakpointsHit", "", "Lorg/jetbrains/debugger/Breakpoint;", "getBreakpointsHit", "()Ljava/util/List;", "exceptionData", "Lorg/jetbrains/debugger/ExceptionData;", "getExceptionData", "()Lorg/jetbrains/debugger/ExceptionData;", "setExceptionData", "(Lorg/jetbrains/debugger/ExceptionData;)V", "frames", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/CallFrame;", "getFrames", "()Lorg/jetbrains/concurrency/Promise;", "framesLoader", "org/jetbrains/wip/WipSuspendContext$framesLoader$1", "framesLoader$annotations", "()V", "Lorg/jetbrains/wip/WipSuspendContext$framesLoader$1;", "hasUnresolvedBreakpointsHit", "getHasUnresolvedBreakpointsHit", "()Z", "hitBreakpoints", "value", "topFrame", "getTopFrame", "()Lorg/jetbrains/wip/WipCallFrame;", "setTopFrame", "(Lorg/jetbrains/wip/WipCallFrame;)V", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "getValueManager", "()Lorg/jetbrains/wip/WipValueManager;", "getVm", "()Lorg/jetbrains/wip/WipVm;", "getWorkerId", "()Ljava/lang/String;", "createFrames", "frameDataList", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "asyncFrameDataList", "Lorg/jetbrains/wip/protocol/debugger/StackTraceValue;", "(Ljava/util/List;Lorg/jetbrains/wip/protocol/debugger/StackTraceValue;)[Lorg/jetbrains/wip/WipCallFrame;", "reloadFrames", "setFrames", "", "wip-backend"})
public final class WipSuspendContext
extends SuspendContextBase<WipCallFrame> {
    @NotNull
    private final WipValueManager valueManager;
    private final List<String> hitBreakpoints;
    @Nullable
    private volatile WipCallFrame topFrame;
    private volatile WipCallFrame[] _frames;
    @Nullable
    private ExceptionData exceptionData;
    private final framesLoader.1 framesLoader;
    @NotNull
    private final WipVm vm;
    @Nullable
    private final String workerId;

    @NotNull
    public WipValueManager getValueManager() {
        return this.valueManager;
    }

    @Nullable
    public WipCallFrame getTopFrame() {
        return this.topFrame;
    }

    private void setTopFrame(WipCallFrame value) {
        this.topFrame = value;
    }

    @Nullable
    public ExceptionData getExceptionData() {
        return this.exceptionData;
    }

    public void setExceptionData(@Nullable ExceptionData exceptionData) {
        this.exceptionData = exceptionData;
    }

    @NotNull
    public Promise<CallFrame[]> getFrames() {
        Promise promise2 = this.framesLoader.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"framesLoader.get()");
        return promise2;
    }

    private static final /* synthetic */ void framesLoader$annotations() {
    }

    public final void setFrames(@NotNull List<? extends CallFrameValue> frameDataList, @Nullable StackTraceValue asyncFrameDataList) {
        Intrinsics.checkParameterIsNotNull(frameDataList, (String)"frameDataList");
        WipCallFrame[] frames = this.createFrames(frameDataList, asyncFrameDataList);
        if (((Object[])frames).length > 0) {
            this.setTopFrame(frames[0]);
        }
        this._frames = frames;
        if (frames == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.jetbrains.debugger.CallFrame>");
        }
        this.framesLoader.set(frames);
    }

    /*
     * WARNING - void declaration
     */
    private final WipCallFrame[] createFrames(List<? extends CallFrameValue> frameDataList, StackTraceValue asyncFrameDataList) {
        void $receiver$iv;
        void size$iv;
        int n = frameDataList.size();
        WipCallFrame[] result$iv = new WipCallFrame[size$iv];
        boolean bl = false;
        void var7_9 = size$iv - true;
        if (bl <= var7_9) {
            void i$iv;
            do {
                void it;
                WipCallFrame wipCallFrame;
                void var8_14 = ++i$iv;
                void var16_12 = i$iv;
                WipCallFrame[] wipCallFrameArray = result$iv;
                wipCallFrameArray[var16_12] = wipCallFrame = new WipCallFrame(this.getValueManager(), frameDataList.get((int)it), null, false);
            } while (i$iv != var7_9);
        }
        WipCallFrame[] syncFrames = (WipCallFrame[])((Object[])result$iv);
        if (asyncFrameDataList == null) {
            return syncFrames;
        }
        List result = ArraysKt.toMutableList((Object[])syncFrames);
        for (StackTraceValue currentStackTrace = asyncFrameDataList; currentStackTrace != null; currentStackTrace = currentStackTrace.getAsyncStackTrace()) {
            void $receiver$iv2;
            String description = currentStackTrace.getDescription();
            Iterable iterable = currentStackTrace.callFrames();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv2) {
                void callFrameValue;
                int n2 = index$iv++;
                CallFrameValue callFrameValue2 = (CallFrameValue)item$iv;
                int i = n2;
                result.add(new WipCallFrame(this.getValueManager(), (CallFrameValue)callFrameValue, i == 0 ? description : (String)null, true));
            }
        }
        Collection description = result;
        void v1 = $receiver$iv;
        if (v1 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = (Collection)v1;
        WipCallFrame[] wipCallFrameArray = thisCollection$iv.toArray(new WipCallFrame[thisCollection$iv.size()]);
        if (wipCallFrameArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (WipCallFrame[])((Object[])wipCallFrameArray);
    }

    public boolean getHasUnresolvedBreakpointsHit() {
        if (UtilKt.isNullOrEmpty(this.hitBreakpoints)) {
            return false;
        }
        THashSet hitVmBreakpoints = new THashSet((Collection)this.hitBreakpoints);
        for (WipBreakpoint breakpoint : this.getValueManager().getVm().getBreakpointManager().getBreakpoints()) {
            hitVmBreakpoints.remove((Object)breakpoint.getVmId());
        }
        Collection collection = (Collection)hitVmBreakpoints;
        return !collection.isEmpty();
    }

    @NotNull
    public List<Breakpoint> getBreakpointsHit() {
        Set breakpoints = this.getValueManager().getVm().getBreakpointManager().getBreakpoints();
        if (this.hitBreakpoints != null) {
            SmartList result = new SmartList();
            for (WipBreakpoint breakpoint : breakpoints) {
                String vmId = breakpoint.getVmId();
                if (vmId == null || !this.hitBreakpoints.contains(vmId)) continue;
                result.add((Object)breakpoint);
            }
            return (List)result;
        }
        WipCallFrame wipCallFrame = this.getTopFrame();
        if (wipCallFrame == null) {
            return CollectionsKt.emptyList();
        }
        WipCallFrame topFrame = wipCallFrame;
        int line = topFrame.getLine();
        int column = topFrame.getColumn();
        List result = null;
        block1: for (WipBreakpoint breakpoint : breakpoints) {
            for (LocationValue actualLocation : breakpoint.getActualLocations()) {
                int actualColumnNumber = actualLocation.getColumnNumber();
                if (!Intrinsics.areEqual((Object)actualLocation.scriptId(), (Object)topFrame.getScriptId()) || actualLocation.getLineNumber() != line || actualColumnNumber != column && actualColumnNumber > 0) continue;
                if (result == null) {
                    result = (List)new SmartList();
                }
                WipBreakpoint wipBreakpoint = breakpoint;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)wipBreakpoint), (String)"breakpoint");
                result.add(wipBreakpoint);
                continue block1;
            }
        }
        List list = result;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Promise<?> reloadFrames() {
        this.framesLoader.markDirty();
        SmartList promises = new SmartList();
        if (this._frames == null) {
            Intrinsics.throwNpe();
        }
        WipCallFrame[] wipCallFrameArray = this._frames;
        for (int i = 0; i < wipCallFrameArray.length; ++i) {
            WipCallFrame frame = wipCallFrameArray[i];
            List<ScopeValue> list = frame.getScopesData();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (ScopeValue scopeValue : list) {
                WipCommandProcessor wipCommandProcessor = this.getValueManager().getCommandProcessor();
                String string = scopeValue.object().getObjectId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                promises.add((Object)wipCommandProcessor.send((Request)RuntimeKt.ReleaseObject(string)));
            }
        }
        promises.add((Object)this.framesLoader.get());
        Promise $receiver$iv = Promise.all((Collection)((Collection)promises));
        Promise promise2 = $receiver$iv;
        if (promise2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any?>");
        }
        Promise promise3 = promise2.then((Function)new Function<Object, Unit>(this){
            final /* synthetic */ WipSuspendContext this$0;

            public final Unit fun(Object it) {
                this.this$0.getValueManager().clearCaches();
                return Unit.INSTANCE;
            }
            {
                this.this$0 = wipSuspendContext;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"(this as Promise<Any?>).then { handler() }");
        return promise3;
    }

    @NotNull
    public WipVm getVm() {
        return this.vm;
    }

    @Nullable
    public String getWorkerId() {
        return this.workerId;
    }

    public WipSuspendContext(@NotNull WipVm vm, @Nullable String workerId, @NotNull PausedEventData data, boolean explicitPaused) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super(explicitPaused);
        this.vm = vm;
        this.workerId = workerId;
        this.valueManager = new WipValueManager(this.getVm(), null, this.getWorkerId() != null ? (WipWorker)this.getVm().getWorkerManager().getWorkers().get(this.getWorkerId()) : (WipWorker)null);
        this.framesLoader = new AsyncValueLoader<CallFrame[]>(this){
            final /* synthetic */ WipSuspendContext this$0;

            @NotNull
            protected Promise<CallFrame[]> load(@NotNull AsyncPromise<CallFrame[]> result) {
                Intrinsics.checkParameterIsNotNull(result, (String)"result");
                return this.this$0.getValueManager().getVm().getCommandProcessor().send((Request)DebuggerKt.GetBacktrace()).then((Function)new Function<GetBacktraceResult, CallFrame[]>(this){
                    final /* synthetic */ framesLoader.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final CallFrame[] fun(GetBacktraceResult it) {
                        List<CallFrameValue> framesInfo = it.callFrames();
                        WipCallFrame[] wipCallFrameArray = WipSuspendContext.access$get_frames$p(this.this$0.this$0);
                        if (wipCallFrameArray == null) {
                            Intrinsics.throwNpe();
                        }
                        WipCallFrame[] existingFrames = wipCallFrameArray;
                        CommandProcessorKt.getLOG().assertTrue(framesInfo.size() == ((Object[])existingFrames).length);
                        int n = 0;
                        int n2 = ((Collection)framesInfo).size() - 1;
                        if (n <= n2) {
                            while (true) {
                                void i;
                                existingFrames[i].reinit(framesInfo.get((int)i), this.this$0.this$0.getValueManager());
                                if (i == n2) break;
                                ++i;
                            }
                        }
                        if (existingFrames == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<org.jetbrains.debugger.CallFrame>");
                        }
                        return existingFrames;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = $outer;
            }
        };
        PausedEventData.Data additionalData = data.getData();
        if (data.reason() == PausedEventData.Reason.EXCEPTION && additionalData != null) {
            WipValueManager wipValueManager = this.getValueManager();
            WipProtocolReader wipProtocolReader = WipReaderService.get();
            JsonReaderEx jsonReaderEx = additionalData.getDeferredReader();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonReaderEx, (String)"additionalData.deferredReader");
            this.setExceptionData(new WipExceptionData(wipValueManager.createValue(wipProtocolReader.parseRemoteObjectValue(jsonReaderEx))));
        } else {
            this.setExceptionData(null);
        }
        List<CallFrameValue> callFrames = data.callFrames();
        StackTraceValue asyncStackTrace = this.getVm().getCaptureAsyncStackTraces() ? data.getAsyncStackTrace() : (StackTraceValue)null;
        this.setFrames(callFrames, asyncStackTrace);
        this.hitBreakpoints = data.getHitBreakpoints();
    }

    @Nullable
    public static final /* synthetic */ WipCallFrame[] access$get_frames$p(WipSuspendContext $this) {
        return $this._frames;
    }

    public static final /* synthetic */ void access$set_frames$p(WipSuspendContext $this, @Nullable WipCallFrame[] wipCallFrameArray) {
        $this._frames = wipCallFrameArray;
    }
}

