/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.plugins.drools.lang.lexer.DroolsTokenTypeSets;
import com.intellij.plugins.drools.lang.lexer.DroolsTokenTypes;
import com.intellij.plugins.drools.lang.psi.DroolsAttribute;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsLhs;
import com.intellij.plugins.drools.lang.psi.DroolsRhs;
import com.intellij.plugins.drools.lang.psi.DroolsRuleStatement;
import com.intellij.plugins.drools.lang.psi.DroolsStringLiteral;
import com.intellij.plugins.drools.lang.psi.util.DroolsResolveUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import icons.DroolsIcons;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DroolsCompletionContributor
extends CompletionContributor {
    private static final Set<String> allowedKeywords = new THashSet<String>(){
        {
            for (IElementType elementType : DroolsTokenTypeSets.KEYWORD_ATTRS.getTypes()) {
                this.add(elementType.toString());
            }
            for (IElementType elementType : DroolsTokenTypeSets.KEYWORDS.getTypes()) {
                this.add(elementType.toString());
            }
        }
    };

    public DroolsCompletionContributor() {
        this.extendRhsStatement();
        this.extendPatternBindExpressions();
        this.extendKeywords();
        this.extendAttributes();
        this.extendDialectAttribute();
        this.extendRule();
    }

    private void extendRule() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("DroolsRule"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$2", "accepts"));
                }
                DroolsRuleStatement droolsRule = (DroolsRuleStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, DroolsRuleStatement.class);
                return droolsRule != null;
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$3", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$3", "addCompletions"));
                }
                PsiElement position = parameters.getPosition();
                DroolsRuleStatement droolsRule = (DroolsRuleStatement)PsiTreeUtil.getParentOfType((PsiElement)position, DroolsRuleStatement.class);
                if (droolsRule != null) {
                    List<DroolsRhs> rhs;
                    if (droolsRule.getLhs() == null && ((rhs = droolsRule.getRhsList()).size() == 0 || rhs.size() == 1 && rhs.iterator().next().getTextRange().getStartOffset() > position.getTextRange().getStartOffset())) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)"when").bold());
                    }
                    result.addElement((LookupElement)LookupElementBuilder.create((String)"then  end").withPresentableText("then").bold().withTailText(" end").withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                        public void handleInsert(InsertionContext context, LookupElement item) {
                            Editor editor = context.getEditor();
                            editor.getCaretModel().moveToOffset(context.getTailOffset() - 4);
                        }
                    }));
                }
            }
        });
    }

    private void extendKeywords() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("DroolsAttributes"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$4", "accepts"));
                }
                PsiElement parent = psiElement.getParent();
                if (parent instanceof DroolsFile || parent instanceof PsiErrorElement && parent.getParent() instanceof DroolsFile) {
                    return true;
                }
                return parent instanceof DroolsRuleStatement || parent instanceof PsiErrorElement && parent.getParent() instanceof DroolsRuleStatement;
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$5", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$5", "addCompletions"));
                }
                for (String keyword : Arrays.asList("package ", "import ", "rule ", "function ", "declare ", "global ")) {
                    result.addElement(LookupElementBuilder.create((String)keyword).bold().withAutoCompletionPolicy(AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE));
                }
            }
        });
    }

    private void extendDialectAttribute() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("DroolsAttributes"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$6", "accepts"));
                }
                if (psiElement.getParent() instanceof DroolsStringLiteral) {
                    DroolsAttribute attribute = (DroolsAttribute)PsiTreeUtil.getParentOfType((PsiElement)psiElement, DroolsAttribute.class);
                    return attribute != null && "dialect".equals(attribute.getAttributeName());
                }
                return false;
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$7", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$7", "addCompletions"));
                }
                result.addElement((LookupElement)LookupElementBuilder.create((String)"mvel").bold());
                result.addElement((LookupElement)LookupElementBuilder.create((String)"java").bold());
            }
        });
    }

    private void extendAttributes() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("DroolsAttributes"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$8", "accepts"));
                }
                PsiElement parent = psiElement.getParent();
                if (parent instanceof DroolsFile || parent instanceof PsiErrorElement && parent.getParent() instanceof DroolsFile) {
                    return true;
                }
                return parent instanceof DroolsRuleStatement || parent instanceof PsiErrorElement && parent.getParent() instanceof DroolsRuleStatement;
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$9", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$9", "addCompletions"));
                }
                List<String> stringAttrs = Arrays.asList("agenda-group", "activation-group", "ruleflow-group", "date-effective", "date-expires", "dialect");
                for (IElementType elementType : DroolsTokenTypeSets.KEYWORD_ATTRS.getTypes()) {
                    String keyword = elementType.toString();
                    if (stringAttrs.contains(keyword)) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)(keyword + " \"\"")).bold().withPresentableText(keyword).withTailText(" \"\"", true).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                            public void handleInsert(InsertionContext context, LookupElement item) {
                                Editor editor = context.getEditor();
                                editor.getCaretModel().moveToOffset(context.getTailOffset() - 1);
                            }
                        }));
                        continue;
                    }
                    result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold());
                }
            }
        });
    }

    private void extendPatternBindExpressions() {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("DroolsPatternBind"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$10", "accepts"));
                }
                PsiElement prevSibling = DroolsResolveUtil.getPrevSiblingSkipWhiteSpaces(psiElement, true);
                if (prevSibling != null) {
                    return prevSibling.getNode().getElementType() == DroolsTokenTypes.COLON;
                }
                PsiElement parent = psiElement.getParent();
                if (parent instanceof PsiErrorElement) {
                    return DroolsResolveUtil.getPrevSiblingSkipWhiteSpaces(parent, true) instanceof DroolsLhs;
                }
                return false;
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)with, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$11", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$11", "addCompletions"));
                }
                PsiFile file = parameters.getPosition().getContainingFile();
                if (file instanceof DroolsFile) {
                    for (PsiClass psiClass : DroolsResolveUtil.getExplicitlyImportedClasses((DroolsFile)file)) {
                        result.addElement((LookupElement)LookupElementBuilder.create((PsiNamedElement)psiClass).withIcon(psiClass.getIcon(0)).appendTailText("(expression)", true).withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS));
                    }
                }
            }
        });
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/plugins/drools/completion/DroolsCompletionContributor", "beforeCompletion"));
        }
        if (context.getCompletionType() == CompletionType.SMART) {
            return;
        }
        super.beforeCompletion(context);
        PsiFile file = context.getFile();
        if (file instanceof DroolsFile) {
            context.setDummyIdentifier("IntellijIdeaRulezzz");
        }
    }

    private void extendRhsStatement() {
        PsiElementPattern.Capture rhsKeywordPattern = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("rhsKeywords"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                PsiStatement type;
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$12", "accepts"));
                }
                PsiFile file = psiElement.getContainingFile();
                return file instanceof DroolsFile && (type = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiStatement.class)) != null && psiElement.getTextRange().getStartOffset() == type.getTextRange().getStartOffset();
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)rhsKeywordPattern, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$13", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/plugins/drools/completion/DroolsCompletionContributor$13", "addCompletions"));
                }
                for (String keyword : Arrays.asList("insert", "insertLogical", "retract", "update")) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold().withIcon(DroolsIcons.Drools_16).appendTailText("(expression)", true).withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS));
                }
                result.addElement((LookupElement)LookupElementBuilder.create((String)"modify").bold().withIcon(DroolsIcons.Drools_16).appendTailText("(expression){}", true).withInsertHandler((InsertHandler)new MyModifyStatementInsertHandler()));
            }
        });
    }

    private static class MyModifyStatementInsertHandler
    extends ParenthesesInsertHandler {
        private MyModifyStatementInsertHandler() {
        }

        protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
            return true;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            super.handleInsert(context, item);
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            document.insertString(context.getTailOffset(), (CharSequence)"{}");
        }
    }
}

