/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.util.processors;

import com.intellij.openapi.project.Project;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsImport;
import com.intellij.plugins.drools.lang.psi.util.DroolsLightClass;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsDeclarationsProcessor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class DroolsImportedClassesProcessor
implements DroolsDeclarationsProcessor {
    private static DroolsImportedClassesProcessor myInstance;

    private DroolsImportedClassesProcessor() {
    }

    public static DroolsImportedClassesProcessor getInstance() {
        if (myInstance == null) {
            myInstance = new DroolsImportedClassesProcessor();
        }
        return myInstance;
    }

    @Override
    public boolean processElement(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, @NotNull DroolsFile droolsFile) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImportedClassesProcessor", "processElement"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImportedClassesProcessor", "processElement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImportedClassesProcessor", "processElement"));
        }
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImportedClassesProcessor", "processElement"));
        }
        return DroolsImportedClassesProcessor.processImportedClasses(processor, state, droolsFile.getImports(), place.getProject());
    }

    private static boolean processImportedClasses(PsiScopeProcessor processor, ResolveState state, DroolsImport[] imports, Project project) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (DroolsImport droolsImport : imports) {
            PsiClass psiClass;
            String className = droolsImport.getImportedClassName();
            if (className == null || (psiClass = facade.findClass(className, GlobalSearchScope.allScope((Project)project))) == null || processor.execute((PsiElement)new DroolsLightClass(psiClass), state)) continue;
            return false;
        }
        return true;
    }
}

