/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.module.view.JavaeeAbstractAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import javax.swing.text.JTextComponent;

public class JavaeeViewDeleteAction
extends AnAction {
    private final DataProvider myDataProvider;

    public JavaeeViewDeleteAction(DataProvider dataProvider) {
        super(J2EEBundle.message("action.name.remove", new Object[0]), null, AllIcons.General.Remove);
        this.myDataProvider = dataProvider;
    }

    public void update(AnActionEvent event) {
        boolean active;
        DataProvider dataProvider = this.getDataProvider(event);
        Project project = (Project)dataProvider.getData(DataConstants.PROJECT);
        if (project == null) {
            active = false;
        } else {
            Object component = event.getDataContext().getData(DataConstants.CONTEXT_COMPONENT);
            DeleteProvider provider = (DeleteProvider)dataProvider.getData(DataConstants.DELETE_ELEMENT_PROVIDER);
            active = !(component instanceof JTextComponent) && provider != null && provider.canDeleteElement(event.getDataContext());
        }
        JavaeeAbstractAction.setActive(event, active);
    }

    private DataProvider getDataProvider(AnActionEvent event) {
        if (this.myDataProvider != null) {
            return this.myDataProvider;
        }
        final DataContext dataContext = event.getDataContext();
        return new DataProvider(){

            public Object getData(String dataId) {
                return dataContext.getData(dataId);
            }
        };
    }

    public void actionPerformed(AnActionEvent e) {
        DataProvider dataProvider = this.getDataProvider(e);
        DeleteProvider provider = (DeleteProvider)dataProvider.getData(DataConstants.DELETE_ELEMENT_PROVIDER);
        if (provider == null) {
            return;
        }
        provider.deleteElement(e.getDataContext());
    }
}

