/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.graph;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class LazyDependenciesGraph<N, E>
implements Graph<N> {
    private final Map<N, Collection<Pair<N, E>>> myIns = ContainerUtil.newConcurrentMap();
    private final Map<N, Collection<Pair<N, E>>> myOuts = ContainerUtil.newConcurrentMap();
    private volatile boolean myIsBuilt = false;
    private final Function<Pair<N, E>, N> mySourceNodeFunction = pair -> pair.getFirst();

    @NotNull
    protected abstract Collection<Pair<N, E>> getDependencies(@NotNull N var1);

    public Iterator<N> getIn(N n) {
        this.guaranteeGraphIsBuilt();
        return this.getIterator(this.myIns.get(n));
    }

    public Iterator<N> getOut(N n) {
        return this.getIterator(this.getOrCreateOutDependencies(n));
    }

    @NotNull
    private Iterator<N> getIterator(Collection<Pair<N, E>> dependencies) {
        Iterator iterator = ContainerUtil.map(dependencies, this.mySourceNodeFunction).iterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/graph/LazyDependenciesGraph", "getIterator"));
        }
        return iterator;
    }

    protected final void guaranteeGraphIsBuilt() {
        if (!this.myIsBuilt) {
            Collection nodes = this.getNodes();
            for (Object node : nodes) {
                this.getOrCreateOutDependencies(node);
            }
            this.myIsBuilt = true;
        }
    }

    @NotNull
    public final Collection<Pair<N, E>> getOrCreateOutDependencies(@NotNull N n) {
        if (n == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "com/intellij/spring/contexts/model/graph/LazyDependenciesGraph", "getOrCreateOutDependencies"));
        }
        Collection<Pair<N, E>> outSet = this.myOuts.get(n);
        if (outSet == null) {
            outSet = this.getDependencies(n);
            for (Pair<N, E> dependency : outSet) {
                this.addInDependency(n, dependency.first, dependency.second);
            }
            this.myOuts.put(n, outSet);
        }
        Collection<Pair<N, E>> collection = this.myOuts.get(n);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/graph/LazyDependenciesGraph", "getOrCreateOutDependencies"));
        }
        return collection;
    }

    public void addInDependency(@NotNull N from, @NotNull N to, @NotNull E edgeDescriptor) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/spring/contexts/model/graph/LazyDependenciesGraph", "addInDependency"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/spring/contexts/model/graph/LazyDependenciesGraph", "addInDependency"));
        }
        if (edgeDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edgeDescriptor", "com/intellij/spring/contexts/model/graph/LazyDependenciesGraph", "addInDependency"));
        }
        Collection<Pair<N, Pair>> inNodes = this.myIns.get(to);
        if (inNodes == null) {
            inNodes = new LinkedHashSet<Pair<N, E>>();
        }
        inNodes.add(Pair.create(from, edgeDescriptor));
        this.myIns.put(to, inNodes);
    }
}

