/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.scope.processor.MethodResolveProcessor;
import com.intellij.spring.model.converters.PsiMethodConverter;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBeanMethodConverter
extends PsiMethodConverter {
    @Override
    protected PsiMethodConverter.MethodAccepter getMethodAccepter(final ConvertContext context, final boolean forCompletion) {
        return new PsiMethodConverter.MethodAccepter(){

            @Override
            public boolean accept(PsiMethod method) {
                if (method.isConstructor()) {
                    return false;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return false;
                }
                String containing = containingClass.getQualifiedName();
                if ("java.lang.Object".equals(containing)) {
                    return false;
                }
                return SpringBeanMethodConverter.this.checkParameterList(method) && SpringBeanMethodConverter.this.checkModifiers(method) && SpringBeanMethodConverter.this.checkReturnType(context, method, forCompletion);
            }
        };
    }

    protected boolean checkModifiers(PsiMethod method) {
        return method.hasModifierProperty("public") && !method.hasModifierProperty("abstract");
    }

    protected boolean checkParameterList(PsiMethod method) {
        return method.getParameterList().getParametersCount() == 0;
    }

    protected boolean checkReturnType(ConvertContext context, PsiMethod method, boolean forCompletion) {
        return true;
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        String elementName = element.getStringValue();
        PsiClass beanClass = this.getPsiClass(context);
        if (elementName != null && elementName.length() > 0 && beanClass != null) {
            LocalQuickFix[] localQuickFixArray;
            LocalQuickFix fix = SpringBeanMethodConverter.createNewMethodQuickFix(beanClass, elementName, context);
            if (fix == null) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = fix;
            }
            return localQuickFixArray;
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @Nullable
    private static LocalQuickFix createNewMethodQuickFix(@NotNull PsiClass beanClass, String elementName, ConvertContext context) {
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/spring/model/converters/SpringBeanMethodConverter", "createNewMethodQuickFix"));
        }
        return CreateMethodQuickFix.createFix((PsiClass)beanClass, (String)SpringBeanMethodConverter.getNewMethodSignature(elementName, context), (String)(beanClass.isInterface() ? "" : SpringBeanMethodConverter.getNewMethodBody(elementName, context)));
    }

    @NonNls
    protected static String getNewMethodSignature(String elementName, ConvertContext context) {
        return "public void " + elementName + "()";
    }

    @NonNls
    protected static String getNewMethodBody(String elementName, ConvertContext context) {
        return "";
    }

    @Override
    protected String getMethodIdentificator(PsiMethod method) {
        return method.getName();
    }

    @Override
    protected PsiMethod[] getMethodCandidates(String methodIdentificator, PsiClass psiClass) {
        return MethodResolveProcessor.findMethod((PsiClass)psiClass, (String)methodIdentificator);
    }
}

