/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.spring.model.jam.utils.filters.SpringContextIncludeAnnotationFilter;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class IncludeAnnotationsFilter
extends SpringContextFilter.IncludeClasses {
    public IncludeAnnotationsFilter(@NotNull Collection<PsiClass> classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/spring/model/jam/utils/filters/IncludeAnnotationsFilter", "<init>"));
        }
        super(classes);
    }

    @Override
    @NotNull
    public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/filters/IncludeAnnotationsFilter", "includeStereotypes"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/model/jam/utils/filters/IncludeAnnotationsFilter", "includeStereotypes"));
        }
        HashSet includes = new HashSet();
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        for (PsiClass psiClass : this.getClasses()) {
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName == null) continue;
            includes.addAll(SpringContextIncludeAnnotationFilter.getAnnotatedStereotypes(psiClass, searchScope, packages));
        }
        HashSet hashSet = includes;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/IncludeAnnotationsFilter", "includeStereotypes"));
        }
        return hashSet;
    }
}

