/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextIncludeAnnotationFilter
extends SpringContextFilter.IncludeExpression {
    public SpringContextIncludeAnnotationFilter(@Nullable String expression) {
        super(expression);
    }

    @Override
    @NotNull
    public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter", "includeStereotypes"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter", "includeStereotypes"));
        }
        String annotation = this.getExpression();
        if (!StringUtil.isEmptyOrSpaces((String)annotation)) {
            GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            PsiClass annotationClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(annotation, searchScope);
            Set<SpringStereotypeElement> set = SpringContextIncludeAnnotationFilter.getAnnotatedStereotypes(annotationClass, searchScope, packages);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter", "includeStereotypes"));
            }
            return set;
        }
        Set<SpringStereotypeElement> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter", "includeStereotypes"));
        }
        return set;
    }

    @NotNull
    public static Set<SpringStereotypeElement> getAnnotatedStereotypes(@Nullable PsiClass annotationClass, @NotNull GlobalSearchScope searchScope, @NotNull Set<PsiPackage> packages) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter", "getAnnotatedStereotypes"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter", "getAnnotatedStereotypes"));
        }
        HashSet components = new HashSet();
        if (annotationClass != null) {
            Set<PsiClass> annotatedClasses = SpringContextIncludeAnnotationFilter.getAnnotatedClasses(annotationClass, packages, searchScope);
            for (PsiClass annotatedClass : annotatedClasses) {
                components.add(new CustomSpringComponent(annotationClass.getQualifiedName(), annotatedClass));
            }
        }
        HashSet hashSet = components;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter", "getAnnotatedStereotypes"));
        }
        return hashSet;
    }

    public static Set<PsiClass> getAnnotatedClasses(@NotNull PsiClass annotationClass, @NotNull Set<PsiPackage> packages, @NotNull GlobalSearchScope searchScope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter", "getAnnotatedClasses"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter", "getAnnotatedClasses"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter", "getAnnotatedClasses"));
        }
        HashSet annotatedClasses = new HashSet();
        Processor processor = arg_0 -> SpringContextIncludeAnnotationFilter.lambda$getAnnotatedClasses$0((Set)annotatedClasses, arg_0);
        if (annotationClass.isAnnotationType()) {
            for (PsiPackage aPackage : packages) {
                GlobalSearchScope scope = searchScope.intersectWith(PackageScope.packageScope((PsiPackage)aPackage, (boolean)true));
                AnnotatedElementsSearch.searchPsiClasses((PsiClass)annotationClass, (SearchScope)scope).forEach(processor);
            }
        }
        return annotatedClasses;
    }

    private static /* synthetic */ boolean lambda$getAnnotatedClasses$0(Set annotatedClasses, PsiClass psiClass) {
        ContainerUtil.addIfNotNull((Object)psiClass, (Collection)annotatedClasses);
        return true;
    }
}

