/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextIncludeAssignableFilter
extends SpringContextFilter.IncludeExpression {
    public SpringContextIncludeAssignableFilter(@Nullable String expression) {
        super(expression);
    }

    @Override
    @NotNull
    public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAssignableFilter", "includeStereotypes"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAssignableFilter", "includeStereotypes"));
        }
        HashSet components = new HashSet();
        String fqn = this.getExpression();
        if (!StringUtil.isEmptyOrSpaces((String)fqn)) {
            GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            PsiClass assignableClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(fqn, searchScope);
            SpringContextIncludeAssignableFilter.addCustomComponents(packages, searchScope, (Set<SpringStereotypeElement>)components, assignableClass);
        }
        HashSet hashSet = components;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAssignableFilter", "includeStereotypes"));
        }
        return hashSet;
    }

    public static void addCustomComponents(@NotNull Set<PsiPackage> packages, @NotNull GlobalSearchScope searchScope, @NotNull Set<SpringStereotypeElement> components, @Nullable PsiClass assignableClass) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAssignableFilter", "addCustomComponents"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAssignableFilter", "addCustomComponents"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAssignableFilter", "addCustomComponents"));
        }
        if (assignableClass != null) {
            SpringContextIncludeAssignableFilter.addCustomComponent(components, assignableClass);
            for (PsiPackage aPackage : packages) {
                GlobalSearchScope pkgSearchScope = searchScope.intersectWith(PackageScope.packageScope((PsiPackage)aPackage, (boolean)true));
                Collection inheritors = ClassInheritorsSearch.search((PsiClass)assignableClass, (SearchScope)pkgSearchScope, (boolean)true).findAll();
                for (PsiClass psiClass : inheritors) {
                    SpringContextIncludeAssignableFilter.addCustomComponent(components, psiClass);
                }
            }
        }
    }

    public static void addCustomComponent(@NotNull Set<SpringStereotypeElement> components, @NotNull PsiClass componentCandidateClass) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAssignableFilter", "addCustomComponent"));
        }
        if (componentCandidateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentCandidateClass", "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAssignableFilter", "addCustomComponent"));
        }
        PsiModifierList modifierList = componentCandidateClass.getModifierList();
        if (componentCandidateClass.isInterface() || componentCandidateClass.isAnnotationType() || modifierList != null && modifierList.hasModifierProperty("abstract")) {
            return;
        }
        components.add(new CustomSpringComponent(componentCandidateClass));
    }
}

