/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.Idref;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringElementsHolder;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.spring.model.xml.beans.SpringMap;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringPropertyUtils {
    @Nullable
    public static GenericDomValue<?> getPropertyDomValue(@NotNull SpringValueHolderDefinition valueHolderDefinition) {
        if (valueHolderDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueHolderDefinition", "com/intellij/spring/model/utils/SpringPropertyUtils", "getPropertyDomValue"));
        }
        GenericDomValue<?> valueElement = valueHolderDefinition.getValueElement();
        return valueElement != null && valueElement.getStringValue() == null ? null : valueElement;
    }

    @NotNull
    public static Set<String> getArrayPropertyStringValues(@NotNull CommonSpringBean bean, @NotNull String propertyName) {
        SpringPropertyDefinition propertyDefinition;
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/utils/SpringPropertyUtils", "getArrayPropertyStringValues"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/model/utils/SpringPropertyUtils", "getArrayPropertyStringValues"));
        }
        com.intellij.util.containers.hash.HashSet set = new com.intellij.util.containers.hash.HashSet();
        String value = SpringPropertyUtils.getPropertyStringValue(bean, propertyName);
        if (value != null) {
            set.addAll(SpringCommonUtils.tokenize(value));
        } else if (bean instanceof SpringBean && (propertyDefinition = ((SpringBean)bean).getProperty(propertyName)) instanceof SpringProperty) {
            set.addAll(SpringPropertyUtils.getStringValues(((SpringProperty)propertyDefinition).getList()));
            set.addAll(SpringPropertyUtils.getStringValues(((SpringProperty)propertyDefinition).getSet()));
            set.addAll(SpringPropertyUtils.getStringValues(((SpringProperty)propertyDefinition).getArray()));
        }
        com.intellij.util.containers.hash.HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringPropertyUtils", "getArrayPropertyStringValues"));
        }
        return hashSet;
    }

    @NotNull
    private static Set<String> getStringValues(@NotNull CollectionElements elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/spring/model/utils/SpringPropertyUtils", "getStringValues"));
        }
        com.intellij.util.containers.hash.HashSet strings = new com.intellij.util.containers.hash.HashSet();
        for (SpringValue springValue : elements.getValues()) {
            ContainerUtil.addIfNotNull((Object)springValue.getStringValue(), (Collection)strings);
        }
        com.intellij.util.containers.hash.HashSet hashSet = strings;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringPropertyUtils", "getStringValues"));
        }
        return hashSet;
    }

    @Nullable
    public static String getPropertyStringValue(CommonSpringBean bean, String propertyName) {
        LocalSearchScope scope;
        Set stringExpressions;
        PsiMethod byMethodReturnTypeBeanClass;
        PsiMethod setter;
        PsiClass beanClass;
        if (bean instanceof SpringBean) {
            SpringPropertyDefinition property = ((SpringBean)bean).getProperty(propertyName);
            return property == null ? null : property.getValueAsString();
        }
        if (bean instanceof ContextJavaBean && (beanClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType())) != null && (setter = (PsiMethod)ObjectUtils.chooseNotNull((Object)(byMethodReturnTypeBeanClass = PropertyUtil.findPropertySetter((PsiClass)beanClass, (String)propertyName, (boolean)false, (boolean)true)), (Object)PropertyUtil.findPropertySetter((PsiClass)PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType(true)), (String)propertyName, (boolean)false, (boolean)true))) != null && !(stringExpressions = StringExpressionHelper.searchStringExpressions((PsiMethod)setter, (SearchScope)(scope = new LocalSearchScope((PsiElement)((ContextJavaBean)bean).getPsiElement())), (int)0)).isEmpty()) {
            return (String)((Pair)stringExpressions.iterator().next()).second;
        }
        return null;
    }

    @NotNull
    public static Set<String> getListOrSetValues(@NotNull SpringElementsHolder elementsHolder) {
        if (elementsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementsHolder", "com/intellij/spring/model/utils/SpringPropertyUtils", "getListOrSetValues"));
        }
        if (DomUtil.hasXml((DomElement)elementsHolder.getList())) {
            Set<String> set = SpringPropertyUtils.getValues(elementsHolder.getList());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringPropertyUtils", "getListOrSetValues"));
            }
            return set;
        }
        if (DomUtil.hasXml((DomElement)elementsHolder.getSet())) {
            Set<String> set = SpringPropertyUtils.getValues(elementsHolder.getSet());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringPropertyUtils", "getListOrSetValues"));
            }
            return set;
        }
        if (DomUtil.hasXml((DomElement)elementsHolder.getArray())) {
            Set<String> set = SpringPropertyUtils.getValues(elementsHolder.getArray());
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringPropertyUtils", "getListOrSetValues"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringPropertyUtils", "getListOrSetValues"));
        }
        return set;
    }

    @NotNull
    public static Set<String> getValues(@NotNull ListOrSet listOrSet) {
        if (listOrSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOrSet", "com/intellij/spring/model/utils/SpringPropertyUtils", "getValues"));
        }
        HashSet values = new HashSet();
        for (SpringValue value : listOrSet.getValues()) {
            ContainerUtil.addIfNotNull((Object)value.getStringValue(), (Collection)values);
        }
        HashSet hashSet = values;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/utils/SpringPropertyUtils", "getValues"));
        }
        return hashSet;
    }

    public static PsiArrayType getArrayType(@NotNull ListOrSet array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/spring/model/utils/SpringPropertyUtils", "getArrayType"));
        }
        PsiClass psiClass = (PsiClass)array.getValueType().getValue();
        if (psiClass != null) {
            return PsiTypesUtil.getClassType((PsiClass)psiClass).createArrayType();
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)array.getManager().getProject());
        return PsiType.getJavaLangObject((PsiManager)array.getXmlTag().getManager(), (GlobalSearchScope)scope).createArrayType();
    }

    public static boolean isSpecificProperty(@NotNull GenericDomValue value, @NotNull String propertyName, String ... classNames) {
        SpringBean bean;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/model/utils/SpringPropertyUtils", "isSpecificProperty"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/model/utils/SpringPropertyUtils", "isSpecificProperty"));
        }
        if (classNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classNames", "com/intellij/spring/model/utils/SpringPropertyUtils", "isSpecificProperty"));
        }
        SpringProperty springProperty = (SpringProperty)value.getParentOfType(SpringProperty.class, false);
        if (springProperty != null && propertyName.equals(springProperty.getPropertyName()) && (bean = (SpringBean)springProperty.getParentOfType(SpringBean.class, false)) != null) {
            PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType(true));
            if (beanClass == null) {
                return false;
            }
            for (String className : classNames) {
                if (!InheritanceUtil.isInheritor((PsiClass)beanClass, (String)className)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static SpringPropertyDefinition findPropertyByName(@NotNull CommonSpringBean bean, @NotNull String propertyName) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/utils/SpringPropertyUtils", "findPropertyByName"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/model/utils/SpringPropertyUtils", "findPropertyByName"));
        }
        return bean instanceof SpringBean ? ((SpringBean)bean).getProperty(propertyName) : null;
    }

    public static List<SpringValueHolderDefinition> getValueHolders(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/utils/SpringPropertyUtils", "getValueHolders"));
        }
        return bean instanceof DomSpringBean ? DomUtil.getDefinedChildrenOfType((DomElement)((DomElement)bean), SpringValueHolderDefinition.class) : Collections.emptyList();
    }

    public static List<SpringPropertyDefinition> getProperties(@NotNull CommonSpringBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/spring/model/utils/SpringPropertyUtils", "getProperties"));
        }
        return bean instanceof DomSpringBean ? DomUtil.getDefinedChildrenOfType((DomElement)((DomElement)bean), SpringPropertyDefinition.class) : Collections.emptyList();
    }

    public static List<SpringBeanPointer> getSpringValueHolderDependencies(SpringValueHolderDefinition valueHolder) {
        return new ArrayList<SpringBeanPointer>(SpringPropertyUtils.getValueHolderDependencies(valueHolder).keySet());
    }

    public static Map<SpringBeanPointer, DomElement> getValueHolderDependencies(SpringValueHolderDefinition valueHolder) {
        LinkedHashMap<SpringBeanPointer, DomElement> beans = new LinkedHashMap<SpringBeanPointer, DomElement>();
        SpringPropertyUtils.addValueHolder(valueHolder, beans);
        return beans;
    }

    private static void addValueHolder(SpringValueHolderDefinition definition, Map<SpringBeanPointer, DomElement> beans) {
        GenericDomValue<SpringBeanPointer> element = definition.getRefElement();
        if (element != null) {
            SpringPropertyUtils.addBasePointer(element, beans);
        }
        if (definition instanceof SpringValueHolder) {
            SpringBean innerBean;
            SpringValueHolder valueHolder = (SpringValueHolder)definition;
            SpringPropertyUtils.addSpringRefBeans(valueHolder.getRef(), beans);
            SpringPropertyUtils.addIdrefBeans(valueHolder.getIdref(), beans);
            SpringPropertyUtils.processCollections(beans, valueHolder);
            if (DomUtil.hasXml((DomElement)valueHolder.getMap())) {
                SpringPropertyUtils.addMapReferences(valueHolder.getMap(), beans);
            }
            if (DomUtil.hasXml((DomElement)(innerBean = valueHolder.getBean()))) {
                beans.put(BeanService.getInstance().createSpringBeanPointer(innerBean), innerBean);
            }
        }
    }

    private static void processCollections(Map<SpringBeanPointer, DomElement> beans, SpringValueHolder valueHolder) {
        List listOrSets = DomUtil.getChildrenOfType((DomElement)valueHolder, ListOrSet.class);
        for (ListOrSet listOrSet : listOrSets) {
            DomElement domElement = listOrSet.getManager().getDomElement(listOrSet.getXmlTag());
            if (domElement instanceof DomSpringBean) {
                beans.put(BeanService.getInstance().createSpringBeanPointer((DomSpringBean)domElement), domElement);
                continue;
            }
            SpringPropertyUtils.addCollectionReferences(listOrSet, beans);
        }
    }

    private static void addBasePointer(@NotNull GenericDomValue<SpringBeanPointer> value, Map<SpringBeanPointer, DomElement> beans) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/model/utils/SpringPropertyUtils", "addBasePointer"));
        }
        SpringBeanPointer beanPointer = (SpringBeanPointer)value.getValue();
        if (beanPointer == null) {
            return;
        }
        SpringBeanPointer basePointer = beanPointer.getBasePointer();
        beans.put(basePointer, (DomElement)value);
    }

    private static void addMapReferences(SpringMap map, Map<SpringBeanPointer, DomElement> beans) {
        for (SpringEntry entry : map.getEntries()) {
            SpringPropertyUtils.addValueHolder(entry, beans);
        }
    }

    private static void addIdrefBeans(Idref idref, Map<SpringBeanPointer, DomElement> beans) {
        SpringPropertyUtils.addBasePointer(idref.getLocal(), beans);
        SpringPropertyUtils.addBasePointer(idref.getBean(), beans);
    }

    private static void addSpringRefBeans(SpringRef springRef, Map<SpringBeanPointer, DomElement> beans) {
        if (DomUtil.hasXml((DomElement)springRef)) {
            SpringPropertyUtils.addBasePointer(springRef.getBean(), beans);
            SpringPropertyUtils.addBasePointer(springRef.getLocal(), beans);
        }
    }

    public static void addCollectionReferences(CollectionElements elements, Map<SpringBeanPointer, DomElement> beans) {
        for (SpringRef springRef : elements.getRefs()) {
            SpringPropertyUtils.addSpringRefBeans(springRef, beans);
        }
        for (Idref idref : elements.getIdrefs()) {
            SpringPropertyUtils.addIdrefBeans(idref, beans);
        }
        for (ListOrSet listOrSet : elements.getLists()) {
            SpringPropertyUtils.addCollectionReferences(listOrSet, beans);
        }
        for (ListOrSet listOrSet : elements.getSets()) {
            SpringPropertyUtils.addCollectionReferences(listOrSet, beans);
        }
        for (ListOrSet listOrSet : elements.getArrays()) {
            SpringPropertyUtils.addCollectionReferences(listOrSet, beans);
        }
        for (SpringBean innerBean : elements.getBeans()) {
            beans.put(BeanService.getInstance().createSpringBeanPointer(innerBean), innerBean);
        }
        for (SpringMap map : elements.getMaps()) {
            SpringPropertyUtils.addMapReferences(map, beans);
        }
    }

    public static List<SpringBeanPointer> getCollectionElementDependencies(CollectionElements collectionElements) {
        LinkedHashMap<SpringBeanPointer, DomElement> beans = new LinkedHashMap<SpringBeanPointer, DomElement>();
        SpringPropertyUtils.addCollectionReferences(collectionElements, beans);
        return new ArrayList<SpringBeanPointer>(beans.keySet());
    }

    public static boolean processSpringValues(SpringProperty property, PairProcessor<GenericDomValue, String> processor) {
        GenericAttributeValue<String> valueAttr = property.getValueAttr();
        XmlAttribute valueAttrElement = valueAttr.getXmlAttribute();
        String valueAttrString = valueAttr.getStringValue();
        if (valueAttrElement != null && valueAttrString != null && !processor.process(valueAttr, (Object)valueAttrString)) {
            return false;
        }
        SpringValue value = property.getValue();
        XmlTag valueElement = value.getXmlTag();
        String valueString = value.getStringValue();
        if (valueElement != null && valueString != null && !processor.process((Object)value, (Object)valueString)) {
            return false;
        }
        if (!SpringPropertyUtils.processSpringListOrSetValues(property.getList(), processor)) {
            return false;
        }
        if (!SpringPropertyUtils.processSpringListOrSetValues(property.getSet(), processor)) {
            return false;
        }
        if (!SpringPropertyUtils.processSpringListOrSetValues(property.getArray(), processor)) {
            return false;
        }
        if (!SpringPropertyUtils.processSpringPointerValue(property.getRefAttr(), processor)) {
            return false;
        }
        return SpringPropertyUtils.processSpringPointerValue(property.getRef().getBean(), processor);
    }

    private static boolean processSpringPointerValue(GenericAttributeValue<SpringBeanPointer> pointerValue, PairProcessor<GenericDomValue, String> processor) {
        CommonSpringBean bean;
        SpringBeanPointer pointer = (SpringBeanPointer)pointerValue.getValue();
        CommonSpringBean commonSpringBean = bean = pointer == null ? null : (CommonSpringBean)pointer.getSpringBean();
        if (bean instanceof ListOrSet) {
            if (!SpringPropertyUtils.processSpringListOrSetValues((ListOrSet)((Object)bean), processor)) {
                return false;
            }
        } else if (bean != null) {
            SpringPropertyDefinition value = SpringPropertyUtils.findPropertyByName(bean, "sourceList");
            if (value == null) {
                value = SpringPropertyUtils.findPropertyByName(bean, "sourceSet");
            }
            if (value instanceof SpringProperty && !SpringPropertyUtils.processSpringListOrSetValues(((SpringProperty)value).getList(), processor)) {
                return false;
            }
        }
        return true;
    }

    private static boolean processSpringListOrSetValues(ListOrSet listOrSet, PairProcessor<GenericDomValue, String> processor) {
        for (SpringValue springValue : listOrSet.getValues()) {
            XmlTag element = springValue.getXmlTag();
            String string = springValue.getStringValue();
            if (element == null || string == null || processor.process((Object)springValue, (Object)string)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static SpringBeanPointer findReferencedBean(@NotNull SpringPropertyDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/spring/model/utils/SpringPropertyUtils", "findReferencedBean"));
        }
        SpringBeanPointer springBeanPointer = definition.getRefValue();
        if (springBeanPointer != null) {
            return springBeanPointer;
        }
        return definition instanceof SpringInjection ? SpringPropertyUtils.findReferencedBean((SpringInjection)((Object)definition)) : null;
    }

    @Nullable
    public static SpringBeanPointer findReferencedBean(@NotNull SpringInjection injection) {
        if (injection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injection", "com/intellij/spring/model/utils/SpringPropertyUtils", "findReferencedBean"));
        }
        SpringBeanPointer refAttrPointer = (SpringBeanPointer)injection.getRefAttr().getValue();
        if (refAttrPointer != null) {
            return refAttrPointer;
        }
        if (DomUtil.hasXml((DomElement)injection.getRef())) {
            SpringRef springRef = injection.getRef();
            SpringBeanPointer beanPointer = (SpringBeanPointer)springRef.getBean().getValue();
            if (beanPointer != null) {
                return beanPointer;
            }
            SpringBeanPointer localPointer = (SpringBeanPointer)springRef.getLocal().getValue();
            if (localPointer != null) {
                return localPointer;
            }
            SpringBeanPointer parentPointer = (SpringBeanPointer)springRef.getParentAttr().getValue();
            if (parentPointer != null) {
                return parentPointer;
            }
        } else if (DomUtil.hasXml((DomElement)injection.getBean())) {
            return BeanService.getInstance().createSpringBeanPointer(injection.getBean());
        }
        return null;
    }
}

